
/* findslot.c
 * 
 * Kevin Smith 03/23/88
 * 
 */
#include "config.h"
#include "copyright2.h"

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <pwd.h>
#include <string.h>
#include <ctype.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

#define WAITMOTD

#define WAITWIDTH 180
#define WAITHEIGHT 60
#define WAITTITLE 15				 /* height of title for wait
						  * window */

findslot(void)
{
  int     oldcount = -1;
  W_Window waitWin, qwin, countWin;

  W_Window MotdWin;
  extern int MaxMotdLine;
  int     WaitMotdLine = 0;
  W_Event event;


  /* Wait for some kind of indication about in/not in */
  while (queuePos == -1)
    {
      socketPause();
      if (isServerDead())
	{

#ifdef SOUND
	  Exit_Sound();
#endif

	  printf("Shit!  Ghostbusted!\n");
	  exit(0);
	}
      readFromServer(NULL);
      if (me != NULL)
	{
	  /* We are in! */
	  ANNOUNCESOCKET;
	  return (me->p_no);
	}
    }

  /* We have to wait.  Make appropriate windows, etc... */
  waitWin = W_MakeWindow("wait", 0, 0, WAITWIDTH, WAITHEIGHT, NULL, 2, foreColor);
  countWin = W_MakeWindow("count", WAITWIDTH / 2, WAITTITLE, WAITWIDTH / 2,
			  WAITHEIGHT - WAITTITLE, waitWin, 1, foreColor);
  qwin = W_MakeWindow("waitquit", 0, WAITTITLE, WAITWIDTH / 2, WAITHEIGHT - WAITTITLE,
		      waitWin, 1, foreColor);
  if (booleanDefault("showMotd", 1))
    {
      MotdWin = W_MakeWindow("waitmotd", 0, WAITWIDTH + 1, 500, 500, 0, 2, foreColor);
      W_MapWindow(MotdWin);
      showMotd(MotdWin, WaitMotdLine);
    }
  W_MapWindow(waitWin);
  W_MapWindow(countWin);
  W_MapWindow(qwin);
  for (;;)
    {
      socketPause();
      readFromServer(NULL);
      if (isServerDead())
	{

#ifdef SOUND
	  Exit_Sound();
#endif

	  printf("Damn, We've been ghostbusted!\n");
	  exit(0);
	}
      while (W_EventsPending())
	{
	  W_NextEvent(&event);
	  switch ((int) event.type)
	    {
	    case W_EV_BUTTON:
	    case W_EV_KEY:
	      if (booleanDefault("showMotd", 1))
		{
		  if (event.Window == MotdWin)
		    {
		      if (event.key == 'b')
			{
			  WaitMotdLine -= 28;
			  WaitMotdLine = MAX(WaitMotdLine, 0);
			}
		      else
			{
			  WaitMotdLine += 28;
			  /* scroll to start if it goes over */
			  if (WaitMotdLine > MaxMotdLine)
			    WaitMotdLine = 0;
			}
		      W_ClearWindow(MotdWin);
		      showMotd(MotdWin, WaitMotdLine);
		      break;
		    }
		}
	      if (event.Window == qwin)
		{

#ifdef SOUND
		  Exit_Sound();
#endif

		  printf("OK, bye!\n");
		  exit(0);
		}
	      break;
	    case W_EV_EXPOSE:
	      if (event.Window == waitWin)
		{
		  mapWaitWin(waitWin);
		}
	      else if (event.Window == MotdWin)
		{
		  showMotd(MotdWin, WaitMotdLine);
		}
	      else if (event.Window == qwin)
		{
		  mapWaitQuit(qwin);
		}
	      else if (event.Window == countWin)
		{
		  mapWaitCount(countWin, queuePos);
		}
	      break;
	    default:
	      break;
	    }
	}
      if (queuePos != oldcount)
	{
	  mapWaitCount(countWin, queuePos);
	  oldcount = queuePos;
	}
      if (me != NULL)
	{
	  W_DestroyWindow(waitWin);
	  if (booleanDefault("showMotd", 1))
	    {
	      W_DestroyWindow(MotdWin);
	    }
	  ANNOUNCESOCKET;
	  W_Beep();
	  W_Beep();
	  return (me->p_no);
	}
    }
}

mapWaitWin(W_Window waitWin)
{
  char   *s;
  char    buf[60];

  sprintf(buf, "Game full at %s", serverName);
  s = buf;

  W_WriteText(waitWin, 15, 5, textColor, s, strlen(s), W_RegularFont);
}

mapWaitQuit(W_Window qwin)
{
  char   *s = "Quit";

  W_WriteText(qwin, 10, 15, textColor, s, strlen(s), W_RegularFont);
}

mapWaitCount(W_Window countWin, unsigned int count)
{
  char   *s = "Wait Queue";
  char    buf[10];

  W_WriteText(countWin, 5, 10, textColor, s, strlen(s), W_RegularFont);
  sprintf(buf, "%d    ", count);
  if (count == -1)
    STRNCPY(buf, "?", 2);
  W_WriteText(countWin, 5, 25, textColor, buf, strlen(buf), W_RegularFont);
}
