#include "myxlib.h"
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/Drawing.h>
#include <X11/Xmu/Converters.h>

#ifndef   NOXPM
# include <X11/xpm.h>
#endif /* NOXPM */
#include "mymalloc.h"
#include <string.h>
#if !STDC_HEADERS && HAVE_MEMORY_H
# include <memory.h>
#endif /* not STDC_HEADERS and HAVE_MEMORY_H */
#include <ctype.h>

#ifdef    HAVE_NO_MEMCHR_PROTO
extern void *memchr(const void *s, int c, size_t n);
#endif /* HAVE_NO_MEMCHR_PROTO */

#define offset(field) (XtPointer) XtOffset(WidgetRec *, core.field)
static XtConvertArgRec ScreenConvertArg[] = {
    { XtWidgetBaseOffset, offset(screen),   sizeof(Screen *) },
    { XtWidgetBaseOffset, offset(colormap), sizeof(Colormap) },
    { XtWidgetBaseOffset, offset(depth),    sizeof(Cardinal) }
};

static XtConvertArgRec ColorConvertArg[] = {
    { XtWidgetBaseOffset, offset(screen),   sizeof(Screen *) },
    { XtWidgetBaseOffset, offset(colormap), sizeof(Colormap) }
};

# ifndef NOSTRINTOWIDGET
static XtConvertArgRec ParentConvertArg[] = {
    { XtWidgetBaseOffset, offset(parent),   sizeof(Widget) },
};
# endif /* NOSTRINGTOWIDGET */
#undef offset

#define	olddone(address, type)          \
do {                                    \
    toVal->size = sizeof(type);         \
    toVal->addr = (XPointer) address;   \
    return;                             \
} while(0)

#define	olddone(address, type)          \
do {                                    \
    toVal->size = sizeof(type);         \
    toVal->addr = (XPointer) address;   \
    return;                             \
} while(0)

#define	done(type, value)                               \
do {                                                    \
    if (toVal->addr != NULL) {				\
        if (toVal->size < sizeof(type)) {		\
	    toVal->size = sizeof(type);			\
	    return False;				\
	}						\
        *(type*)(toVal->addr) = (value);		\
    } else {						\
	static type static_val;				\
	static_val = (value);				\
	toVal->addr = (XtPointer)&static_val;		\
    }							\
    toVal->size = sizeof(type);				\
    return True;					\
} while(0)

/*****************************************************************************/
/* A String to Pixmap converter                                              */
/* todo: decent file path                                                    */
/*       decent color caching on xpm                                         */
/*****************************************************************************/

Boolean MyCvtStringToPixel(Display* disp, XrmValuePtr args, Cardinal *num_args,
                           XrmValuePtr fromVal, XrmValuePtr toVal,
                           XtPointer *closure_ret)
{
    Display   *dpy;
    String     str;
    XColor     screenColor;
    XColor     exactColor;
    Screen    *screen;
    Colormap   colormap;
    Status     status;
    String     params[1];

    str = (String)fromVal->addr;
    if (*num_args != XtNumber(ColorConvertArg)) {
        XtAppErrorMsg(XtDisplayToApplicationContext(disp),
                      "wrongParameters", "myCvtStringToPixel", "myProgsError",
                      "String to pixel conversion needs 3 arguments",
                      (String *)NULL, (Cardinal *)NULL);
        return False;
    }

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    dpy = DisplayOfScreen(screen);

    if (XmuCompareISOLatin1(str, XtDefaultBackground) == 0) {
	*closure_ret = False;
        if (ReverseP(dpy)) done(Pixel, BlackPixelOfScreen(screen));
        else               done(Pixel, WhitePixelOfScreen(screen));
    } 
    if (XmuCompareISOLatin1(str, XtDefaultForeground) == 0) {
	*closure_ret = False;
        if (ReverseP(dpy)) done(Pixel, WhitePixelOfScreen(screen));
        else               done(Pixel, BlackPixelOfScreen(screen));
    }

    status = XAllocNamedColor(DisplayOfScreen(screen), colormap,
			      (char*)str, &screenColor, &exactColor);
    if (status == 0) {
	String msg, type;
	params[0] = str;
	/* Server returns a specific error code but Xlib discards it.  Ugh */
	if (XLookupColor(DisplayOfScreen(screen), colormap, (char*)str,
			 &exactColor, &screenColor)) {
	    type = "noColormap";
	    msg = "Cannot allocate colormap entry for \"%s\"";
	}
	else {
	    type = "badValue";
	    msg = "Color name \"%s\" is not defined";
	}

        XtDisplayStringConversionWarning(disp, str, "Pixel");
	*closure_ret = False;
	return False;
    } else {
	*closure_ret = (char*) True;
        done(Pixel, screenColor.pixel);
    }
}

static void MyFreePixel(XtAppContext app, XrmValuePtr toVal, XtPointer closure,
                        XrmValuePtr args, Cardinal *num_args)
{
    Screen  *screen;
    Colormap colormap;

    if (*num_args != XtNumber(ColorConvertArg)) {
        XtAppWarningMsg(app, "wrongParameters", "myFreePixel",
                        "XtToolkitError", "Freeing a pixel requires screen"
                        "and colormap arguments", (String *)NULL,
                        (Cardinal *) NULL);
        return;
    }

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (closure) XFreeColors(DisplayOfScreen(screen), colormap,
                             (unsigned long*)toVal->addr, 1, (unsigned long)0);
}

/*ARGSUSED*/
static Boolean MyCvtStringToPixmap(Display *disp,
                                   XrmValuePtr args, Cardinal *num_args,
                                   XrmValuePtr fromVal, XrmValuePtr toVal,
                                   XtPointer *ConvertData)
{
    Pixmap         pixmap, temp;
    Pixel          fg, bg;
    char          *name, myname[100], *ptr1, *ptr2, *ptr3, *ptr4;
    Screen        *screen;
    Display       *dpy;
    XrmDatabase    db;
    XrmValue       FromString, ToPixel;
    String         fn;
    unsigned int   width, height;
    int            xhot, yhot, depth;
    unsigned char *data;
    XtCacheRef    *refs;

    name = (char *) fromVal->addr;
    if (*num_args != 3)
        XtAppErrorMsg(XtDisplayToApplicationContext(disp),
                      "wrongParameters","cvtStringToPixmap","myProgsError",
                      "String to pixmap conversion needs 3 arguments",
                      (String *)NULL, (Cardinal *)NULL);

    *ConvertData = NULL;
    if (strcmp(name, "None") == 0) {
	pixmap = None;
	done(Pixmap, pixmap);
    } else if (strcmp(name, "ParentRelative") == 0) {
	pixmap = ParentRelative;
	done(Pixmap, pixmap);
    } else if (strcmp(name, "XtUnspecifiedPixmap") == 0) {
	pixmap = XtUnspecifiedPixmap;
	done(Pixmap, pixmap);
    }
    
    screen = *(Screen **)       args[0].addr;
    depth  = *(unsigned int *)  args[2].addr;

    dpy = DisplayOfScreen(screen);
    if (ReverseP(dpy)) {
        bg = BlackPixelOfScreen(screen);
        fg = WhitePixelOfScreen(screen);
    } else {
        bg = WhitePixelOfScreen(screen);
        fg = BlackPixelOfScreen(screen);
    }

    ConvertData = refs = mynews(XtCacheRef, 3);
    refs[0] = refs[1] = refs[2] = NULL;

    ptr1 = strchr(name, '(');
    if (ptr1) {
        strncpy(myname, name, sizeof(myname)-1);
        myname[sizeof(myname)-1] = 0;
        ptr1 = myname+(ptr1-name); 
        *ptr1++ = 0;
        while (isspace(*ptr1)) ptr1++;
        ptr2 = strchr(ptr1, ')');
        if (ptr2) {
            ptr2--;
            while (isspace(*ptr2)) ptr2--;
            ptr2[1] = 0;
        }
  
        ptr2 = strchr(ptr1, ',');
        if (ptr2) {
            ptr3 = ptr2-1;
            while (isspace(*ptr3)) ptr3--;
            ptr3[1] = 0;

            *ptr2++ = 0;
            while (isspace(*ptr2)) ptr2++;
            ptr3 = strchr(ptr2, ',');
            if (ptr3) {
                ptr4 = ptr3-1;
                while (isspace(*ptr4)) ptr4--;
                ptr4[1] = 0;

                *ptr3++ = 0;
                while (isspace(*ptr3)) ptr3++;
                FromString.size = strlen(ptr3)+1;
                FromString.addr = (XPointer) ptr3;
                ToPixel.size = sizeof(Pixel);
                ToPixel.addr = (XPointer) &fg;
                XtCallConverter(dpy, MyCvtStringToPixel, args, 2,
                                &FromString, &ToPixel, refs);
                if (*refs) refs++;
            }
            FromString.size = strlen(ptr2)+1;
            FromString.addr = (XPointer) ptr2;
            ToPixel.size = sizeof(Pixel);
            ToPixel.addr = (XPointer) &bg;
            XtCallConverter(dpy, MyCvtStringToPixel, args, 2,
                            &FromString, &ToPixel, refs);
            if (*refs) refs++;
        }
        name = ptr1;
    }

    if (XmuCompareISOLatin1(myname, "bitmap") == 0) {
/* Seems this can break the X connection.... */
        temp = XmuLocateBitmapFile(screen, name, NULL, 0, (int *) &width,
                                   (int *) &height, NULL, NULL);
        if (temp == None) {
#ifndef   R4
            db = XrmGetDatabase(dpy);
            XrmSetDatabase(dpy, XtScreenDatabase(screen));
#endif /* R4 */
            fn = XtResolvePathname(dpy, "bitmaps", name, "",
                                   NULL, NULL, 0, 0);
            if (!fn)
                fn = XtResolvePathname(dpy, "", name, ".xbm",
                                       NULL, NULL, 0, 0);
#ifndef   R4
            XrmSetDatabase(dpy, db);
#endif /* R4 */
            if (fn) {
                if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
                                              &xhot, &yhot) == BitmapSuccess) {
                    temp = XCreatePixmapFromBitmapData(dpy, 
                            RootWindowOfScreen(screen), (char *) data,
                            width, height, 1, 0, 1);
                    XFree((char *)data);
                }
                XtFree(fn);
            }
        }
    
        if (temp == None) pixmap = None;
        else {
            pixmap = XmuCreatePixmapFromBitmap(dpy, RootWindowOfScreen(screen),
                                               temp, width, height, depth,
                                               fg, bg);
            XFreePixmap(dpy, temp);
        }

        if (pixmap != None) done (Pixmap, pixmap);
    }
#ifndef   NOXPM
    else if (XmuCompareISOLatin1(myname, "pixmap") == 0) {
        if (XpmSuccess == XpmReadFileToPixmap(dpy, RootWindowOfScreen(screen),
                                              name, &pixmap, NULL, NULL))
            done(Pixmap, pixmap);
    }
#endif /* NOXPM */    
    XtDisplayStringConversionWarning(disp, name, "Pixmap");
    return False;
}

static void PixmapDestructor(XtAppContext App, XrmValuePtr To,
                             XtPointer ConvertData,
                             XrmValuePtr Args, Cardinal *n)
{
    Display *dpy;

    dpy = DisplayOfScreen(*(Screen **) Args[0].addr);
    XFreePixmap(dpy, * (Pixmap *) To->addr);

    if (ConvertData) {
        XtAppReleaseCacheRefs(App, (XtCacheRef *) ConvertData);
        myfree(ConvertData);
    }
}

/*ARGSUSED*/
static Boolean MyCvtStringToStringList(Display *disp,
                                       XrmValuePtr args, Cardinal *num_args,
                                       XrmValuePtr fromVal, XrmValuePtr toVal,
                                       XtPointer *ConvertData)
{
    String str;
    char  *ptr, **Str, ch, *From;
    int    Nr, *Len;
    StringList *result;

    if (*num_args != 0) {
        XtAppErrorMsg(XtDisplayToApplicationContext(disp),
                      "wrongParameters", "myCvtStringToStringList",
                      "myProgsError",
                      "String to Stringlist conversion needs no arguments",
                      (String *)NULL, (Cardinal *)NULL);
        return False;
    }
    str = (String)fromVal->addr;
    if (!str) done(StringListPtr, NULL);

    result = mynew(StringList);
    Nr = 1;
    for (ptr = str; (ch = *ptr) != 0; ptr++) if (ch == '\n') Nr++;
    result->Nr = Nr;
    result->String = Str = mynews(char *, Nr);
    result->Length = Len = mynews(int,    Nr);
    From = str;
    for (ptr = str; (ch = *ptr) != 0; ptr++) 
        if (ch == '\n') {
            *Len = ptr-From;
            *Str = mystrndup(From, *Len);
            Len++, Str++;
            From = ptr+1;
        }
    *Len = ptr-From;
    *Str = mystrndup(From, *Len);
    done(StringListPtr, result);
}

/*ARGSUSED*/
static void MyFreeStringList(XtAppContext App, XrmValuePtr To,
                             XtPointer ConvertData,
                             XrmValuePtr Args, Cardinal *n)
{
    StringList *result;
    char      **Str;
    int         i;

    result = *(StringList **) To->addr;
    if (result) {
        for (i = result->Nr, Str = result->String; i>0; i--, Str++)
            myfree(*Str);
        myfree(result);
    }
}

/*ARGSUSED*/
static Boolean
MyCvtStringToStringPairList(Display *disp,
                            XrmValuePtr args, Cardinal *num_args,
                            XrmValuePtr fromVal, XrmValuePtr toVal,
                            XtPointer *ConvertData)
{
    String str;
    char  *ptr, **Str1, **Str2, *Str, *Sep, ch;
    int    Nr, *Len1, *Len2;
    StringPairList *result;

    if (*num_args != 0) {
        XtAppErrorMsg(XtDisplayToApplicationContext(disp),
                      "wrongParameters", "myCvtStringToStringList",
                      "myProgsError",
                      "String to Stringlist conversion needs no arguments",
                      (String *)NULL, (Cardinal *)NULL);
        return False;
    }
    str = (String)fromVal->addr;
    if (!str) done(StringPairListPtr, NULL);

    result = mynew(StringPairList);
    Nr = 1;
    for (ptr = str; (ch = *ptr) != 0; ptr++) if (ch == '\n') Nr++;
    result->Nr = Nr;
    result->Length1 = Len1 = mynews(int,    Nr);
    result->String1 = Str1 = mynews(char *, Nr);
    result->Length2 = Len2 = mynews(int,    Nr);
    result->String2 = Str2 = mynews(char *, Nr);
    Str = str;
    for (ptr = str; (ch = *ptr) != 0; ptr++) 
        if (ch == '\n') {
            *Len1 = ptr-Str;
            Sep = memchr(Str, ',', *Len1);
            if (Sep) {
                *Len1 = Sep-Str;
                *Str1 = mystrndup(Str, *Len1);
                Sep++;
                *Len2 = ptr-Sep;
                *Str2 = mystrndup(Sep, *Len2);
            } else {
                *Str1 = mystrndup(Str, *Len1);
                *Str2 = NULL;
                *Len2 = 0;
            }
            Len1++, Str1++; Len2++; Str2++;
            Str = ptr+1;
        }
    *Len1 = ptr-Str;
    Sep = memchr(Str, ',', *Len1);
    if (Sep) {
        *Len1 = Sep-Str;
        *Str1 = mystrndup(Str, *Len1);
        Sep++;
        *Len2 = ptr-Sep;
        *Str2 = mystrndup(Sep, *Len2);
    } else {
        *Str1 = mystrndup(Str, *Len1);
        *Str2 = NULL;
        *Len2 = 0;
    }
    done(StringPairListPtr, result);
}

/*ARGSUSED*/
static void MyFreeStringPairList(XtAppContext App, XrmValuePtr To,
                                 XtPointer ConvertData,
                                 XrmValuePtr Args, Cardinal *n)
{
    StringPairList *result;
    char          **Str1, **Str2;
    int             i;

    result = *(StringPairList **) To->addr;
    if (result) {
        for (i = result->Nr, Str1 = result->String1, Str2 = result->String2;
             i>0; i--, Str1++, Str2++) {
            myfree(*Str1);
            myfree(*Str2);
        }
        myfree(result);
    }
}

#ifndef   NOSTRINTOWIDGET
/*ARGSUSED*/
Boolean XmuNewCvtStringToWidget(Display *dpy,
                                XrmValuePtr args, Cardinal *num_args,
                                XrmValuePtr fromVal, XrmValuePtr toVal,
                                XtPointer *converter_data)
{
    Widget w, parent;

    if (*num_args != 1)
	XtAppWarningMsg(XtDisplayToApplicationContext(dpy),
			"wrongParameters","myCvtStringToWidget",
                        "myProgsError",
                        "String To Widget conversion needs parent argument",
			(String *)NULL, (Cardinal *)NULL);

    parent = *(Widget *) args[0].addr;
    w      = MyNameToWidget(parent, fromVal->addr);
    if (w) done(Widget, w);
    XtDisplayStringConversionWarning(dpy, (String)fromVal->addr, XtRWidget);
    return False;
}

/* ARGSUSED */
void XmuCvtStringToWidget(XrmValuePtr args, Cardinal *num_args,
                          XrmValuePtr fromVal, XrmValuePtr toVal)
{
    static Widget w, parent;

    if (*num_args != 1)
	XtErrorMsg("wrongParameters", "cvtStringToWidget", "xtToolkitError",
		   "StringToWidget conversion needs parent arg", NULL, 0);

    parent = *(Widget *)args[0].addr;
    parent = MyNameToWidget(parent, fromVal->addr);
    if (parent) {
        w = parent;
        olddone(&w, Widget);
    }
    XtStringConversionWarning(fromVal->addr, XtRWidget);
    toVal->addr = NULL;
    toVal->size = 0;
}
#endif /* NOSTRINGTOWIDGET */

/*****************************************************************************/
/* Make all converters available                                             */
/*****************************************************************************/

void GetConverters(void)
{
    XtSetTypeConverter(XtRString, XtRPixmap, MyCvtStringToPixmap,
                       ScreenConvertArg, XtNumber(ScreenConvertArg),
                       XtCacheByDisplay, PixmapDestructor);
    XtSetTypeConverter(XtRString, XtRPixel, MyCvtStringToPixel,
                       ColorConvertArg, XtNumber(ColorConvertArg),
                       XtCacheByDisplay, MyFreePixel);
    XtSetTypeConverter(XtRString, XtRStringList, MyCvtStringToStringList,
                       NULL, 0, XtCacheNone, MyFreeStringList);
    XtSetTypeConverter(XtRString, XtRStringPairList,
                       MyCvtStringToStringPairList,
                       NULL, 0, XtCacheNone, MyFreeStringPairList);
#ifndef   NOSTRINTOWIDGET
    XtSetTypeConverter(XtRString, XtRWidget, XmuNewCvtStringToWidget,
                       ParentConvertArg, XtNumber(ParentConvertArg),
                       XtCacheNone, 0);
#endif /* NOSTRINGTOWIDGET */
}
