#ifndef XGOSPEL_H
# define XGOSPEL_H

# include <stdio.h>
# include <X11/Intrinsic.h>

typedef struct {
    String  User, Password, Maintainer, Version, VersionMessage;
    String  Directory;
    String  SgfFilename, PsFilename, KibitzFilename, BroadcastFilename;
    String  YellFilename, IgsMessageFilename, TellFilename, MessageFilename;
    String  EventsFilename, AnalyzeFilename, GamesFilename, PlayersFilename;
    String  MainFilename;
    struct _StringPairList *PlayerToWidget;
    struct _StringList     *Friends;
    String  Site;
    int     Port;
    int     DebugFun;
    String  DebugFile;
    int     TellSize, YellSize, KibitzSize, BroadcastSize;
    int     ReplayTimeout, WhoTimeout, GamesTimeout, ReviewsTimeout;
    int     ServerTimeout, QuitTimeout, ReconnectTimeout, PlayerUpdateTimeout;
    int     PlayersScale, GamesScale, ScrollUnit;
    int     AnalyzeSize;
    Boolean SortPlayersByStrength, SortGamesByStrength;
    Boolean WantStdout, TersePlay;
    String  DateFormat, SgfDateFormat;
} AppData, *AppDataPtr;

extern AppData appdata;
extern FILE   *DebugFile;
extern int     DebugFun, DebugPending, Entered;
extern Widget  toplevel;
extern char   *MyPassword, *MyName, *UserId;
extern char   *SgfDateFormat;

extern void IgsPrompt(void);
extern int  Output(const char *Text); 
# ifndef HAVE_NO_STDARG_H
extern int Outputf(const char *Comment, ...);
# else  /* HAVE_NO_STDARG_H */
extern int Outputf();
# endif /* HAVE_NO_STDARG_H */
#endif /* XGOSPEL_H */
