/*
 * Copyright (c) 1995 David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 */

#include "life.h"


static char *	SafeAlloc PROTO((int));


/*
 * Allocate a new object structure.
 * It contains one row element, the termrow.
 * We quit if the allocation fails.
 */
OBJECT *
AllocateObject()
{
	OBJECT *obj;

	obj = freeobjects;

	if (obj)
		freeobjects = obj->next;
	else {
		obj = newobjects;

		if (obj >= endobjects) {
			obj = (OBJECT *) SafeAlloc(sizeof(OBJECT) * ALLOCOBJ);

			newobjects = obj;
			endobjects = obj + ALLOCOBJ;
		}

		newobjects++;
	}

	obj->next = NULL;
	obj->firstrow = termrow;
	obj->lastrow = NULL;
	obj->reserved = reserve;
	obj->name[0] = '\0';
	obj->count = 0;
	obj->gen = 0;
	obj->currow = 0;
	obj->curcol = 0;
	obj->origrow = 0;
	obj->origcol = 0;
	obj->mark = 0;
	obj->update = 0;
	obj->viewrows = 0;
	obj->viewcols = 0;
	obj->autoscale = FALSE;
	obj->frequency = defaultfrequency;

	memset(obj->wherelocs, 0, sizeof(obj->wherelocs));

	InitializePath(obj);
	SetScale(obj, defaultscale);

	return obj;
}


/*
 * Allocate a new row structure.
 * It contains one row element, the termcell.
 * We quit if the allocation fails.
 */
ROW *
AllocateRow()
{
	ROW *	rp;

	rp = freerows;

	if (rp)
		freerows = rp->next;
	else {
		rp = newrows;

		if (rp >= endrows) {
			rp = (ROW *) SafeAlloc(sizeof(ROW) * ALLOCROW);

			newrows = rp;
			endrows = rp + ALLOCROW;
		}

		newrows++;
	}

	rp->next = NULL;
	rp->firstcell = termcell;
	rp->lastcell = NULL;
	rp->count = 0;

	return rp;
}


/*
 * Allocate a new cell structure.
 * We quit if the allocation fails.
 */
CELL *
AllocateCell()
{
	CELL *	cp;

	cp = freecells;

	if (cp) {
		freecells = cp->next;
		cp->next = NULL;
		cp->marks = MARK_ANY;

		return cp;
	}

	cp = newcells;

	if (cp >= endcells) {
		cp = (CELL *) SafeAlloc(sizeof(CELL) * ALLOCCELL);

		newcells = cp;
		endcells = cp + ALLOCCELL;
	}

	newcells++;
	cp->next = NULL;
	cp->marks = MARK_ANY;

	return cp;
}


/*
 * Local malloc routine which exits if there is no memory.
 */
static char *
SafeAlloc(len)
	int	len;
{
	char *	cp;

	cp = malloc(len);

	if (cp)
		return cp;

	(*dev->close)(dev);

	fprintf(stderr, "Memory allocation failed\n");

	exit(1);
}

/* END CODE */
