#include "addpiece.h"

/* Adds piece at position pos to board. 
   Evaulates the no of free rows/cols/diags */
void addpiece(int piece, int pos)
{
  int i;
  board[pos]=2*piece+1;	/* piece has no existence bit */
  npiece[piece]--;
  for (i=0; i<NPROPERTIES; i++)
    npiece[NPROPPOS+2*i+((piece>>i)&1)]--;
  board[NPIECEPOS]++;
  board[VALPOS]=boardval();
  return;
}


/* Removes piece at position pos to board. 
   Evaluates the no of free rows/cols/diags */
void removepiece(int piece, int pos)
{
  int i;
  board[pos]=0;
  npiece[piece]++;
  for (i=0; i<NPROPERTIES; i++)
    npiece[NPROPPOS+2*i+((piece>>i)&1)]++;
  board[NPIECEPOS]--;
  board[VALPOS]=boardval();
  return;
}

int boardval()
{
  int val=0;
  int i,j,prop,test1,test2,test3,test4,left1,left2;

  for (prop=1; prop<=NPROPERTIES; prop++) {
    for (i=0; i<BOARDLENGTH; i++) { /* consider rows and cols */
      test1=test2=test3=test4=0;
      for (j=0; j<BOARDLENGTH; j++) {
	if (board[i*BOARDLENGTH+j]&1) {    /* row */
	  if ((board[i*BOARDLENGTH+j]&(1<<prop))>>prop) {
	    if (test1>=0)
	      test1++;
	    test2=-1;
	  } else {
	    if (test2>=0)
	      test2++;
	    test1=-1;
	  }
	}
	if (board[j*BOARDLENGTH+i]&1) {   /* col */
	  if ((board[j*BOARDLENGTH+i]&(1<<prop))>>prop) {
	    if (test3>=0)
	      test3++;
	    test4=-1;
	  } else {
	    if (test4>=0)
	      test4++;
	    test3=-1;
	  }
	}
      }
      left1=npiece[NPROPPOS+2*prop+1];
      left2=npiece[NPROPPOS+2*prop];
      if (test1>0 && test1+left1>=BOARDLENGTH)
	val+=(test1*left1); /* Take into     */
      if (test2>0 && test2+left2>=BOARDLENGTH)
	val+=(test2*left2); /* Take into     */
      if (test3>0 && test3+left1>=BOARDLENGTH)
	val+=(test3*left1); /* Take into     */
      if (test4>0 && test4+left2>=BOARDLENGTH)
	val+=(test4*left2); /* Take into     */
    }
    switch (gametype) {
    case NORMAL:
      test1=test2=test3=test4=0;
      for (i=0; i<BOARDLENGTH; i++) { /* consider diags */
	if (board[i*(BOARDLENGTH+1)]&1) {
	  if ((board[i*(BOARDLENGTH+1)]&(1<<prop))>>prop) {
	    if (test1>=0)
	      test1++;
	    test2=-1;
	  } else {
	    if (test2>=0)
	      test2++;
	    test1=-1;
	  }
	}
	if (board[(i+1)*(BOARDLENGTH-1)]&1) {
	  if ((board[(i+1)*(BOARDLENGTH-1)]&(1<<prop))>>prop) {
	    if (test3>=0)
	      test3++;
	    test4=-1;
	  } else {
	    if (test4>=0)
	      test4++;
	    test3=-1;
	  }
	}
      }
      if (test1>0) val+=(test1*npiece[NPROPPOS+2*prop+1]); /* Take into     */
      if (test2>0) val+=(test2*npiece[NPROPPOS+2*prop]);   /* account how   */
      if (test3>0) val+=(test3*npiece[NPROPPOS+2*prop+1]); /* many pieces   */
      if (test4>0) val+=(test4*npiece[NPROPPOS+2*prop]);   /* there are left*/
      break;
    case NODIAGS:
      break;
    case TORUS:
      for (i=0; i<BOARDLENGTH; i++) { /* consider ALL (torus) diags */
	test1=test2=test3=test4=0;
	for (j=0; j<BOARDLENGTH; j++) {
	  if (board[j*BOARDLENGTH+((i+j)%BOARDLENGTH)]&1) {
	    if ((board[j*BOARDLENGTH+((i+j)%BOARDLENGTH)]&(1<<prop))>>prop) {
	      if (test1>=0)
		test1++;
	      test2=-1;
	    } else {
	      if (test2>=0)
		test2++;
	      test1=-1;
	    }
	  }
	  
	  if (board[j*BOARDLENGTH+((i-j)%BOARDLENGTH)]&1) {
	    if ((board[j*BOARDLENGTH+((i-j)%BOARDLENGTH)]&(1<<prop))>>prop) {
	      if (test3>=0)
		test3++;
	      test4=-1;
	    } else {
	      if (test4>=0)
		test4++;
	      test3=-1;
	    }
	  }
	}
	if (test1>0) 
	  val+=(test1*npiece[NPROPPOS+2*prop+1]); /* Take into     */
	if (test2>0) 
	  val+=(test2*npiece[NPROPPOS+2*prop]);   /* account how   */
	if (test3>0) 
	  val+=(test3*npiece[NPROPPOS+2*prop+1]); /* many pieces   */
	if (test4>0) 
	  val+=(test4*npiece[NPROPPOS+2*prop]);   /* there are left*/
      }
      break;
    }
  }
  return val;
}
