/*
 * static char *rcsid_glue_c =
 *   "$Id: glue.c,v 1.5 1993/04/25 16:08:17 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>

/*
 * All this glue is currently needed to connect the game with the
 * server.  I'll try to make the library more able to "stand on it's
 * own legs" later; not done in 5 minutes to separate two parts of
 * the code which were connected, well, can you say "spagetti"?
 */

void (*emergency_save_func) (int);
void (*clean_tmp_files_func) ();
void (*fix_auto_apply_func) (mapstruct *);
void (*remove_friendly_object_func) (object *);
void (*process_active_maps_func) ();
void (*update_buttons_func) (mapstruct *);
void (*draw_info_func) (object *, char *);
void (*draw_stats_func) (object *);
void (*draw_inventory_func) (object *);
void (*draw_look_func) (object *);
int (*apply_func) (object *, object *);
void (*draw_func) (object *);
void (*monster_check_apply_func) (object *, object *);
void (*draw_inventory_faces_func) (object *);
void (*draw_look_faces_func) (object *);
void (*init_blocksview_players_func) ();
void (*info_map_func) (mapstruct *, char *);

static char fatalmsgs[][80]={
  "Failed to allocate memory",
  "Failed repeatedly to load maps",
  "Hashtable for archetypes is too small",
  "Too many errors"
};

/*
 * Initialise all function-pointers to dummy-functions which will
 * do nothing and return nothing (of value at least).
 * Very healthy to do this when using the library, since
 * function pointers are being called throughout the library, without
 * being checked first.
 * init_library() calls this function.
 */

void init_function_pointers() {
  emergency_save_func = dummy_function_int;
  clean_tmp_files_func = dummy_function;
  fix_auto_apply_func = dummy_function_map;
  remove_friendly_object_func = dummy_function_ob;
  process_active_maps_func = dummy_function;
  update_buttons_func = dummy_function_map;
  draw_info_func = dummy_draw_info;
  draw_stats_func = dummy_function_ob;
  draw_inventory_faces_func = dummy_function_ob;
  draw_look_faces_func = dummy_function_ob;
  draw_inventory_func = dummy_function_ob;
  draw_look_func = dummy_function_ob;
  apply_func = dummy_function_ob2int;
  draw_func = dummy_function_ob;
  monster_check_apply_func = dummy_function_ob2;
  init_blocksview_players_func = dummy_function;
  info_map_func = dummy_function_mapstr;
}

/*
 * Specifies which function to call when there is an emergency save.
 */

void set_emergency_save(void *addr) {
  emergency_save_func = addr;
}

/*
 * Specifies which function to call to clean temporary files.
 */

void set_clean_tmp_files(void *addr) {
  clean_tmp_files_func = addr;
}

/*
 * Specifies which function to call to fix auto-apply (objects which
 * applies themselves when their map is loaded).
 */

void set_fix_auto_apply(void *addr) {
  fix_auto_apply_func = addr;
}

/*
 * Specifies which function to call to remove an object in the
 * linked list of friendly objects.
 */

void set_remove_friendly_object(void *addr) {
  remove_friendly_object_func = addr;
}

/*
 * Specify which function to call to do some work in active
 * maps.  That function might get called if there are several players,
 * and one player is using too much cpu to either load a map, or to
 * load pixmaps.
 */

void set_process_active_maps(void *addr) {
  process_active_maps_func = addr;
}

/*
 * Specify which function to call to recoordinate all buttons.
 */

void set_update_buttons(void *addr) {
  update_buttons_func = addr;
}

/*
 * Specify which function to call to draw text to the window
 * of a player.
 */

void set_draw_info(void *addr) {
  draw_info_func = addr;
}

/*
 * Specify which function to call to update the text in the
 * stat-window of a player.
 */

void set_draw_stats(void *addr) {
  draw_stats_func = addr;
}

/*
 * Specify which function to call to update the graphics in the
 * inventory-window of a player.
 */

void set_draw_inventory_faces(void *addr) {
  draw_inventory_faces_func = addr;
}

/*
 * Specify which function to call to update the graphics
 * in the look-window of a player.
 */

void set_draw_look_faces(void *addr) {
  draw_look_faces_func = addr;
}

/*
 * Specify which function to call to update the content
 * in the inventory-window of a player.
 */

void set_draw_inventory(void *addr) {
  draw_inventory_func = addr;
}

/*
 * Specify which function to call to update the content
 * of the look-window of a player.
 */

void set_draw_look(void *addr) {
  draw_look_func = addr;
}

/*
 * Specify which function to call to apply an object.
 */

void set_apply(void *addr) {
  apply_func = addr;
}

/*
 * Specify which function to call to draw on the graphic-window
 * of a player.
 */

void set_draw(void *addr) {
  draw_func = addr;
}

/*
 * Specify which function to call to check if a monster can
 * apply an object.
 */

void set_monster_check_apply(void *addr) {
  monster_check_apply_func = addr;
}

/*
 * Specify which functino to call to initialise the blocksview[] array.
 */

void set_init_blocksview_players(void *addr) {
  init_blocksview_players_func = addr;
}

void set_info_map(void *addr) {
  info_map_func = addr;
}

/*
 * fatal() is meant to be called whenever a fatal signal is intercepted.
 * It will call the emergency_save and the clean_tmp_files functions.
 */

void fatal(int err) {
  fprintf(logfile,"Fatal: %s\n",fatalmsgs[err]);
  (*emergency_save_func)(0);
  (*clean_tmp_files_func)();
#ifdef GOD
  pray();
#else
  fprintf(logfile,"Exiting...\n");
  exit(err);
#endif
}

#ifndef __Making_docs__ /* Don't want documentation on these */

/*
 * These are only dummy functions, to avoid having any function-pointers
 * having the possibility of pointing to NULL (or random location),
 * thus I don't have to check the contents of a function-pointer each
 * time I want to jump to it.
 */

void dummy_function_int(int i) {
}

void dummy_function() {
}

void dummy_function_map(mapstruct *m) {
}

void dummy_function_ob(object *ob) {
}

void dummy_function_ob2(object *ob, object *ob2) {
}

int dummy_function_ob2int(object *ob, object *ob2) {
  return 0;
}

void dummy_function_txtnr(char *txt, int nr) {
  fprintf(logfile,"%d: %s\n",nr,txt);
}

void dummy_draw_info(object *ob, char *txt) {
  fprintf(logfile, "%s\n", txt);
}

void dummy_function_mapstr(mapstruct *map, char *str) {
  fprintf(logfile, "info_map: %s\n", str);
}
#endif
