/*
 * static char *rcsid_living_c =
 *   "$Id: living.c,v 1.4 1993/04/25 16:08:21 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <living.h>
#include <funcpoint.h>

static int con_bonus[26]={
  -6,-5,-4,-3,-2,-1,-1,0,0,0,0,1,2,3,4,5,6,8,10,12,14,16,18,20,24,28};
static int int_bonus[26]={
  -10,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,10,15,20,30,40,60};
int cha_bonus[26]={
  -80,-70,-60,-50,-40,-30,-25,-20,-15,-10,-8,-5,0,4,8,12,16,20,24,28,32,36,40,
   44,48,50};
int dex_bonus[26]={
  -2,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,4,4,4,5,5,5,6};
static float speed_bonus[26]={
  -0.4, -0.4, -0.3, -0.3, -0.2, -0.2, -0.2, -0.1, -0.1, -0.1, -0.05, 0, 0, 0,
  0.05, 0.1, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.8, 1.0, 1.2, 1.5};
int dam_bonus[26]={
  -2,-2,-2,-1,-1,-1,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4,5,5,6};
int thaco_bonus[26]={
  -2,-2,-1,-1,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,3,3,3,4,4,5};
int max_carry[26]={
  2,4,7,11,16,22,29,37,46,56,67,79,92,106,121,137,154,172,191,211,232,254,277,
  301,326,352};
int learn_spell[26]={
  0,0,0,1,2,4,8,12,16,25,36,45,55,65,70,75,80,85,90,95,100,100,100,100,100,
  100};
int cleric_chance[26]={
  100,100,100,100,100,100,100,90,80,70,60,50,45,40,35,30,25,20,15,10,5,0,-5,-10,-15,-20};
int turn_bonus[26]={
  -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,1,1,1,2,2,2,3,3,3,4,4,5,5,6,7};
int fear_bonus[26]={
  3,3,3,3,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static int levels[11]={
  0,0,1000,2000,4000,8000,16000,32000,64000,125000,250000};


int savethrow[100]={
  18,17,16,15,14,14,13,13,12,12,12,11,11,11,11,10,10,10,10, 9,
   9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6,
   6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4,
   4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2,
   2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

int object_saves[NROFATTACKS][NROFMATERIALS] = {
  /* Paper, Iron, Glass, Leather, Wood, Organic, Stone, Cloth */
  {20, 2,19,10,15, 8, 4,19}, /* Physical */
  {15,17,16,15,16,17,10,16}, /* Magic */
  {20, 7,15,15,18,14, 2,19}, /* Fire */
  {14,17,10, 8, 6,16, 2, 8}, /* Electricity */
  {10, 3,15, 7, 6, 8, 4, 9}, /* Cold */
  {15,15,15,15,15,15, 4,10}, /* Water */
  {18,10, 1,15,14,12, 1,15}, /* Acid */
  { 0, 0, 0, 0, 0, 0, 0, 0}, /* Drain */
  {20,20,20,20,20,20,20,20}, /* Weaponmagic */
  {15,15,15,15,15,15,15,15}, /* Ghosthit */
  { 0, 0, 0, 0, 0, 0, 0, 0}, /* IT */
  { 0, 0, 0, 0, 0, 0, 0, 0}, /* Disease */
  { 0, 0, 0, 0, 0, 0, 0, 0}, /* Paralyze */
  { 0, 0, 0, 0, 0, 0, 0, 0}, /* Turn undead */
  { 0, 0, 0, 0, 0, 0, 0, 0}, /* Fear */
  {15,15, 0,17,17, 0,10,10}, /* Cancellation */
  { 0, 0, 0, 0, 0, 0, 0, 0}  /* Depletion */
};

char *attacks[NROFATTACKS] = {
  "physical", "magical", "fire", "electricity", "cold", "water",
  "acid", "drain", "weaponmagic", "ghosthit", "poison", "disease",
  "paralyze", "turn undead", "fear", "cancellation", "depletion"
};

/*
 * sets Str/Dex/con/Wis/Cha/Int in stats to value, depending on
 * what attr is (STR to INT).
 */

void
set_attr_value(living *stats,int attr,signed char value) {
  switch(attr) {
  case STR:
    stats->Str=value;
    break;
  case DEX:
    stats->Dex=value;
    break;
  case CON:
    stats->Con=value;
    break;
  case WIS:
    stats->Wis=value;
    break;
  case CHA:
    stats->Cha=value;
    break;
  case INT:
    stats->Int=value;
    break;
  }
}

/*
 * Like set_attr_value(), but instead the value (which can be negative)
 * is added to the specified stat.
 */

void
change_attr_value(living *stats,int attr,signed char value) {
  switch(attr) {
  case STR:
    stats->Str+=value;
    break;
  case DEX:
    stats->Dex+=value;
    break;
  case CON:
    stats->Con+=value;
    break;
  case WIS:
    stats->Wis+=value;
    break;
  case CHA:
    stats->Cha+=value;
    break;
  case INT:
    stats->Int+=value;
    break;
  }
}

/*
 * returns the specified stat.  See also set_attr_value().
 */

signed char
get_attr_value(living *stats,int attr) {
  switch(attr) {
  case STR:
    return(stats->Str);
  case DEX:
    return(stats->Dex);
  case CON:
    return(stats->Con);
  case WIS:
    return(stats->Wis);
  case CHA:
    return(stats->Cha);
  case INT:
    return(stats->Int);
  }
  return 0;
}

/*
 * Ensures that all stats (str/dex/con/wis/cha/int) are within the 1-25 limit.
 */

void check_stat_bounds(object *op) {
  int i,v;
  for(i=0;i<6;i++)
    if((v=get_attr_value(&(op->stats),i))>25)
      set_attr_value(&(op->stats),i,25);
    else if(v<1)
      set_attr_value(&(op->stats),i,1);
}

#define ORIG_S(xyz,abc)	(op->contr->orig_stats.abc)

/*
 * Adds abilities to the first object based on what the second object
 * gives to appliers.  If the second object does not have the APPLIED
 * flag set, it is assumed that it is being unapplied, and any abilities
 * it gives are subtracted from the first object.
 * (This is of course a problem now, since several objects may give
 * the same abilities, thus change_abil() is used mostly to display
 * messages, while fix_player() is called afterwards.)
 * Also writes a more or less informative message to the first object
 * about what abilities were gained/lost.
 */

int change_abil(object *op, object *tmp) {
  int flag=IS_APPLIED(tmp)?1:-1, i;
  if(op->type==PLAYER) {
    if (tmp->type==POTION) {
      if((i= op->contr->orig_stats.Str+flag*tmp->stats.Str) 
	 > 20+tmp->stats.Str+op->arch->clone.stats.Str || i<1)
          return 0;
      op->contr->orig_stats.Str = i;
      if((i= op->contr->orig_stats.Dex+flag*tmp->stats.Dex) 
	 > 20+tmp->stats.Dex+op->arch->clone.stats.Dex || i<1)
          return 0;
      op->contr->orig_stats.Dex = i;
      if((i= op->contr->orig_stats.Con+flag*tmp->stats.Con) 
	 > 20+tmp->stats.Con+op->arch->clone.stats.Con || i<1)
          return 0;
      op->contr->orig_stats.Con = i;
      if((i= op->contr->orig_stats.Wis+flag*tmp->stats.Wis) 
	 > 20+tmp->stats.Wis+op->arch->clone.stats.Wis || i<1)
          return 0;
      op->contr->orig_stats.Wis = i;
      if((i= op->contr->orig_stats.Cha+flag*tmp->stats.Cha) 
	 > 20+tmp->stats.Cha+op->arch->clone.stats.Cha || i<1)
          return 0;
      op->contr->orig_stats.Cha = i;
      if((i= op->contr->orig_stats.Int+flag*tmp->stats.Int) 
	 > 20+tmp->stats.Int+op->arch->clone.stats.Int || i<1)
          return 0;
       op->contr->orig_stats.Int = i;
    }
    op->stats.Str += flag*tmp->stats.Str;
    op->stats.Dex += flag*tmp->stats.Dex;
    op->stats.Con += flag*tmp->stats.Con;
    op->stats.Wis += flag*tmp->stats.Wis;
    op->stats.Cha += flag*tmp->stats.Cha;
    op->stats.Int += flag*tmp->stats.Int;
    check_stat_bounds(op);
  }
  if(flag==1)
    op->immune|=tmp->immune,
    op->protected|=tmp->protected,
    op->vulnerable|=tmp->vulnerable,
    op->attacktype|=tmp->attacktype;
  else
    op->immune&=~tmp->immune,
    op->protected&=~tmp->protected,
    op->vulnerable&=~tmp->vulnerable,
    op->attacktype&=~tmp->attacktype;
  if(tmp->attacktype & AT_CONFUSION) {
    if(flag>0)
      (*draw_info_func)(op,"Your hands begin to glow red.");
    else
      (*draw_info_func)(op,"Your hands stop glowing red.");
  }
  if(LIFESAVE(tmp)) {
    if(flag>0) {
      (*draw_info_func)(op,"You feel very protected.");
      SET_LIFESAVE(op);
    } else {
      (*draw_info_func)(op,"You don't feel protected anymore.");
      UNSET_LIFESAVE(op);
    }
  }
  if(REFL_MISSILE(tmp)) {
    if(flag>0) {
      (*draw_info_func)(op,"A magic force shimmers around you.");
      SET_REFL_MISSILE(op);
    } else {
      (*draw_info_func)(op,"The magic force fades away.");
      UNSET_REFL_MISSILE(op);
    }
  }
  if(REFL_SPELL(tmp)) {
    if(flag>0) {
      (*draw_info_func)(op,"You feel more safe now, somehow.");
      SET_REFL_SPELL(op);
    } else {
      (*draw_info_func)(op,"Suddenly you feel less safe, somehow.");
      UNSET_REFL_SPELL(op);
    }
  }
  if(IS_FLYING(tmp)) {
    if(flag>0) {
      if(IS_WIZ(op))
        (*draw_info_func)(op,"You float a little higher in the air.");
      else {
        (*draw_info_func)(op,"You start to float in the air!.");
        SET_FLY(op);
        if(op->speed>1)
          op->speed=1;
      }
    } else {
      if(IS_WIZ(op))
        (*draw_info_func)(op,"You float a little lower in the air.");
      else {
        (*draw_info_func)(op,"You float down to the ground.");
        UNSET_FLY(op);
        if(op->speed<=1)
          fix_player(op);
      }
    }
  }
  if(STEALTH(tmp)) {
    if(flag>0) {
      (*draw_info_func)(op,"You walk more quietly.");
      SET_STEALTH(op);
    } else {
      (*draw_info_func)(op,"You walk more noisily.");
      UNSET_STEALTH(op);
    }
  }
  if(XRAYS(tmp)) {
    if(flag>0) {
      if(IS_WIZ(op))
        (*draw_info_func)(op,"Your vision becomes a little clearer.");
      else {
        (*draw_info_func)(op,"Everything becomes transparent.");
        SET_XRAYS(op);
        if(op->type==PLAYER)
          op->contr->do_los=1;
      }
    } else {
      if(IS_WIZ(op))
        (*draw_info_func)(op,"Your vision becomes a bit out of focus.");
      else {
        (*draw_info_func)(op,"Everything suddenly looks very solid.");
        UNSET_XRAYS(op);
        if(op->type==PLAYER)
          op->contr->do_los=1;
      }
    }
  }
  if(tmp->stats.luck)
    if(flag>0) {
      (*draw_info_func)(op,"You feel more lucky.");
      op->stats.luck+=tmp->stats.luck;
    } else {
      (*draw_info_func)(op,"You feel less lucky.");
      op->stats.luck-=tmp->stats.luck;
    }
  if(tmp->stats.hp && op->type==PLAYER) {
    op->contr->gen_hp+=tmp->stats.hp*flag;
    if(flag*tmp->stats.hp>0)
      (*draw_info_func)(op,"You feel much more healthy!");
    else
      (*draw_info_func)(op,"You feel much less healthy!");
  }
  if(tmp->stats.sp && op->type==PLAYER) {
    op->contr->gen_sp+=tmp->stats.sp*flag;
    if(flag*tmp->stats.sp>0)
      (*draw_info_func)(op,"You feel one with the powers of magic!");
    else
      (*draw_info_func)(op,"You suddenly feel very mundane.");
  }
  if(tmp->stats.food && op->type==PLAYER) {
    op->contr->digestion+=tmp->stats.food*flag;
    if(tmp->stats.food*flag>0)
      (*draw_info_func)(op,"You feel your digestion slowing down.");
    else
      (*draw_info_func)(op,"You feel your digestion speeding up.");
  }
  if(tmp->immune&AT_PHYSICAL)
    if(flag>0)
      (*draw_info_func)(op,"You feel much less solid.");
    else
      (*draw_info_func)(op,"You suddenly feel very solid.");
  else if(tmp->protected&AT_PHYSICAL)
    if(flag>0)
      (*draw_info_func)(op,"You feel less solid.");
    else
      (*draw_info_func)(op,"You feel more solid.");
  if(tmp->immune&AT_MAGIC)
    if(flag>0)
      (*draw_info_func)(op,"You feel immune to magic.");
    else
      (*draw_info_func)(op,"You feel less immune to magic.");
  else if(tmp->protected&AT_MAGIC)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to magic.");
    else
      (*draw_info_func)(op,"You feel less resistant to magic.");
  if(tmp->immune&AT_FIRE)
    if(flag>0)
      (*draw_info_func)(op,"You feel immune to fire.");
    else
      (*draw_info_func)(op,"You feel less immune to fire.");
  else if(tmp->protected&AT_FIRE)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to fire.");
    else
      (*draw_info_func)(op,"You feel less resistant to fire.");
  if(tmp->vulnerable&AT_FIRE)
    if(flag>0)
      (*draw_info_func)(op,"You feel exposed to fire.");
    else
      (*draw_info_func)(op,"You feel less exposed to fire.");
  if(tmp->immune&AT_COLD)
    if(flag>0)
      (*draw_info_func)(op,"You feel immune to cold.");
    else
      (*draw_info_func)(op,"You feel less immune to cold.");
  else if(tmp->protected&AT_COLD)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to cold.");
    else
      (*draw_info_func)(op,"You feel less resistant to cold.");
  if(tmp->vulnerable&AT_COLD)
    if(flag>0)
      (*draw_info_func)(op,"You feel exposed to cold.");
    else
      (*draw_info_func)(op,"You feel less exposed to cold.");
  if(tmp->immune&AT_ELECTRICITY)
    if(flag>0)
      (*draw_info_func)(op,"You feel immune to electricity.");
    else
      (*draw_info_func)(op,"You feel less immune to electricity.");
  else if(tmp->protected&AT_ELECTRICITY)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to electricity.");
    else
      (*draw_info_func)(op,"You feel less resistant to electricity.");
  if(tmp->immune&AT_DRAIN)
    if(flag>0)
      (*draw_info_func)(op,"You feel very full of life.");
    else
      (*draw_info_func)(op,"You shiver, everything seems so bleak.");
  else if(tmp->protected&AT_DRAIN)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to draining.");
    else
      (*draw_info_func)(op,"You feel less resistant to draining.");
  if(tmp->immune&AT_POISON)
    if(flag>0)
      (*draw_info_func)(op,"You feel extremely healthy.");
    else
      (*draw_info_func)(op,"You feel extremely less healthy!");
  else if(tmp->protected&AT_POISON)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to poison.");
    else
      (*draw_info_func)(op,"You feel less resistant to poison.");
  if(tmp->immune&AT_SLOW)
    if(flag>0)
      (*draw_info_func)(op,"You feel in sync with time.");
    else
      (*draw_info_func)(op,"You feel out of sync with time.");
  else if(tmp->protected&AT_SLOW)
    if(flag>0)
      (*draw_info_func)(op,"You feel more in sync with time.");
    else
      (*draw_info_func)(op,"You feel less in sync with time.");
  if(tmp->immune&AT_PARALYZE)
    if(flag>0)
      (*draw_info_func)(op,"You feel very unrestrained.");
    else
      (*draw_info_func)(op,"You feel more restrained.");
  else if(tmp->protected&AT_PARALYZE)
    if(flag>0)
      (*draw_info_func)(op,"You feel more resistant to paralyzation.");
    else
      (*draw_info_func)(op,"You feel less resistant to paralyzation.");
  if(tmp->stats.Int)
    if(tmp->stats.Int*flag>0)
      (*draw_info_func)(op,"You feel smarter.");
    else
      (*draw_info_func)(op,"You feel dumb!");
  if(tmp->stats.Dex)
    if(tmp->stats.Dex*flag>0)
      (*draw_info_func)(op,"You feel more agile.");
    else
      (*draw_info_func)(op,"You feel clumsy!");
  if(tmp->stats.Str)
    if(tmp->stats.Str*flag>0)
      (*draw_info_func)(op,"You feel stronger.");
    else
      (*draw_info_func)(op,"You feel weaker!");
  if(tmp->stats.Wis)
    if(tmp->stats.Wis*flag>0)
      (*draw_info_func)(op,"You feel wiser.");
    else
      (*draw_info_func)(op,"You feel stupid!");
  if(tmp->stats.Cha)
    if(tmp->stats.Cha*flag>0)
      (*draw_info_func)(op,"You seem to look better.");
    else
      (*draw_info_func)(op,"You look ugly!");
  if(tmp->stats.Con)
    if(tmp->stats.Con*flag>0)
      (*draw_info_func)(op,"You feel healthy.");
    else
      (*draw_info_func)(op,"You feel less healthy!");
  return 1;
}

/*
 * Subtracts stat-bonuses given by the class which the player has chosen.
 */

void remove_statbonus(object *op) {
  op->stats.Str -= op->arch->clone.stats.Str;
  op->stats.Dex -= op->arch->clone.stats.Dex;
  op->stats.Con -= op->arch->clone.stats.Con;
  op->stats.Wis -= op->arch->clone.stats.Wis;
  op->stats.Cha -= op->arch->clone.stats.Cha;
  op->stats.Int -= op->arch->clone.stats.Int;
  op->contr->orig_stats.Str -= op->arch->clone.stats.Str;
  op->contr->orig_stats.Dex -= op->arch->clone.stats.Dex;
  op->contr->orig_stats.Con -= op->arch->clone.stats.Con;
  op->contr->orig_stats.Wis -= op->arch->clone.stats.Wis;
  op->contr->orig_stats.Cha -= op->arch->clone.stats.Cha;
  op->contr->orig_stats.Int -= op->arch->clone.stats.Int;
}

/*
 * Adds stat-bonuses given by the class which the player has chosen.
 */

void add_statbonus(object *op) {
  op->stats.Str += op->arch->clone.stats.Str;
  op->stats.Dex += op->arch->clone.stats.Dex;
  op->stats.Con += op->arch->clone.stats.Con;
  op->stats.Wis += op->arch->clone.stats.Wis;
  op->stats.Cha += op->arch->clone.stats.Cha;
  op->stats.Int += op->arch->clone.stats.Int;
  op->contr->orig_stats.Str += op->arch->clone.stats.Str;
  op->contr->orig_stats.Dex += op->arch->clone.stats.Dex;
  op->contr->orig_stats.Con += op->arch->clone.stats.Con;
  op->contr->orig_stats.Wis += op->arch->clone.stats.Wis;
  op->contr->orig_stats.Cha += op->arch->clone.stats.Cha;
  op->contr->orig_stats.Int += op->arch->clone.stats.Int;
}

/*
 * Updates all abilities given by applied objects in the inventory
 * of the given object.  Note: This function works for both monsters
 * and players; the "player" in the name is purely an archaic inheritance.
 */

void fix_player(object *op) {
  int i,j;
  float f,max=9,added_speed=0,bonus_speed=0;
  float M,W,s,D,K,S,M2;
  int weapon_weight=0,weapon_speed=0;
  int best_ac=0;
  object *tmp;
  if(op->type==PLAYER)
    for(i=0;i<6;i++)
      set_attr_value(&(op->stats),i,get_attr_value(&(op->contr->orig_stats),i));
  if(op->slaying!=NULL) {
    free_string(op->slaying);
    op->slaying=NULL;
  }
  if(!IS_WIZ(op)) {
    UNSET_FLY(op);
    UNSET_XRAYS(op);
  }
  op->protected=op->arch->clone.protected;
  op->vulnerable=op->arch->clone.vulnerable;
  op->immune=op->arch->clone.immune;
  op->armour=op->arch->clone.armour;
  op->stats.ac=op->arch->clone.stats.ac;
  op->stats.wc=op->arch->clone.stats.wc;
  op->stats.dam=op->arch->clone.stats.dam;
  op->stats.luck=op->arch->clone.stats.luck;
  op->speed = op->arch->clone.speed;

  for(tmp=op->inv;tmp!=NULL;tmp=tmp->below)
    if(IS_APPLIED(tmp)) {
      if(op->type==PLAYER)
        for(i=0;i<6;i++)
          change_attr_value(&(op->stats),i,get_attr_value(&(tmp->stats),i));
      op->protected|=tmp->protected;
      op->vulnerable|=tmp->vulnerable;
      op->immune|=tmp->immune;
      op->stats.luck+=tmp->stats.luck;
      if(LIFESAVE(tmp))
        SET_LIFESAVE(op);
      if(REFL_SPELL(tmp))
        SET_REFL_SPELL(op);
      if(REFL_MISSILE(tmp))
        SET_REFL_MISSILE(op);
      if(STEALTH(tmp))
        SET_STEALTH(op);
      if(IS_FLYING(tmp)) {
        SET_FLY(op);
        if(!IS_WIZ(op))
          max=1;
      }
      if(XRAYS(tmp))
        SET_XRAYS(op);
      if(tmp->stats.exp) {
        if(tmp->stats.exp > 0) {
          added_speed+=tmp->stats.exp-tmp->stats.exp/3 - 1;
          bonus_speed+=1+tmp->stats.exp/3;
        } else
          added_speed+=(float)tmp->stats.exp;
      }
      switch(tmp->type) {
      case RING:
      case AMULET:
      case GIRDLE:
      case HELMET:
      case SHIELD:
      case BOOTS:
      case GLOVES:
        if(tmp->armour)
          op->armour+=((100-op->armour)*tmp->armour)/100;
        if(tmp->stats.wc)
          op->stats.wc-=(tmp->stats.wc+tmp->magic);
        if(tmp->stats.dam)
          op->stats.dam+=(tmp->stats.dam+tmp->magic);
        if(tmp->stats.ac)
          op->stats.ac-=(tmp->stats.ac+tmp->magic);
        break;
      case WEAPON:
        op->stats.wc-=(tmp->stats.wc+tmp->magic);
        if(tmp->stats.ac&&tmp->stats.ac+tmp->magic>0)
          op->stats.ac-=tmp->stats.ac+tmp->magic;
        if(tmp->armour)
          op->armour+=((100-op->armour)*tmp->armour)/100;
        op->stats.dam+=(tmp->stats.dam+tmp->magic);
        weapon_weight=tmp->weight;
        weapon_speed=((int)WEAPON_SPEED(tmp)*2-tmp->magic)/2;
        if(weapon_speed<0) weapon_speed=0;
        if(tmp->slaying!=NULL)
          add_refcount(op->slaying = tmp->slaying);
        break;
      case ARMOUR: /* Only the best of these three are used: */
      case BRACERS:
      case FORCE:
        if(tmp->armour)
          op->armour+=((100-op->armour)*tmp->armour)/100;
        if(tmp->stats.ac) {
          if(best_ac<tmp->stats.ac+tmp->magic) {
            op->stats.ac+=best_ac; /* Remove last bonus */
            best_ac=tmp->stats.ac+tmp->magic;
          }
          else /* To nullify the below effect */
            op->stats.ac+=tmp->stats.ac+tmp->magic;
        }
        if(tmp->stats.ac) op->stats.ac-=(tmp->stats.ac+tmp->magic);
        if(ARMOUR_SPEED(tmp)&&ARMOUR_SPEED(tmp)/10.0<max)
          max=ARMOUR_SPEED(tmp)/10.0;
        break;
      }
    }
  if(op->type==PLAYER) {
    check_stat_bounds(op);
    for(i=1,op->stats.maxhp=0;i<=op->level&&i<=10;i++) {
      j=op->contr->levhp[i]+con_bonus[op->stats.Con]/2;
      if(i%2&&con_bonus[op->stats.Con]%2)
        j++;
      op->stats.maxhp+=j>1?j:1;
    }
    for(i=11;i<=op->level;i++)
      op->stats.maxhp+=2;
    if(op->stats.hp>op->stats.maxhp)
      op->stats.hp=op->stats.maxhp;
    for(i=1,op->stats.maxsp=0;i<=op->level&&i<=10;i++) {
      j=op->contr->levsp[i]+int_bonus[op->stats.Int]/2;
      if((i%2) && (int_bonus[op->stats.Int]%2))
      if (int_bonus[op->stats.Int]>0)
            j++;
      else
          j--;
      op->stats.maxsp+=j>1?j:1;
    }
    for(i=11;i<=op->level;i++)
      op->stats.maxsp+=2;
    if(op->stats.sp>op->stats.maxsp)
      op->stats.sp=op->stats.maxsp;
    if(op->contr->braced)
      op->stats.ac+=2;
    else
      op->stats.ac-=dex_bonus[op->stats.Dex];
    op->stats.wc-=(op->level+thaco_bonus[op->stats.Str]);
    if(op->contr->braced)
      op->stats.wc+=4;
    op->stats.dam+=dam_bonus[op->stats.Str];
    if(op->stats.dam<1)
      op->stats.dam=1;
    op->speed=1.0+speed_bonus[op->stats.Dex];
  }
  if(added_speed>=0)
    op->speed+=added_speed/10.0;
  else /* Something wrong here...: */
    op->speed /= (float)(1-added_speed);
  if(op->speed>max)
    op->speed=max;

  if(op->type == PLAYER) {
    f=(op->carrying/1000)-max_carry[op->stats.Str];
    if(f>0) op->speed=op->speed/(1+f/max_carry[op->stats.Str]);
  }

  op->speed+=bonus_speed/10.0; /* Not affected by limits */

  if(op->type == PLAYER) {
/* (This formula was made by vidarl@ifi.uio.no) */
    M=(max_carry[op->stats.Str]-121)/121.0;
    M2=max_carry[op->stats.Str]/100.0;
    W=weapon_weight/20000.0;
    s=2-weapon_speed/10.0;
    D=(op->stats.Dex-14)/14.0;
    K=1 + M/3.0 - W/(3*M2) + op->speed/5.0 + D/2.0;
    K*=(4+op->level)/(float)(6+op->level)*1.2;
    if(K<=0) K=0.01;
      S=op->speed/(K*s);
    op->contr->weapon_sp=S;
    if(op->stats.hp!=-10000)
      (*draw_stats_func)(op);
  }
  /* I want to limit the power of small monsters with big weapons: */
  if(op->type!=PLAYER&&op->arch!=NULL&&
     op->stats.dam>op->arch->clone.stats.dam*3)
      op->stats.dam=op->arch->clone.stats.dam*3;
}

/*
 * Returnes true if the given player is a legal class.
 * The function to add and remove class-bonuses to the stats doesn't
 * check if the stat becomes negative, thus this function
 * merely checks that all stats are 1 or more, and returns
 * false otherwise.
 */

int allowed_class(object *op) {
  return op->stats.Dex>0&&op->stats.Str>0&&op->stats.Con>0&&
         op->stats.Int>0&&op->stats.Wis>0&&op->stats.Cha>0;
}

/*
 * Returns how much experience is needed for a player to become
 * the given level.
 */

int level_exp(int level) {
  int   count,required_exp;

/*  static int bleep=250000; */
/* Eneq(@csd.uu.se):  New level-algorithm; level 2 at 1000 then  
   times 2 for all following. */

  if(level<=10) return levels[level];

  for (count=10, required_exp=levels[count];count<level;count++)
    required_exp*=1.5;
  return required_exp;
/*    return levels[10]+bleep*(level-10); */
}

/*
 * Adds (or subtracts) experience to a living object.  If it is a player,
 * checks for level-gain/loss is done.
 * The routines for gaining/losing levels is also within this function.
 */

void add_exp(object *op,int exp) {
  char buf[MAX_BUF];
  if(op->type == PLAYER && op->contr->braced)
    exp = exp/5;
  if (exp > op->stats.exp / 2)
    if (op->stats.exp < 100)
      exp = 50;
    else
      exp = op->stats.exp / 2;
  op->stats.exp += exp;
  if(op->stats.exp < 0)
    op->stats.exp = 0;
  if(op->stats.exp>99999999)
    op->stats.exp=99999999;
  if(op->type==PLAYER) {
    if(op->level < 100 && op->stats.exp >= level_exp(op->level+1)) {
      op->level++;
      if(op->level < 11)
      {
        op->contr->levhp[op->level] = (int) RANDOM()%4 + (int) RANDOM()%4 + 3;
        op->contr->levsp[op->level] = (int) RANDOM()%3 + (int) RANDOM()%3 + 2;
      }
      fix_player(op);
      if(op->level>1) {
        sprintf(buf,"You are now level %d.",op->level);
        (*draw_info_func)(op,buf);
      }
      add_exp(op,0); /* To increase more levels */
    } else if(op->level>1&&op->stats.exp<level_exp(op->level)) {
      op->level--;
      fix_player(op);
      sprintf(buf,"You are now level %d.",op->level);
      (*draw_info_func)(op,buf);
      add_exp(op,0); /* To decrease more levels */
    }
  }
}
