/*
 * static char *rcsid_object_c =
 *   "$Id: loader.c,v 1.6 1993/04/25 16:08:22 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

/* Eneq(@csd.uu.se): Added weight-modifiers in environment of objects.
   sub/add_weight will transcend the environment updating the carrying
   variable. */

#include "global.h"
#include "loader.h"

char *variable_const[NR_OF_VARIABLES] = {
  "Object","name","race","slaying","msg","endmsg",
  "Inventory","arch","other_arch","More",
  "anim","mina","end","last_heal","last_sp","last_eat",
  "speed","speed_left","slow_move",
  "face","Str","Dex","Con","Wis","Cha","Int","hp","maxhp","sp","maxsp",
  "exp","food","dam","wc","ac","x","y","nrof","level","direction",
  "type","material","value", "weight","carrying",
  "immune","protected","attacktype","vulnerable",
  "invisible","magic","state","alive","applied","unpaid","need_an","need_ie",
  "no_pick","no_pass","walk_on","walk_off","fly_on","fly_off","is_animated",
  "flying","monster", "friendly","generator","auto_apply","treasure",
  "apply_once","see_invisible","can_roll","is_turning","is_turnable",
  "is_used_up","identified","reflecting","changing","splitting","hitback",
  "startequip","blocksview","editable","undead","scared","unaggressive",
  "color_fg","color_bg","reflect_missile","reflect_spell","no_magic",
  "wiz","was_wiz","no_fix_player","tear_down", "luck", "run_away","pass_thru",
  "can_pass_thru","pick_up","anim_speed","container","bonus","no_drop",
  "no_pretext","will_apply","random_movement", "can_apply",
  "can_cast_spell","can_use_scroll","can_use_wand","can_use_bow",
  "can_use_armour","can_use_weapon","can_use_ring","has_ready_wand",
  "has_ready_bow","xrays","is_floor","lifesave","no_strength",
  "sleep","stand_still","random_move","only_attack","armour",
  "attack_movement","move_state","confused","stealth","connected",
#ifdef NPC_PROG
  "npc_status","npc_program",
#endif
};

char *variables[NR_OF_VARIABLES];

char *coloralias[] = {
  "black","white","blue","red","orange","light_blue","dark_orange",
  "green","light_green","grey","brown","yellow","khaki"
};

/*
 * Initialises the array of variable-names.  Needed before any
 * objects can be loaded.  Called by init_library().
 */

void init_vars() {
  int i;
  for(i=0;i<NR_OF_VARIABLES;i++)
    variables[i]=add_string(variable_const[i]);
}

/*
 * Searches through all possible variables to find any that matches
 * the given string.  An index to the variable_const[] array is returned,
 * or -1 on failure.
 */

int get_variable(char *name) {
  int i;
  char *tmp=find_string(name);
  for(i=0;i<NR_OF_VARIABLES;i++)
    if(variables[i]==tmp)
      return i;
  return -1;
}

/*
 * Returns a pointer to a static string which contains all variables
 * which are different in the two given objects.
 */

char *get_ob_diff(object *op,object *op2) {/* I plan to optimize this heavily */
  static char buf2[MAX_BUF];
  static char buf[VERY_BIG_BUF];
  int tmp;
  buf[0]='\0';
  if(op->name && op->name!=op2->name) {
    sprintf(buf2,"name %s\n",op->name);
    strcat(buf,buf2);
  }
  if(op->race && op->race!=op2->race) {
    sprintf(buf2,"race %s\n",op->race);
    strcat(buf,buf2);
  }
  if(op->slaying && op->slaying!=op2->slaying) {
    sprintf(buf2,"slaying %s\n",op->slaying);
    strcat(buf,buf2);
  }
  if(op->msg && op->msg!=op2->msg) {
    strcat(buf,"msg\n");
    strcat(buf,op->msg);
    strcat(buf,"endmsg\n");
  }
  if(op->other_arch!=op2->other_arch&&op->other_arch!=NULL && 
     op->other_arch->name) {
    sprintf(buf2,"other_arch %s\n",op->other_arch->name);
    strcat(buf,buf2);
  }
  if(op->face.number!=op2->face.number) {
      sprintf(buf2,"%s %s\n",variable_const[V_FACE], 
	      xbm_names[op->face.number]);
      strcat(buf,buf2);
  }
  if(op->face.fg!=op2->face.fg) {
      sprintf(buf2,"%s %s\n",variable_const[V_COLOR_FG], 
	      coloralias[(int)op->face.fg]);
      strcat(buf,buf2);
  }
  if(op->face.bg!=op2->face.bg) {
      sprintf(buf2,"%s %s\n",variable_const[V_COLOR_BG], 
	      coloralias[(int)op->face.bg]);
      strcat(buf,buf2);
  }
  if(op->stats.Str!=op2->stats.Str)
    save_long(buf,variable_const[V_STR],op->stats.Str);
  if(op->stats.Dex!=op2->stats.Dex)
    save_long(buf,variable_const[V_DEX],op->stats.Dex);
  if(op->stats.Con!=op2->stats.Con)
    save_long(buf,variable_const[V_CON],op->stats.Con);
  if(op->stats.Wis!=op2->stats.Wis)
    save_long(buf,variable_const[V_WIS],op->stats.Wis);
  if(op->stats.Cha!=op2->stats.Cha)
    save_long(buf,variable_const[V_CHA],op->stats.Cha);
  if(op->stats.Int!=op2->stats.Int)
    save_long(buf,variable_const[V_INT],op->stats.Int);
  if(op->stats.hp!=op2->stats.hp)
    save_long(buf,variable_const[V_HP],op->stats.hp);
  if(op->stats.maxhp!=op2->stats.maxhp)
    save_long(buf,variable_const[V_MAXHP],op->stats.maxhp);
  if(op->stats.sp!=op2->stats.sp)
    save_long(buf,variable_const[V_SP],op->stats.sp);
  if(op->stats.maxsp!=op2->stats.maxsp)
    save_long(buf,variable_const[V_MAXSP],op->stats.maxsp);
  if(op->stats.exp!=op2->stats.exp)
    save_long(buf,variable_const[V_EXP],op->stats.exp);
  if(op->stats.food!=op2->stats.food)
    save_long(buf,variable_const[V_FOOD],op->stats.food);
  if(op->stats.dam!=op2->stats.dam)
    save_long(buf,variable_const[V_DAM],op->stats.dam);
  if(op->stats.luck!=op2->stats.luck)
    save_long(buf,variable_const[V_LUCK],op->stats.luck);
  if(op->stats.wc!=op2->stats.wc)
    save_long(buf,variable_const[V_WC],op->stats.wc);
  if(op->stats.ac!=op2->stats.ac)
    save_long(buf,variable_const[V_AC],op->stats.ac);
  if(op->armour!=op2->armour)
    save_long(buf,variable_const[V_ARMOUR],op->armour);
  if(op->x!=op2->x) 
    save_long(buf,variable_const[V_X],op->x);
  if(op->y!=op2->y)
    save_long(buf,variable_const[V_Y],op->y);
  if(op->speed!=op2->speed) {
    sprintf(buf2,"speed %f\n",op->speed);
    strcat(buf,buf2);
  }
  if(op->speed > 0 && op->speed_left!=op2->speed_left) {
    sprintf(buf2,"speed_left %f\n",op->speed_left);
    strcat(buf,buf2);
  }
  if(op->move_status != op2->move_status)
    save_long(buf,variable_const[V_MOVE_STATUS],op->move_status);
  if(op->move_type != op2->move_type)
    save_long(buf,variable_const[V_ATT_MOVE],op->move_type);
  if(op->nrof!=op2->nrof)
    save_long(buf,variable_const[V_NROF],op->nrof);
  if(op->level!=op2->level)
    save_long(buf,variable_const[V_LEVEL],op->level);
  if(op->direction!=op2->direction)
    save_long(buf,variable_const[V_DIRECTION],op->direction);
  if(op->type!=op2->type)
    save_long(buf,variable_const[V_TYPE],op->type);
  if(op->immune!=op2->immune)
    save_long(buf,variable_const[V_IMMUNE],op->immune);
  if(op->protected!=op2->protected)
    save_long(buf,variable_const[V_PROTECTED],op->protected);
  if(op->attacktype!=op2->attacktype)
    save_long(buf,variable_const[V_ATTACKTYPE],op->attacktype);
  if(op->vulnerable!=op2->vulnerable)
    save_long(buf,variable_const[V_VULNERABLE],op->vulnerable);
  if(op->material!=op2->material)
    save_long(buf,variable_const[V_MATERIAL],op->material);
  if(op->value!=op2->value)
    save_long(buf,variable_const[V_VALUE],op->value);
  if(op->carrying!=op2->carrying)
    save_long(buf,variable_const[V_CARRYING],op->carrying);
  if(op->weight!=op2->weight)
    save_long(buf,variable_const[V_WEIGHT],op->weight);
  if(op->invisible!=op2->invisible)
    save_long(buf,variable_const[V_INVISIBLE],op->invisible);
  if(op->state!=op2->state)
    save_long(buf,variable_const[V_STATE],op->state);
  if(op->magic!=op2->magic)
    save_long(buf,variable_const[V_MAGIC],op->magic);
  if(op->last_heal!=op2->last_heal)
    save_long(buf,variable_const[V_LAST_HEAL],op->last_heal);
  if(op->last_sp!=op2->last_sp)
    save_long(buf,variable_const[V_LAST_SP],op->last_sp);
  if(op->last_eat!=op2->last_eat)
    save_long(buf,variable_const[V_LAST_EAT],op->last_eat);
  if(IS_LINKED(op) && (tmp = get_button_value(op)))
    save_long(buf,variable_const[V_CONNECTED],tmp);
#ifdef NPC_PROG
  if(op->npc_status!=op2->npc_status)
    save_long(buf,variable_const[V_NPC_STATUS],op->npc_status);
  if(op->npc_program!=op2->npc_program)
    save_long(buf,variable_const[V_NPC_PROGRAM],op->npc_program);
#endif

#if 0
  if(op->run_away!=op2->run_away)
    save_long(buf,variable_const[V_EDITABLE],op->arch->editable);
#endif

/* Eneq(@csd.uu.se): Handles run_away and pick_up */
  if(op->run_away!=op2->run_away)
    save_long(buf,variable_const[V_RUN_AWAY],op->run_away);
  if(op->pick_up!=op2->pick_up)
    save_long(buf,variable_const[V_PICK_UP],op->pick_up);

/* Vick (@bern.docs.uu.se) @921107 -> Handle 'will_apply' &
   'random_movement.*/

  if (op->will_apply!=op2->will_apply)
    save_long(buf,variable_const[V_WILL_APPLY],op->will_apply);

/* Mol(@meryl.csd.uu.se) 921108  Handle can_apply */
  if (op->can_apply!=op2->can_apply)
    save_long(buf,variable_const[V_CAN_APPLY],op->can_apply);

  if(IS_ALIVE(op)!=IS_ALIVE(op2))
    BUFADD(IS_ALIVE(op),V_ALIVE);
  if(IS_APPLIED(op)!=IS_APPLIED(op2))
    BUFADD(IS_APPLIED(op),V_APPLIED);
  if(IS_UNPAID(op)!=IS_UNPAID(op2))
    BUFADD(IS_UNPAID(op),V_UNPAID);
  if(NEED_AN(op)!=NEED_AN(op2))
    BUFADD(NEED_AN(op),V_NEED_AN);
  if(NEED_IE(op)!=NEED_IE(op2))
    BUFADD(NEED_IE(op),V_NEED_IE);
  if(NO_PICK(op)!=NO_PICK(op2))
    BUFADD(NO_PICK(op),V_NO_PICK);
  if(NO_PASS(op)!=NO_PASS(op2))
    BUFADD(NO_PASS(op),V_NO_PASS);
  if(WALK_ON(op)!=WALK_ON(op2))
    BUFADD(WALK_ON(op),V_WALK_ON);
  if(WALK_OFF(op)!=WALK_OFF(op2))
    BUFADD(WALK_OFF(op),V_WALK_OFF);
  if(FLY_ON(op)!=FLY_ON(op2))
    BUFADD(FLY_ON(op),V_FLY_ON);
  if(FLY_OFF(op)!=FLY_OFF(op2))
    BUFADD(FLY_OFF(op),V_FLY_OFF);
  if(ANIMATED(op)!=ANIMATED(op2))
    BUFADD(ANIMATED(op),V_IS_ANIMATED);
  if(SLOW_MOVE(op)!=SLOW_MOVE(op2)) {
    sprintf(buf2,"%s %f\n",variable_const[V_SLOW_MOVE],SLOW_PENALTY(op));
    strcat(buf,buf2);
  }
  if(IS_FLYING(op)!=IS_FLYING(op2))
    BUFADD(IS_FLYING(op),V_FLYING);
  if(IS_MONSTER(op)!=IS_MONSTER(op2))
    BUFADD(IS_MONSTER(op),V_MONSTER);
  if(IS_FRIENDLY(op)!=IS_FRIENDLY(op2))
    BUFADD(IS_FRIENDLY(op),V_FRIENDLY);
  if(IS_GENERATOR(op)!=IS_GENERATOR(op2))
    BUFADD(IS_GENERATOR(op),V_GENERATOR);
  if(AUTO_APPLY(op)!=AUTO_APPLY(op2))
    BUFADD(AUTO_APPLY(op),V_AUTO_APPLY);
  if(IS_TREASURE(op)!=IS_TREASURE(op2))
    BUFADD(IS_TREASURE(op),V_TREASURE);
  if(APPLY_ONCE(op)!=APPLY_ONCE(op2))
    BUFADD(APPLY_ONCE(op),V_APPLY_ONCE);
  if(SEE_INVISIBLE(op)!=SEE_INVISIBLE(op2))
    BUFADD(SEE_INVISIBLE(op),V_SEE_INVISIBLE);
  if(CAN_ROLL(op)!=CAN_ROLL(op2))
    BUFADD(CAN_ROLL(op),V_CAN_ROLL);
  if(IS_TURNING(op)!=IS_TURNING(op2))
    BUFADD(IS_TURNING(op),V_IS_TURNING);
  if(IS_TURNABLE(op)!=IS_TURNABLE(op2))
    BUFADD(IS_TURNABLE(op),V_IS_TURNABLE);
  if(IS_USED_UP(op)!=IS_USED_UP(op2))
    BUFADD(IS_USED_UP(op),V_IS_USED_UP);
  if(IDENTIFIED(op)!=IDENTIFIED(op2))
    BUFADD(IDENTIFIED(op),V_IDENTIFIED);
  if(REFLECTING(op)!=REFLECTING(op2))
    BUFADD(REFLECTING(op),V_REFLECTING);
  if(CHANGING(op)!=CHANGING(op2))
    BUFADD(CHANGING(op),V_CHANGING);
  if(SPLITTING(op)!=SPLITTING(op2))
    BUFADD(SPLITTING(op),V_SPLITTING);
  if(HITBACK(op)!=HITBACK(op2))
    BUFADD(HITBACK(op),V_HITBACK);
  if(STARTEQUIP(op)!=STARTEQUIP(op2))
    BUFADD(STARTEQUIP(op),V_STARTEQUIP);
  if(BLOCKSVIEW(op)!=BLOCKSVIEW(op2))
    BUFADD(BLOCKSVIEW(op),V_BLOCKSVIEW);
  if(UNDEAD(op)!=UNDEAD(op2))
    BUFADD(UNDEAD(op),V_UNDEAD);
  if(SCARED(op)!=SCARED(op2))
    BUFADD(SCARED(op),V_SCARED);
  if(UNAGGRESSIVE(op)!=UNAGGRESSIVE(op2))
    BUFADD(UNAGGRESSIVE(op),V_UNAGGRESSIVE);
  if(REFL_MISSILE(op)!=REFL_MISSILE(op2))
    BUFADD(REFL_MISSILE(op),V_REFLECT_MISSILE);
  if(REFL_SPELL(op)!=REFL_SPELL(op2))
    BUFADD(REFL_SPELL(op),V_REFLECT_SPELL);
  if(NO_MAGIC(op)!=NO_MAGIC(op2))
    BUFADD(NO_MAGIC(op),V_NO_MAGIC);
  if(IS_WIZ(op)!=IS_WIZ(op2))
    BUFADD(IS_WIZ(op),V_WIZ);
  if(WAS_WIZ(op)!=WAS_WIZ(op2))
    BUFADD(WAS_WIZ(op),V_WAS_WIZ);
  if(NO_FIX_PLAYER(op)!=NO_FIX_PLAYER(op2))
    BUFADD(NO_FIX_PLAYER(op),V_NO_FIX_PLAYER);
  if(TEAR_DOWN(op)!=TEAR_DOWN(op2))
    BUFADD(TEAR_DOWN(op),V_TEAR_DOWN);
  if(RUN_AWAY(op)!=RUN_AWAY(op2))
    BUFADD(RUN_AWAY(op),V_RUN_AWAY);
  if(PASS_THRU(op)!=PASS_THRU(op2))
    BUFADD(PASS_THRU(op),V_PASS_THRU);
  if(CAN_PASS_THRU(op)!=CAN_PASS_THRU(op2))
    BUFADD(CAN_PASS_THRU(op),V_CAN_PASS_THRU);
  if(PICKUP(op)!=PICKUP(op2))
    BUFADD(PICKUP(op),V_PICK_UP);
  if(IS_CONTAINER(op)!=IS_CONTAINER(op2))
    BUFADD(IS_CONTAINER(op),V_CONTAINER);
  if(NO_DROP(op)!=NO_DROP(op2))
    BUFADD(NO_DROP(op),V_NO_DROP);
  if(NO_PRETEXT(op)!=NO_PRETEXT(op2))
    BUFADD(NO_PRETEXT(op),V_NO_PRETEXT);
  if(CAN_CAST_SPELL(op)!=CAN_CAST_SPELL(op2))
    BUFADD(CAN_CAST_SPELL(op),V_CAN_CAST_SPELL);
  if(CAN_USE_SCROLL(op)!=CAN_USE_SCROLL(op2))
    BUFADD(CAN_USE_SCROLL(op),V_CAN_USE_SCROLL);
  if(CAN_USE_WAND(op)!=CAN_USE_WAND(op2))
    BUFADD(CAN_USE_WAND(op),V_CAN_USE_WAND);
  if(CAN_USE_BOW(op)!=CAN_USE_BOW(op2))
    BUFADD(CAN_USE_BOW(op),V_CAN_USE_BOW);
  if(CAN_USE_ARMOUR(op)!=CAN_USE_ARMOUR(op2))
    BUFADD(CAN_USE_ARMOUR(op),V_CAN_USE_ARMOUR);
  if(CAN_USE_WEAPON(op)!=CAN_USE_WEAPON(op2))
    BUFADD(CAN_USE_WEAPON(op),V_CAN_USE_WEAPON);
  if(CAN_USE_RING(op)!=CAN_USE_RING(op2))
    BUFADD(CAN_USE_RING(op),V_CAN_USE_RING);
  if(HAS_READY_WAND(op)!=HAS_READY_WAND(op2))
    BUFADD(HAS_READY_WAND(op),V_HAS_READY_WAND);
  if(HAS_READY_BOW(op)!=HAS_READY_BOW(op2))
    BUFADD(HAS_READY_BOW(op),V_HAS_READY_BOW);
  if(XRAYS(op)!=XRAYS(op2))
    BUFADD(XRAYS(op),V_XRAYS);
  if(IS_FLOOR(op)!=IS_FLOOR(op2))
    BUFADD(IS_FLOOR(op),V_IS_FLOOR);
  if(LIFESAVE(op)!=LIFESAVE(op2))
    BUFADD(LIFESAVE(op),V_LIFESAVE);
  if(NO_STRENGTH(op)!=NO_STRENGTH(op2))
    BUFADD(NO_STRENGTH(op),V_NO_STRENGTH);
  if(SLEEP(op)!=SLEEP(op2))
    BUFADD(SLEEP(op),V_SLEEP);
  if(STAND_STILL(op)!=STAND_STILL(op2))
    BUFADD(STAND_STILL(op),V_STAND_STILL);
  if(RANDOM_MOVE(op)!=RANDOM_MOVE(op2))
    BUFADD(RANDOM_MOVE(op),V_RANDOM_MOVE);
  if(ONLY_ATTACK(op)!=ONLY_ATTACK(op2))
    BUFADD(ONLY_ATTACK(op),V_ONLY_ATTACK);
  if(IS_CONFUSED(op)!=IS_CONFUSED(op2))
    BUFADD(IS_CONFUSED(op),V_CONFUSED);
  if(STEALTH(op)!=STEALTH(op2))
    BUFADD(STEALTH(op),V_STEALTH);
  if(buf[0]=='\0')
    return NULL;
  return buf;
}

/*
 * Dumps all variables in an object to a file.
 * If big 0 of flag is set, do a raw save without any checks.
 * If bit 1 of flag is set, don't remove the object after save.
 */

void save_object(FILE *fp,object *op, int flag) {
  archetype *at;
  char *cp;
  object *tmp,*old;

  if(op->owner!=NULL)
    return;
  if(!(flag&1)&&(IS_UNPAID(op))) {
    remove_ob(op);
    free_object(op);
    return;
  }
  if((at=op->arch)!=NULL)
    fprintf(fp,"arch %s\n",at->name);
  if((cp=get_ob_diff(op,&((at==NULL?empty_archetype:at)->clone)))!=NULL)
    fputs(cp,fp);

/* Eneq(@csd.uu.se): Added this to allow containers being saved with contents*/

  old=NULL;

  if(flag & 2)
    for(tmp=op->inv;tmp!=NULL;tmp=tmp->below)
      save_object(fp,tmp,flag);
  else while ((tmp=op->inv)!=NULL) {
      if(old==tmp) {
	  LOG(llevError,"Recursive loop in inventory\n");
	  break;
      }
      save_object(fp,tmp,flag); 
      old=tmp;
  }
   
  if (!(flag&2)) {
      remove_ob(op);
      free_object (op);
  }

  fprintf(fp,"end\n");
}

/*
 * Returns true if the given color exists in the internal list
 * of legal colors.
 */

char find_color(char *name) {
  int i;
  for(i=0;i<13;i++)
    if(!strcmp(name,coloralias[i]))
      return i;
  LOG(llevError,"Unknown color: %s\n",name);
  return 0;
}

/*
 * set_variable() expects buf to be a line with two arguments, the first
 * being a variable and the second being the value (which can be anything from
 * an integer to a string). 
 * The object given will have the given variable modified.
 *
 * -1 will be returned if there is no such variable
 * 0 will be returned if the variable is to be ignored
 * 1 will be returned if the variable was "anim"
 * 2 will be returned if the variable was "end"
 * 3 will be returned if the variable was "Inventory"
 * 4 will be returned if the variable was "More"
 * 5 will be returned if the variable was "msg"
 * 6 will be returned if the variable was "endmsg"
 * otherwise 0 will be returned
 */

int set_variable(object *op,char *buf) {
  char *vbp;
  int value;
  if((vbp=strchr(buf,'\n'))!=NULL) /* Change newline into end of string */
    *vbp='\0';
  if((vbp=strchr(buf,' '))==NULL) /* No argument to the variable */
    value=0,vbp=NULL;
  else {
    *vbp='\0',vbp++;
    value=atol(vbp);
  }
  switch(get_variable(buf)) {
  case V_ARCH:
    op->arch=find_archetype(vbp);
    if(op->arch!=NULL)
      copy_object(&op->arch->clone,op);
    break;
  case V_OTHER_ARCH:
    op->other_arch=find_archetype(vbp);
    break;
  case V_RACE:
    if(op->race!=NULL)
      free_string(op->race);
    op->race=add_string(vbp);
    break;
  case V_SLAYING:
    if(op->slaying!=NULL)
      free_string(op->slaying);
    op->slaying=add_string(vbp);
    break;
  case V_MSG:
    return 5;
  case V_MSGEND:
    return 6;
  case V_INVENTORY:
    return 3;
  case V_MORE:
    return 4;
  case V_ANIM:
    if(op->arch==NULL) {
      LOG(llevError,"Got animation in object without archetype:\n");
      return 0;
    }
    SET_ANIMATE(op);
    return 1;
  case V_END:
    return 2;
  case V_OBJECT:
    if(vbp==NULL) {
      LOG(llevError,"Object lacks name.\n");
      return 0;
    }
    if(op->arch!=NULL)
      op->arch->name=add_string(vbp);
    op->name=add_string(vbp);
    break;
  case V_NAME:
    if(*vbp=='\0') {
      LOG(llevError,"name without name\n");
      break;
    }
    if(op->name!=NULL)
      free_string(op->name);
    op->name=add_string(vbp);
    break;
  case V_SPEED:
    sscanf(vbp,"%f",&op->speed);
    if (op->speed<0)
      op->speed_left=op->speed_left-RANDOM()%100/100.0;
    break;
  case V_SPEED_LEFT:
    sscanf(vbp,"%f",&op->speed_left);
    break;
  case V_SLOW_MOVE:
    {
      float f;
      sscanf(vbp,"%f",&f);
      SET_SLOW_PENALTY(op,f);
      SET_SLOW_MOVE(op);
    }
    break;
/* Eneq(@csd.uu.se): Added handleof archetype-field anim_speed */

  case V_ANIM_SPEED:
    op->anim_speed = (unsigned char) value;
    break;
/* kholland @ sunlab.cit.cornell.edu added move_type and status */
  case V_ATT_MOVE:
    op->move_type = (unsigned short) value;
    break;
  case V_MOVE_STATUS:
    op->move_status = (signed long) value;
    break;
/*
 * Eneq(@csd.uu.se): Added handle of container <no> where no is containers
 * weight limit, and no_drop which makes an item undroppable, and bonus
 */
  case V_BONUS:
    op->bonus=(signed long) value;
    break;
  case V_CONTAINER:
    op->weight_limit=(signed long) value;
    if (value)
        SET_CONTAINER(op);
    else
        UNSET_CONTAINER(op);
    break;
  case V_NO_DROP:
    if (value)
        SET_NO_DROP(op);
    else
        UNSET_NO_DROP(op);
    break;

  case V_FACE:
    op->face.number=(Fontindex)FindFace (vbp);
    break;
  case V_COLOR_FG:
    if(op->arch==NULL) {
      LOG(llevError,"Got foreground color in object without archetype:\n");
      dump_object(op);
      LOG(llevError,"%s\n",errmsg);
      return 0;
    }
    op->face.fg = find_color(vbp);
    break;
  case V_COLOR_BG:
    if(op->arch==NULL) {
      LOG(llevError,"Got background color in object without archetype:\n");
      dump_object(op);
      LOG(llevError,"%s\n",errmsg);
      return 0;
    }
    op->face.bg = find_color(vbp);
    break;
  case V_STR:
    op->stats.Str=(signed char) value;
    break;
  case V_DEX:
    op->stats.Dex=(signed char) value;
    break;
  case V_CON:
    op->stats.Con=(signed char) value;
    break;
  case V_WIS:
    op->stats.Wis=(signed char) value;
    break;
  case V_CHA:
    op->stats.Cha=(signed char) value;
    break;
  case V_INT:
    op->stats.Int=(signed char) value;
    break;
  case V_HP:
    op->stats.hp=(signed short) value;
    break;
  case V_MAXHP:
    op->stats.maxhp=(signed short) value;
    break;
  case V_SP:
    op->stats.sp=(signed short) value;
    break;
  case V_MAXSP:
    op->stats.maxsp=(signed short) value;
    break;
  case V_EXP:
    op->stats.exp=(signed long) value;
    break;
  case V_FOOD:
    op->stats.food=(signed short) value;
    break;
  case V_DAM:
    op->stats.dam=(signed char) value;
    break;
  case V_LUCK:
    op->stats.luck=(signed char) value;
    break;
  case V_WC:
    op->stats.wc=(signed char) value;
    break;
  case V_AC:
    op->stats.ac=(signed char) value;
    break;
  case V_ARMOUR:
    op->armour=(signed char) value;
    break;
  case V_X:
    op->x=(signed short) value,
    op->ox=(signed short) value;
    break;
  case V_Y:
    op->y=(signed short) value,
    op->oy=(signed short) value;
    break;
  case V_NROF:
    op->nrof=(unsigned long) value;
    break;
  case V_LEVEL:
    op->level=(signed char) value;
    break;
  case V_DIRECTION:
    op->direction=(signed char) value;
    break;
  case V_TYPE:
    op->type=(unsigned char) value;
    break;
  case V_IMMUNE:
    op->immune=(unsigned int) value;
    break;
  case V_PROTECTED:
    op->protected=(unsigned int) value;
    break;
  case V_ATTACKTYPE:
    op->attacktype=(unsigned int) value;
    break;
  case V_VULNERABLE:
    op->vulnerable=(unsigned int) value;
    break;
  case V_MATERIAL:
    op->material=(unsigned char) value;
    break;
  case V_VALUE:
    op->value=(signed long) value;
    break;
  case V_CARRYING:
    op->carrying=(signed long) value;
    break;
  case V_WEIGHT:
    op->weight=(signed long) value;
    break;
  case V_INVISIBLE:
    op->invisible=(signed short) value;
    break;
  case V_MAGIC:
    op->magic=(unsigned char) value;
    break;
  case V_STATE:
    op->state=(unsigned char) value;
    break;
  case V_LAST_HEAL:
    op->last_heal=(signed short) value;
    break;
  case V_LAST_SP:
    op->last_sp=(signed short) value;
    break;
  case V_LAST_EAT:
    op->last_eat=(signed short) value;
    break;
  case V_CONNECTED:
    add_button_link(op, op->map, value);
    break;
#ifdef NPC_PROG
  case V_NPC_STATUS:
    op->npc_status=(unsigned short) value;
    break;
  case V_NPC_PROGRAM:
    op->npc_program=(unsigned short) value;
    break;
#endif

  case V_EDITABLE:
    op->arch->editable = value;
    break;

/* Eneq(@csd.uu.se): Handle PICK_UP */

  case V_PICK_UP:
    op->pick_up=(unsigned char) value;
    break;

/* Eneq(@csd.uu.se): Handle RUN_AWAY, (CAN_)PASS_THRU. */

  case V_RUN_AWAY:
    op->run_away = (unsigned short) value;
    break;

/* Vick's (vick@bern.docs.uu.se) patch 921107 : will_apply, which
   enables a monster to apply things on the ground. */

  case V_WILL_APPLY:
    op->will_apply = (unsigned char) value;
    break;

/* Vick's (vick@bern.docs.uu.se) patch 921108 : random_movement
   which makes the monster move totally unrelated to the player(s). */

  case V_RANDOM_MOVEMENT:
    if(value)
      SET_RANDOM_MOVE(op);
    else
      UNSET_RANDOM_MOVE(op);
    break;

  case V_PASS_THRU:
    if (value)
	SET_PASS_THRU(op);
    else
	UNSET_PASS_THRU(op);
    break;
 case V_CAN_PASS_THRU:
    if (value) 
	SET_CAN_PASS_THRU(op);
    else
	UNSET_CAN_PASS_THRU(op);
    break;

/* Mol(@csd.docs.uu.se) patch 921108 : can_apply, is similair to will_apply,
   but applies thing it has picked up. */

  case V_CAN_APPLY:
    op->can_apply = (unsigned char) value;
    break;

/* Eneq(@csd.uu.se): Added archetype-field no_pretext which indicates that no 
   text should be printed before the name when examining */

  case V_NO_PRETEXT:
    if (value)
        SET_NO_PRETEXT(op);
    else
        UNSET_NO_PRETEXT(op);
    break;

  case V_ALIVE:
    if(value)
      SET_ALIVE(op);
    else
      UNSET_ALIVE(op);
    break;
  case V_APPLIED:
    if(value)
      SET_APPLIED(op);
    else
      UNSET_APPLIED(op);
    break;
  case V_UNPAID:
    if(value)
      SET_UNPAID(op);
    else
      UNSET_UNPAID(op);
    break;
  case V_NEED_AN:
    if(value)
      SET_AN(op);
    else
      UNSET_AN(op);
    break;
  case V_NEED_IE:
    if(value)
      SET_IE(op);
    else
     UNSET_IE(op);
    break;
  case V_NO_PICK:
    if(value)
      SET_NO_PICK(op);
    else
      UNSET_NO_PICK(op);
    break;
  case V_NO_PASS:
    if(value)
      SET_NO_PASS(op);
    else
      UNSET_NO_PASS(op);
    break;
  case V_WALK_ON:
    if(value)
      SET_WALK_ON(op);
    else
      UNSET_WALK_ON(op);
    break;
  case V_WALK_OFF:
    if(value)
      SET_WALK_OFF(op);
    else
      UNSET_WALK_OFF(op);
    break;
  case V_FLY_ON:
    if(value)
      SET_FLY_ON(op);
    else
      UNSET_FLY_ON(op);
    break;
  case V_FLY_OFF:
    if(value)
      SET_FLY_OFF(op);
    else
      UNSET_FLY_OFF(op);
    break;
  case V_IS_ANIMATED:
    if(value)
      SET_ANIMATE(op);
    else
      UNSET_ANIMATE(op);
    break;
  case V_FLYING:
    if(value)
      SET_FLY(op);
    else
      UNSET_FLY(op);
    break;
  case V_MONSTER:
    if(value)
      SET_MONSTER(op);
    else
      UNSET_MONSTER(op);
    break;
  case V_FRIENDLY:
    if(value) {
      SET_FRIENDLY(op);
      if (op->type != PLAYER) {
        LOG(llevDebug, "Adding friendly object %s.\n",op->name);
        add_friendly_object(op);
      }
    }
    else
      UNSET_FRIENDLY(op);
    break;
  case V_GENERATOR:
      if(value)
      SET_GENERATOR(op);
    else
      UNSET_GENERATOR(op);
    break;
  case V_AUTO_APPLY:
    if(value)
      SET_AUTO_APPLY(op);
    else
      UNSET_AUTO_APPLY(op);
    break;
  case V_TREASURE:
    if(value)
      SET_TREASURE(op);
    else
      UNSET_TREASURE(op);
    break;
  case V_APPLY_ONCE:
    if(value)
      SET_APPLY_ONCE(op);
    else
      UNSET_APPLY_ONCE(op);
    break;
  case V_SEE_INVISIBLE:
    if(value)
      SET_SEE_INVISIBLE(op);
    else
      UNSET_SEE_INVISIBLE(op);
    break;
  case V_CAN_ROLL:
    if(value)
      SET_CAN_ROLL(op);
    else
      UNSET_CAN_ROLL(op);
    break;
  case V_IS_TURNING:
    if(value)
      SET_IS_TURNING(op);
      else
      UNSET_IS_TURNING(op);
    break;
  case V_IS_TURNABLE:
    if(value)
      SET_IS_TURNABLE(op);
    else
      UNSET_IS_TURNABLE(op);
    break;
  case V_IS_USED_UP:
    if(value)
      SET_IS_USED_UP(op);
    else
      UNSET_IS_USED_UP(op);
    break;
  case V_IDENTIFIED:
    if(value)
      SET_IDENTIFIED(op);
    else
      UNSET_IDENTIFIED(op);
    break;
  case V_REFLECTING:
    if(value)
      SET_REFLECTING(op);
    else
      UNSET_REFLECTING(op);
    break;
  case V_CHANGING:
    if(value)
      SET_CHANGING(op);
    else
      UNSET_CHANGING(op);
    break;
  case V_SPLITTING:
    if(value)
      SET_SPLITTING(op);
    else
      UNSET_SPLITTING(op);
    break;
  case V_HITBACK:
    if(value)
      SET_HITBACK(op);
    else
      UNSET_HITBACK(op);
    break;
  case V_STARTEQUIP:
    if(value)
      SET_STARTEQUIP(op);
    else
      UNSET_STARTEQUIP(op);
    break;
  case V_BLOCKSVIEW:
    if(value)
      SET_BLOCKSVIEW(op);
    else
      UNSET_BLOCKSVIEW(op);
    break;
  case V_UNDEAD:
    if(value)
      SET_UNDEAD(op);
    else
      UNSET_UNDEAD(op);
    break;
  case V_SCARED:
    if(value)
      SET_SCARED(op);
    else
      UNSET_SCARED(op);
    break;
  case V_UNAGGRESSIVE:
    if(value)
      SET_UNAGGRESSIVE(op);
    else
      UNSET_UNAGGRESSIVE(op);
    break;
  case V_REFLECT_MISSILE:
    if(value)
      SET_REFL_MISSILE(op);
    else
      UNSET_REFL_MISSILE(op);
    break;
  case V_REFLECT_SPELL:
    if(value)
      SET_REFL_SPELL(op);
    else
      UNSET_REFL_SPELL(op);
    break;
  case V_NO_MAGIC:
    if(value)
      SET_NO_MAGIC(op);
    else
      UNSET_NO_MAGIC(op);
    break;
  case V_WIZ:
    if(value)
      SET_WIZ(op);
    else
      UNSET_WIZ(op);
    break;
  case V_WAS_WIZ:
    if(value)
      SET_WAS_WIZ(op);
    break;
  case V_NO_FIX_PLAYER:
    if(value)
      SET_NO_FIX_PLAYER(op);
    else
      UNSET_NO_FIX_PLAYER(op);
    break;
  case V_TEAR_DOWN:
    if(value)
      SET_TEAR_DOWN(op);
    else
      UNSET_TEAR_DOWN(op);
    break;
  case V_CAN_CAST_SPELL:
    if(value)
      SET_CAST_SPELL(op);
    else
      UNSET_CAST_SPELL(op);
    break;
  case V_CAN_USE_SCROLL:
    if(value)
      SET_USE_SCROLL(op);
    else
      UNSET_USE_SCROLL(op);
    break;
  case V_CAN_USE_WAND:
    if(value)
      SET_USE_WAND(op);
    else
      UNSET_USE_WAND(op);
    break;
  case V_CAN_USE_BOW:
    if(value)
      SET_USE_BOW(op);
    else
      UNSET_USE_BOW(op);
    break;
  case V_CAN_USE_ARMOUR:
    if(value)
      SET_USE_ARMOUR(op);
    else
      UNSET_USE_ARMOUR(op);
    break;
  case V_CAN_USE_WEAPON:
    if(value)
      SET_USE_WEAPON(op);
    else
      UNSET_USE_WEAPON(op);
    break;
  case V_CAN_USE_RING:
    if(value)
      SET_USE_RING(op);
    else
      UNSET_USE_RING(op);
    break;
  case V_HAS_READY_WAND:
    if(value)
      SET_READY_WAND(op);
    else
      UNSET_READY_WAND(op);
    break;
  case V_HAS_READY_BOW:
    if(value)
      SET_READY_BOW(op);
    else
      UNSET_READY_BOW(op);
    break;
  case V_XRAYS:
    if(value)
      SET_XRAYS(op);
    else
      UNSET_XRAYS(op);
    break;
  case V_IS_FLOOR:
    if(value)
      SET_IS_FLOOR(op);
    else
      UNSET_IS_FLOOR(op);
    break;
  case V_LIFESAVE:
    if(value)
      SET_LIFESAVE(op);
    else
      UNSET_LIFESAVE(op);
    break;
  case V_NO_STRENGTH:
    if(value)
      SET_NO_STRENGTH(op);
    else
      UNSET_NO_STRENGTH(op);
    break;
  case V_SLEEP:
    if(value)
      SET_SLEEP(op);
    else
      UNSET_SLEEP(op);
    break;
  case V_STAND_STILL:
    if(value)
      SET_STAND_STILL(op);
    else
      UNSET_STAND_STILL(op);
    break;
  case V_ONLY_ATTACK:
    if(value)
      SET_ONLY_ATTACK(op);
    else
      UNSET_ONLY_ATTACK(op);
    break;
  case V_CONFUSED:
    if(value)
      SET_CONFUSED(op);
    else
      UNSET_CONFUSED(op);
    break;
  case V_STEALTH:
    if(value)
      SET_STEALTH(op);
    else
      UNSET_STEALTH(op);
    break;
  default:
    if(!strcmp(buf,"randomitems"))
      return 0;
    sprintf(errmsg,"Warning, unknown (or oldfashioned) variable: %s",buf);
    return -1;
  }
  return 0;
}

/*
 * Loads an object from the given file-pointer.
 * Variables will be read and parsed and patched into the object
 * until the string "end" is reached, or the end of the file.
 * If EOF is reached, it returnes false, otherwise true.
 */

int load_object(FILE *fp, object *op) {
  char buf[256];
  char msgbuf[VERY_BIG_BUF];
  Fontindex faces[MAX_ANIMATIONS];
  int position=1; /* 1 = standalone, 2 = inventory, 3 = head/tail link */
  int anim_start=0,msg_start=0;
  int i;
  object *tmp;

  while(fgets(buf,sizeof(buf),fp)!=NULL) {
    if(*buf=='#')
      continue;
    if(anim_start) {
      if(!strncmp("mina",buf,4)) {
        op->arch->animations=anim_start-1,anim_start=0;
        op->arch->faces = (Fontindex *) malloc
	    (sizeof(Fontindex) * (op->arch->animations+1));
        memcpy(op->arch->faces,faces,
               (op->arch->animations+1)*sizeof(Fontindex));
      } else {
	  faces[anim_start - 1] = FindFace(buf);
	  anim_start++;
      }
      continue;
    }
    if(msg_start&&strncmp(buf,"endmsg",6)) {
      strcat(msgbuf,buf);
      continue;
    }
    if(!strncmp(buf,"arch ",5)&&op->arch!=NULL) {
        object *otmp;

        tmp=get_object();
        fseek (fp, -strlen(buf), 1);
        load_object(fp, tmp);
        if (op->inv!=NULL) {
            for (otmp=op->inv; otmp->below!=NULL; otmp=otmp->below);
            otmp->below=tmp;
        } else op->inv=tmp;
        return load_object (fp, op);
    }
    switch(i=set_variable(op,buf)) {
    case -1:
      LOG(llevError,"%s\n",errmsg);
      break;
    case 1:
      anim_start=1;
      break;
    case 2:
      return position;
      break;
    case 3:
      position=2;
      break;
    case 4:
      position=3;
      break;
    case 5:
      msg_start=1;
      msgbuf[0]='\0';
      break;
    case 6:
      msg_start=0;
      op->msg=add_string(msgbuf);
      break;
    }
  }
  return 0;
}


/*
 * Loads an object from the given file-pointer.
 * Variables will be read and parsed and patched into the object
 * until the string "end" is reached, or the end of the file.
 * If EOF is reached, it returnes false, otherwise true.
 */

enum LoadState { unknown, arch, anim, message };

object *LoadObject (FILE *fp) {
    char buf[256];
    char msgbuf[VERY_BIG_BUF];
    Fontindex faces[MAX_ANIMATIONS];
    int anim_start = 0;
    object *op = NULL;
    enum LoadState state = unknown;
    
    while(fgets(buf,sizeof(buf),fp)!=NULL) {
	if(*buf=='#')
	    continue;

	switch (state) {
	  case unknown:
	    if (strncmp ("arch", buf, 4))
		LOG (llevError, "parse error in: %s\n (expecting arch)", buf);
	    else {
		state = arch;
		op = get_object();
		set_variable (op, buf);
	    }
	    break;

	  case arch:
	    if(!strncmp (buf, "arch ", 5)) {
		object *tmp;
		fseek (fp, -strlen(buf), 1);
		tmp = LoadObject(fp);
		insert_ob_in_ob (tmp, op);
		break;
	    }

	    switch(set_variable (op, buf)) {
	      case -1:
		LOG(llevError,"%s\n",errmsg);
		break;
		
	      case 0:
		break;

	      case 1:
		state = anim;
		anim_start = 0;
		break;

	      case 5:
		state = message;
		msgbuf[0] = '\0';
		break;

	      case 2:
		return op;
		break;

	      default:
		LOG(llevError,"LoadObject()\n");
		break;
	    }       
	    break;

	  case anim:
	    if(!strncmp ("mina", buf, 4)) {
		op->arch->animations = anim_start;
		op->arch->faces = (Fontindex *) malloc (sizeof (Fontindex) * anim_start);
		memcpy(op->arch->faces, faces, anim_start * sizeof (Fontindex));
		state = arch;
		break;
	    }
	    faces[anim_start++] = FindFace(buf);
	    break;

	  case message:
	    if(!strncmp (buf, "endmsg", 6)) {
		op->msg = add_string (msgbuf);
		state = arch;
		break;
	    }
	    strcat(msgbuf,buf);
	}
    }
    if (op)
	free_object (op);

    return NULL;
}

