/*
 * static char *rcsid_los_c =
 *   "$Id: los.c,v 1.3 1993/04/25 16:08:26 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.

    This file was made based on an idea by vidarl@ifi.uio.no
*/

#include <global.h>
#include <funcpoint.h>

typedef struct blstr {
  int x[4],y[4],b[4];
  int index;
} blocks;

blocks block[11][11];

/*
 * Used to initialise the array used by the LOS routines.
 */

void set_block(int x,int y,int bx, int by) {
  int index=block[x][y].index;
  block[x][y].x[index]=bx;
  block[x][y].y[index]=by;
  block[x][y].index++;
}

/*
 * initialises the array used by the LOS routines.
 */

void init_block() {
  int x,y;
  for(x=0;x<11;x++)
    for(y=0;y<11;y++) {
    block[x][y].index=0;
    }

/* region 1 */

  set_block(5,4,4,3);
  set_block(5,4,5,3);
  set_block(5,4,6,3);
  set_block(4,3,4,2);
  set_block(5,3,5,2);
  set_block(6,3,6,2);
  set_block(4,2,4,1);
  set_block(4,2,3,1);
  set_block(5,2,5,1);
  set_block(6,2,6,1);
  set_block(6,2,7,1);
  set_block(3,1,3,0);
  set_block(4,1,4,0);
  set_block(5,1,5,0);
  set_block(6,1,6,0);
  set_block(7,1,7,0);

/* region 2  */

  set_block(6,4,7,3);
  set_block(7,3,7,2);
  set_block(7,3,8,2);
  set_block(7,3,8,3);
  set_block(7,2,8,1);
  set_block(8,2,9,1);
  set_block(8,3,9,2);
  set_block(8,1,8,0);
  set_block(8,1,9,0);
  set_block(9,1,10,0);
  set_block(9,2,10,1);
  set_block(9,2,10,2);

/* region 3  */

  set_block(6,5,7,4);
  set_block(6,5,7,5);
  set_block(6,5,7,6);
  set_block(7,4,8,4);
  set_block(7,5,8,5);
  set_block(7,6,8,6);
  set_block(8,4,9,3);
  set_block(8,4,9,4);
  set_block(8,5,9,5);
  set_block(8,6,9,6);
  set_block(8,6,9,7);
  set_block(9,3,10,3);
  set_block(9,4,10,4);
  set_block(9,5,10,5);
  set_block(9,6,10,6);
  set_block(9,7,10,7);

/* region 4  */

  set_block(6,6,7,7);
  set_block(7,7,8,7);
  set_block(7,7,8,8);
  set_block(7,7,7,8);
  set_block(8,7,9,8);
  set_block(8,8,9,9);
  set_block(7,8,8,9);
  set_block(9,8,10,8);
  set_block(9,8,10,9);
  set_block(9,9,10,10);
  set_block(8,9,9,10);
  set_block(8,9,8,10);

/* region 5  */

  set_block(5,6,4,7);
  set_block(5,6,5,7);
  set_block(5,6,6,7);
  set_block(4,7,4,8);
  set_block(5,7,5,8);
  set_block(6,7,6,8);
  set_block(4,8,3,9);
  set_block(4,8,4,9);
  set_block(5,8,5,9);
  set_block(6,8,6,9);
  set_block(6,8,7,9);
  set_block(3,9,3,10);
  set_block(4,9,4,10);
  set_block(5,9,5,10);
  set_block(6,9,6,10);
  set_block(7,9,7,10);

/* region 6 */

  set_block(4,6,3,7);
  set_block(3,7,2,7);
  set_block(3,7,2,8);
  set_block(3,7,3,8);
  set_block(2,7,1,8);
  set_block(2,8,1,9);
  set_block(3,8,2,9);
  set_block(1,8,0,8);
  set_block(1,8,0,9);
  set_block(1,9,0,10);
  set_block(2,9,1,10);
  set_block(2,9,2,10);

/* region 7 */

  set_block(4,5,3,4);
  set_block(4,5,3,5);
  set_block(4,5,3,6);
  set_block(3,4,2,4);
  set_block(3,5,2,5);
  set_block(3,6,2,6);
  set_block(2,4,1,3);
  set_block(2,4,1,4);
  set_block(2,5,1,5);
  set_block(2,6,1,6);
  set_block(2,6,1,7);
  set_block(1,3,0,3);
  set_block(1,4,0,4);
  set_block(1,5,0,5);
  set_block(1,6,0,6);
  set_block(1,7,0,7);

/* region 8 */

  set_block(4,4,3,3);
  set_block(3,3,3,2);
  set_block(3,3,2,2);
  set_block(3,3,2,3);
  set_block(3,2,2,1);
  set_block(2,2,1,1);
  set_block(2,3,1,2);
  set_block(2,1,1,0);
  set_block(2,1,2,0);
  set_block(1,1,0,0);
  set_block(1,2,0,1);
  set_block(1,2,0,2);
}

/*
 * Used to initialise the array used by the LOS routines.
 */

void set_wall(object *op,int x,int y) {
  int i;
  for(i=0;i<block[x][y].index;i++) {
    int dx=block[x][y].x[i],dy=block[x][y].y[i];
    op->contr->blocked_los[dx][dy]=1;
    set_wall(op,dx,dy);
  }
}

/*
 * Used to initialise the array used by the LOS routines.
 */

void check_wall(object *op,int x,int y) {
  if(!block[x][y].index)
    return;
  if(blocks_view(op->map,op->x-5+x,op->y-5+y))
    set_wall(op,x,y);
  else {
    int i;
    for(i=0;i<block[x][y].index;i++)
      check_wall(op,block[x][y].x[i],block[x][y].y[i]);
  }
}

#if 0
void set_los(object *op) {
  (void)memset(op->contr->blocked_los,1,
               (WINRIGHT-WINLEFT+1)*(WINLOWER-WINUPPER+1));
}
#endif

/*
 * Clears/initialises the los-array associated to the player
 * controlling the object.
 */

void clear_los(object *op) {
  (void)memset(op->contr->blocked_los,0,
               (WINRIGHT-WINLEFT+1)*(WINLOWER-WINUPPER+1));
}

/*
 * expand_sight goes through the array of what the given player is
 * able to see, and expands the visible area a bit, so the player will,
 * to a certain degree, be able to see into corners.
 * This is somewhat suboptimal, would be better to improve the formula.
 * There are two versions of this function, based on wheter or not
 * CD_LINE_OF_SIGHT is defined.  If it is defined, the function
 * becomes a bit more time-consuming, but covers a few more "corners"...
 */

#ifdef CD_LINE_OF_SIGHT

void expand_sight(object *op) 
{
  int i,x,y, dx, dy;

  for(x=1;x<10;x++)	/* loop over inner squares */
    for(y=1;y<10;y++)
      if(!op->contr->blocked_los[x][y]&&
         !blocks_view(op->map,op->x-5+x,op->y-5+y))
        for(i=1;i<=8;i+=1) {	/* mark all directions */
          dx = x + freearr_x[i];
	  dy = y + freearr_y[i];
          if(op->contr->blocked_los[dx][dy] > 0) /* for any square blocked */
            op->contr->blocked_los[dx][dy]= -1;
	}

  /* clear mark squares */
  for (x = 0; x < 11; x++)
    for (y = 0; y < 11; y++)
      if (op->contr->blocked_los[x][y] < 0)
            op->contr->blocked_los[x][y] = 0;
}

#else /* CD_LINE_OF_SIGHT */

void expand_sight(object *op) {
  int i,x,y;
  for(x=0;x<11;x++)
    for(y=0;y<11;y++)
      if(!op->contr->blocked_los[x][y]&&
         !blocks_view(op->map,op->x-5+x,op->y-5+y))
        for(i=1;i<8;i+=2) {
          int dx=x+freearr_x[i],dy=y+freearr_y[i];
          if(dy<0||dy>10||dx<0||dx>10)
            continue;
          if(op->contr->blocked_los[dx][dy]&&
             blocks_view(op->map,op->x-5+dx,op->y-5+dy))
            op->contr->blocked_los[dx][dy]=0;
         }
}

#endif /* CD_LINE_OF_SIGHT */

/*
 * update_los() recalculates the array which specifies what is
 * visible for the given player-object.
 */

void update_los(object *op) {
#ifdef USE_LOS
  int i;
#endif
  if(IS_REMOVED(op))
    return;
#ifdef USE_LOS
  clear_los(op);
  if(IS_WIZ(op) /* ||XRAYS(op) */)
    return;
  for(i=1;i<9;i++)
    check_wall(op,5+freearr_x[i],5+freearr_y[i]);
  expand_sight(op);

  if (XRAYS(op)) {
    int x, y;
    for (x = -2; x <= 2; x++)
      for (y = -2; y <= 2; y++)
        op->contr->blocked_los[5 + x][5 + y] = 0;
  }
#endif
}

/*
 * This function makes sure that update_los() will be called for all
 * players on the given map within the next frame.
 * It is triggered by removal or inserting of objects which blocks
 * the sight in the map.
 */

void update_all_los(mapstruct *map) {
#ifdef USE_LOS
  player *pl;
  for(pl=first_player;pl!=NULL;pl=pl->next)
    if(pl->ob->map==map)
      pl->do_los=1;
#endif
}

/*
 * Debug-routine which dumps the array which specifies the visible
 * area of a player.  Triggered by the z key in DM mode.
 */

void print_los(object *op) {
  int x,y;
  char buf[50], buf2[10];

  strcpy (buf, "   ");
  for(x=0;x<11;x++){
    sprintf(buf2,"%2d",x);
    strcat(buf,buf2);
  }
  (*draw_info_func)(op, buf);
  for(y=0;y<11;y++) {
    sprintf(buf, "%2d:", y);
    for(x=0;x<11;x++){
      sprintf(buf2," %1d",op->contr->blocked_los[x][y]);
      strcat(buf,buf2);
    }
    (*draw_info_func)(op, buf);
  }
}

/*
 * init_blocksview() fills an array (blocksview[]) with information
 * about which characters/pixmaps are blocking views.
 * This doesn't handle all cases (dropping a coin on top of a mountain),
 * but it's much faster than checking all the objects for BLOCKS_VIEW().
 */

void init_blocksview() {
    return;
}
