/*
 * static char *rcsid_structs_h =
 *   "$Id: structs.h,v 1.8 1993/04/22 06:04:40 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

typedef enum SpellTypeFrom {
  spellNormal, spellWand, spellScroll, spellPotion
} SpellTypeFrom;

typedef struct sockets {
  struct sockets *next;
  int fd;
  int listen_lev;
  int protocol;		/* Set by protocol command			*/
  char name[9];		/* Username on remote side, terminated by '\0'	*/
  char host[17];	/* 129.250.82.2 format, terminated by '\0'	*/
  LogLevel debug;	/* If 0, no debug will be written (not even errors) */
  unsigned wiz:1;	/* If true, privilegied command can be done	*/
  unsigned use_pix:1;	/* If true, use pixmaps when adding player      */
  unsigned split:1;	/* If true, use split windows when adding player*/
  unsigned quit:1;	/* If true, the socket will be closed, and exit */
} sockets;

typedef struct liv { /* Mostly used by "alive" objects */
  signed char Str,Dex,Con,Wis,Cha,Int;
  signed char wc,ac;    /* Weapon Class and Armour Class */
  signed short hp;      /* Hit Points. */
  signed short maxhp;
  signed short sp;      /* Spell points.  Used to cast spells. */
  signed short maxsp;	/* Max spell points. */
  signed long exp;      /* Experience.  Killers gain 1/10. */
  signed short food;    /* How much food in stomach.  0 = starved. */
  signed char dam;	/* How much damage this object does when hitting */
  signed char luck;	/* Affects thaco and ac from time to time */
} living;

typedef struct face_struct {
    unsigned short number;
    unsigned char fg, bg;
} Face;

typedef struct map_look_struct {
    Face face;
    unsigned short flags;
} MapLook;

typedef struct obj {
/* These variables are not changed by copy_object(): */
  struct pl *contr;    /* Pointer to the player which control this object */
  struct obj *next;    /* Pointer to the next object in the free/used list */
  struct obj *prev;    /* Pointer to the previous object in the free/used list*/
  struct obj *below;   /* Pointer to the object stacked below this one */
  struct obj *above;   /* Pointer to the object stacked above this one */
	         /* Note: stacked in the *same* environment*/
  struct obj *inv;     /* Pointer to the first object in the inventory */
  struct obj *container; /* Current container being used */
  struct obj *env;     /* Pointer to the object which is the environment */
  struct obj *more;    /* Pointer to the rest of a large body of objects */
  struct obj *head;    /* Points to the main object of a large body */
  struct mapdef *map;  /* Pointer to the map in which this object is present */
  unsigned short count;         /* Which nr. of object created this is. */
  unsigned short refcount;	/* How many objects points to this object */

/* These get an extra add_refcount(), after having been copied by memcpy() */
  char *name;			/* The name of the object, obviously... */
  char *race;			/* human, goblin, dragon, etc */
  char *slaying;		/* Which race to do double damage to */
  char *msg;			/* If this is a book/sign/magic mouth/etc */
				/* If this is an exit, this is the filename */
/* These variables are copied by memcpy() in copy_object(): */
  signed short x,y;             /* Position in the map for this object */
  signed short ox,oy;           /* For debugging: Where it was last inserted */
  float speed;                  /* The overall speed of this object */
  float speed_left;             /* How much speed is left to spend this round */
  unsigned long nrof;
  Face face;			/* Face with colors */
  signed char direction;        /* Means the object is moving that way. */
  unsigned char type;           /* PLAYER, BULLET, etc */
  unsigned int immune;          /* Attacks which the object is immune against */
  unsigned int protected;	/* Attacks which does half damage */
  unsigned int attacktype;      /* Same bitmask as immune/protected */
  unsigned int vulnerable;	/* Attacks which does double damage */
  unsigned char material;       /* What materials this object consist of */
  signed char magic;            /* Any magical bonuses to this item */
  signed char thrownthaco;      /* How precise the throw is */
  unsigned char state;          /* How the object was last drawn (animation) */
  signed long value;            /* How much money it is worth (or contains) */
  signed short level;
  signed short last_heal;       /* Last healed. Depends on constitution */
  signed short last_sp;         /* As last_heal, but for spell points */
  signed short last_eat;	/* How long since we last ate */
  signed short invisible;	/* How much longer the object will be invis */
  signed char armour;		/* How many % is subtracted from phys. damage */
  unsigned char pick_up;        /* See crossfire.doc */
  struct obj *owner;   /* Pointer to the object which controls this one */
  struct obj *enemy;   /* Monster/player to follow even if not closest */
  struct archt *arch;           /* Pointer to archetype */
  struct archt *other_arch;	/* Pointer used for various things */
  signed long weight;           /* Attributes of the object */
  signed long carrying;         /* How much weight this object contains */
  unsigned long flags, flags2, flags3;  /* Various flags */
  unsigned short ownercount;	/* What count the owner had (in case owner */
				/* has been freed) */
#if 0
  unsigned short thrown;        /* How much further the object will fly */
#endif
/* Some debug variables: */
  unsigned short run_away;	/* Monster runs away if it's hp goes below \
				   this percentage. */
#ifdef NPC_PROG
  unsigned short npc_status;	/* What the NPC is doing right now */
  unsigned short npc_program;	/* Helps find out what the NPC will do next */
#endif

/* changes made by kholland@sunlab.cit.cornell.edu */
/* allows different movement patterns for attackers */
  signed long move_status;      /* What stage in attack mode */
  unsigned short move_type;     /* What kind of attack movement */

  signed long bonus;            /* Holds various information */
  signed long weight_limit;     /* Weight-limit of object */
  unsigned char can_apply;      /* See crossfire.doc */
  unsigned char will_apply;     /* See crossfire.doc */
  unsigned char anim_speed, last_anim; /* ticks between animation-frames */
  living stats;
} object;

typedef struct oblnk { /* Used to link together several objects */
  object *ob;
  struct oblnk *next;
  int id;
} objectlink;

typedef struct oblinkpt { /* Used to link together several object links */
  struct oblnk *link;
  long value;		/* Used as connected value in buttons/gates */
  struct oblinkpt *next;
} oblinkpt;

/*
 * An obwin structure contains a window with scrollbar, where the user
 * can click on items and move the scrollbar.
 */

typedef struct obwinstruct {
  unsigned inventory:1;	/* True, if it's an inventory */
  int x,y;		/* If it's not an inventory, this is the coordinates */
  struct mapdef *map;	/* If it's not an inventory, this is the map */
  object *ob;		/* If it is an inventory, this is the environment */
  char format[16];	/* sprintf-format for text (object-names/weight) */
  Window win;
  GC gc_text,gc_icon;
  XSizeHints hint;
  signed short chars;		/* How wide the text-field is */
  signed short scroll;		/* How many items scrolled down */
  signed short last_scroll;	/* Where it was when last drawn */
  signed short nrofdrawn;	/* How many items drawn.  Delete extras */
  unsigned short barlength;	/* Height of scrollbar in pixels */
  signed short size;		/* How many items there is room to display */
  Fontindex *faces;		/* [size] */
  char **names;			/* [size][chars+1] */
  unsigned short scrollsize;	/* How large the last drawn scrollbar was */
  unsigned short scrollstart;	/* Where the scrollbar starts */
} obwin;

/*
 * I'll clean up the player structure before v1.0 release...
 * Yeah, I know, it's really messy now...
*/

#ifdef SAVE_WINDOW_POSITIONS   /* structure for storing window sizes */
typedef struct {
  int x,y;                     /* window x,y to parent */
  int wx,wy;                   /* window x,y to root */
  unsigned int w,h;
} save_win_pos;
#endif /* SAVE_WINDOW_POSITIONS */

typedef struct pl {
  struct pl *next;	      /* Pointer to next player, NULL if this is last */
  char maplevel[MAX_BUF];     /* On which level is the player? */
  struct mapdef *loading;     /* When entering a map in progress of loading */
  int new_x,new_y;            /* After entering a map being loaded */
  int removed;                /* Flag telling if ob is to be inserted */
  int key_state;              /* 1=define push key, 2=define directions */
  signed char known_spells[NROFREALSPELLS]; /* Spells known by the player */
  unsigned char nrofknownspells; /* Index in the above array */
  signed char shoottype;      /* 1=BOW, 2=MAGIC, 3=WEAPON, 4=WAND */
  signed char last_shoot;     /* What was last updated with draw_stats() */
  signed char chosen_spell;   /* Readied spell */
  signed char last_spell;     /* What spell draw_stats() last displayed */
  unsigned short count;       /* Any numbers typed before a command */
  unsigned short count_left;  /* How many instances of prev_cmd are left */
			      /* to execute */
  unsigned char prev_cmd;     /* Previous command executed */
  unsigned char prev_fire_on;
  unsigned char prev_keycode; /* Previous command executed */
  unsigned char key_down;     /* Last move-key still held down */
  unsigned char mode;         /* Mode of player: */
  signed char digestion;      /* Any bonuses/penalties to digestion */
  signed char gen_hp;         /* Bonuses to regeneration speed of hp */
  signed char gen_sp;         /* Bonuses to regeneration speed of sp */
/* 0=normal, 1=pick up while walking, 2=stop after pick, 3=stop before pick */
  unsigned char berzerk;      /* Affects usage of CTRL-direction */
  unsigned split_window:1;    /* info-window will be separate */
  unsigned braced:1;          /* Will not move if braced, only attack */
  unsigned tmp_invis:1;       /* Will invis go away when we attack ? */
  unsigned do_los:1;	      /* If true, update_los() in draw(), and clear */
#ifdef EXPLORE_MODE
  unsigned explore:1;         /* if True, player is in explore mode */
#endif
  unsigned infofull:1;		/* True if info structure has been fileed up */
  unsigned char state,infoline,infopos;
  unsigned char writing;   /* When true, the player is writing text */
		     /* to be displayed */
  unsigned char listening; /* Which priority will be used in info_all */
/*  Fontindex face;*/          /* Which character the player chose */
  unsigned char fire_on;
  unsigned char run_on;
  unsigned char configure;
  unsigned char idle;      /* How long this player has been idle */
  unsigned char has_hit;   /* If set, weapon_sp instead of speed will count */
  float weapon_sp;         /* Penalties to speed when fighting w speed >ws/10*/
  float last_weapon_sp;    /* Last turn */
  signed char last_armour; /* Last turn */

#ifdef SHOP_LISTINGS
  object *menu;		/* list of shop objects for inventory */
#endif
#ifdef OBWIN
  obwin *inv,*look;        /* Inventory and look windows */

#else
  signed short scroll_inv;	   /* How many items we have scrolled down */
  signed short scroll_look; 	   /* The same, but for the look-window */
  signed short last_scroll_inv;   /* where it was when last drawn */
  signed short last_scroll_look;  /* ditto for look-window */
  signed short nrofdrawn_inv;	   /* How many items drawn. Delete extras */
  signed short nrofdrawn_look;    /* ditto for the look-window */
  signed short inv_chars;         /* How wide the text-field is */
  signed short look_chars;        /* How wide the text-field is */
  char format_inv[16];     /* sprintf-format for text in inventory window */
  char format_look[16];    /* sprintf-format for text in look window */
  unsigned short barlength_inv;    /* height of scrollbar in pixels */
  unsigned short barlength_look;   /* ditto, for the look-window */
  signed short inv_size;          /* How many items are displayed */
  signed short look_size;         /* Ditto, for the look-window */
  unsigned short scrollsize_inv;   /* How large the last drawn scrollbar was */
  unsigned short scrollsize_look;  /* How large the last drawn scrollbar was */
  unsigned short scrollstart_inv;  /* Where the scrollbar starts */
  unsigned short scrollstart_look; /* ditto */
#endif
  unsigned short scrollsize_hp;    /* How large the last scrollbar was */
  unsigned short scrollsize_sp;    /* How large the last scrollbar was */
  unsigned short scrollsize_food;  /* How large the last scrollbar was */
  short shootstrength;     /* Strength of spell */
  object *golem;           /* Which golem is controlled */
  living orig_stats;       /* Can be less in case of poisoning */
  living last_stats;       /* Last stats drawn with draw_stats() */
  float last_speed;
  signed long last_value;  /* Same usage as last_stats */
  long last_weight;
/* These are used for avoiding to draw the same thing twice: */
  Fontindex look_face[MAX_LOOK_SIZE];
  Fontindex inv_face[MAX_INV_SIZE];
  char look_name[MAX_LOOK_SIZE][MAX_BUF]; /* Lots of space wasted, must fix */
  char inv_name[MAX_INV_SIZE][MAX_BUF];   /* this in the future... */
  char font_str[255];
  long freeze_look,freeze_inv; /* To avoid drawing sometimes */
  int viewmap; /* Locks any map-drawings */
  int mapres;  /* resolution of drawn map */
  int mapxmin, mapymin; /* min x and y drawn in map view */
/* Pixels to be erazed */
  int mapdelx[32],mapdely[32];
#ifdef USE_SWAP_STATS
  int Swap_First;
#endif
  
  Display *gdisp;
/* Should be kept here so that all windows can use it... */
  Pixmap pixmap;	/* Used when windows are iconified */
  Pixmap *pixmaps;	/* Contains the font in pixmap-format (if needed) */
  int use_pixmaps;	/* If set, use pixmaps instead of fonts */
  XEvent gevent;
  KeySym gkey;
  Window win_root,win_game,win_stats,win_info,win_inv,win_look,win_message;
  GC gc_root,gc_game,gc_stats,gc_info,gc_inv_text,gc_inv_icon,
  gc_look_text,gc_look_icon,gc_message;
  XSizeHints gamehint,stathint,roothint,infohint,invhint,lookhint,messagehint;
  long gscreen;
  unsigned long gforeground,gbackground;
  Font font, game_font;
  object *ob;            /* The object representing the player */
  object *last_used;     /* Pointer to object last picked or applied */
  long last_used_id;     /* Safety measures to be sure it's the same */
  Face drawn[WINRIGHT-WINLEFT+1][WINLOWER-WINUPPER+1]; /* Last displayed */
  char blocked_los[WINRIGHT-WINLEFT+1][WINLOWER-WINUPPER+1];
  char *name;   /* What display the player has */
  char title[MAX_NAME];
  
/* Eneq(@csd.uu.se): Since there is no direct link between characters title and
   his level I figure that it doesn't matter what title he has so I have made
   it possible for him/her to define this in the resources. */
  
  char own_title[MAX_NAME];
  
  signed char levhp[11]; /* What the player gained on that level */
  signed char levsp[11];
  signed char last_level;
  KeyCode keys[NROFKEYS];
  KeyCode pushkeys[NROFPUSHKEYS]; /* Programable push-keys */
  char pushstring[NROFPUSHKEYS][MAX_BUF]; /* what the push-keys contain */
  char buf[MAX_BUF];      /* Temporary storage of push-key */
  char no_echo;           /* If true, the player is typing a password. */
  char name_changed;      /* If true, the player has set a name. */
  char killer[BIG_NAME];  /* Who killed this player. */
  char last_cmd;          /* Used by mouse. 0=none,1=inv,2=look */
  Visual *vis;
  Colormap colormap;
  int peaceful;
  long depth;
  XColor exactcolor,discolor[16];
  long iscolor;

  char scroll;		/* Will the text-window scroll or wrap? */
  char write_buf[MAX_BUF];
  char **info;
  unsigned char infolines,infochars; /* How big the info-array is */
  char password[16]; /* 2 (seed) + 11 (crypted) + 1 (EOS) + 2 (safety) = 16 */
#if SAVE_INTERVAL
  time_t last_save_time;
#endif /* SAVE_INTERVAL */
#ifdef SIMPLE_PARTY_SYSTEM
  short party_number;
#endif /* SIMPLE_PARTY_SYSTEM */
#ifdef SAVE_WINDOW_POSITIONS
  short valid_save_positions;
  save_win_pos win_pos[6];
#endif
#ifdef SEARCH_ITEMS
  char search_str[MAX_BUF];
#endif /* SEARCH_ITEMS */
} player;
  
/*
 * The score structure is used when treating new high-scores
 */

typedef struct scr {
  char name[BIG_NAME];      /* name + title */
  char killer[BIG_NAME];    /* name (+ title) or "quit" */
  long exp;                 /* Experience */
  char maplevel[BIG_NAME];  /* Killed on what level */
  int maxhp,maxsp;          /* Max hp and sp when killed */
  int position;             /* Position in the highscore list */
} score;

/*
 * When parsing a message-struct, the msglang struct is used
 * to contain the values.
 * This struct will be expanded as new features are added.
 * When things are stable, it will be parsed only once.
 */

typedef struct _msglang {
  char **messages;	/* An array of messages */
  char ***keywords;	/* For each message, an array of strings to match */
} msglang;

/*
 * The mapstruct is allocated each time a new map is opened.
 * It contains pointers (very indirectly) to all objects on the map.
 */

typedef struct mapdef {
  struct mapdef *next;	/* Next map, linked list */
  int read_only;	/* If true, the map-file is read-only */
  object *where;	/* What object were used to enter this map */
  char path[MAX_BUF];	/* Filename of the map */
  char *tmpname;	/* Name of temporary file */
  long reset_time;	/* When < sec since 1970, load original instead */
  long timeout;		/* When it reaches 0, the map will be swapped out */
  long need_refresh;	/* Something went wrong, need sanity check */
  /*long level;*/		/* Just a unique number */
  long players;		/* How many plares are on this level right now */
  long in_memory;	/* If not true, the map has been freed and must
		         * be loaded before used.  The map,omap and map_ob
		         * arrays will be allocated when the map is loaded */
  long first_visit;	/* True until the map has been loaded */
#if 0
  long mapx,mapy;	/* How large is the map */
  long startx,starty;	/* Where the entry to the map is */
#else
#define mapx map_object->x
#define mapy map_object->y
#endif
  MapLook *map;		/* What the map looks like now */
  object **map_ob;	/* What object lies on the floor */
  long difficulty;	/* What level the player should be to play here */
  objectlink *pending;  /* Objects waiting for the map to be loaded */
  object *map_object;   /* Map object in new map format */
  oblinkpt *buttons;	/* Linked list of linked lists of buttons */
} mapstruct;

/*
 * The archetype structure is a set of rules on how to generate and manipulate
 * objects which point to archetypes.
 */

typedef struct archt {
  char *name;           /* More definite name, like "generate_kobold" */
  struct archt *next;	/* Next archetype in a linked list */
  struct archt *head;   /* The main part of a linked object */
    struct archt *more; /* Next part of a linked object */
  struct treasurestruct *randomitems; /* Items to be generated */
  object clone;		/* An object from which to do copy_object() */
  unsigned long editable;         /* editable flags (mainly for editor) */
  long used_by;		/* A count of how many objects use this archetype */
  unsigned char animations;	    /* How many different faces to animate */
  Fontindex *faces;     /* The different animations */
  char *arch_pointer;   /* Did this archetype deviate from another? */
} archetype;

/*
 * treasure is one element in a linked list, which together consist of a
 * complete treasure-list.  Any arch can point to a treasure-list
 * to get generated standard treasure when an archetype of that type
 * is generated (from a generator)
*/

typedef struct treasurestruct {
  struct archt *item;		    /* Which item this link can be */
  struct treasurestruct *next;	    /* Next treasure-item in a linked list */
  struct treasurestruct *next_yes;  /* If this item was generated, use */
				    /* this link instead of ->next */
  struct treasurestruct *next_no;   /* If this item was not generated, */
				    /* then continue here */
  unsigned char chance;		    /* Percent chance for this item */
  unsigned char magic;		    /* Max magic bonus to item */
  unsigned short nrof;		    /* random 1 to nrof items are generated */
} treasure;

typedef struct treasureliststruct {
  char *name;				/* Usually monster-name/combination */
  struct treasureliststruct *next;	/* Next treasure-item in linked list */
  struct treasurestruct *items;		/* Items in this list, linked */
} treasurelist;

typedef struct treasure_struct {
  char name[BIG_NAME];
  int magic;
  int nrof;
} old_treasure;

typedef struct spell_struct {
  char name[BIG_NAME];
  short level;           /* Level required to cast this spell */
  short sp;              /* Spellpoint-cost to cast it */
  short charges;         /* If it can be used in wands, max # of charges */
  float time;            /* How many ticks it takes to cast the spell */
  short scrolls;         /* If it can be used from scrolls, max # of scrolls */
  short scroll_chance;   /* 1-10 probability of finding this as scroll */
  short books;           /* 1-10 probability of finding this as spellbook */
  unsigned range:1;      /* True if this is a range attack spell */
  unsigned defensive:1;  /* True if it is a defensive spell */
  unsigned cleric:1;  /* True if it is a cleric-spell (wis-chance failure)*/
} spell;

typedef struct att_msg_str {
  char *msg1;
  char *msg2;
} att_msg;

/*
 * Used in shstr.c, libproto.h necessitates this dummy. For the real
 * contents of a shared_string, look in shstr.h
 */
typedef int shared_string;
