/*
 * static char *rcsid_apply_c =
 *   "$Id: apply.c,v 1.5 1993/04/22 06:04:46 frankj Exp $";
 */
/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <living.h>
#include <spells.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif

#if defined(vax) || defined(ibm032)
size_t strftime(char *, size_t, const char *, const struct tm *);
time_t mktime(struct tm *);
#endif

void draw_find(object *op, object *find) {
  char buf[MAX_BUF];
  sprintf(buf,"You find %s in the chest.",query_name(find));
  draw_info(op,buf);
}

int check_item(object *op,char *item)
{
  op=op->below;
  
  while(op!=NULL) {
    if (strcmp(op->arch->name,item)==0) {
      return op->nrof;
    }
    op=op->below;
  }
  return 0;
}

void eat_item(object *op,char *item)
{
  object *prev;

  prev = op;
  op=op->below;
  
  while(op!=NULL) {
    if (strcmp(op->arch->name,item)==0) {
      op->nrof=1;
      decrease_ob(op);
      op=prev;
    }
    prev = op;
    op=op->below;
  }
}

int check_sacrifice(object *op,object *improver)
{
  int count;

  if (check_item(op,"food")<5) {
    draw_info(op,"The gods want more food.");
    return 0;
  }
  if (check_item(op,"booze")<10) {
    draw_info(op,"The gods want more booze.");
    return 0;
  }
  count = 0;
  if (improver->slaying!=NULL) {
    count = check_item(op,improver->slaying);
    if (count<1) {
      char buf[200];
      sprintf(buf,"The gods want more %ss",improver->slaying);
      draw_info(op,buf);
      return 0;
    }
    eat_item(op,improver->slaying);
  }
  else
    count=1;

  eat_item(op,"food");
  eat_item(op,"booze");
  return count;
}

int improve_weapon_stat(object *op,object *improver,object *weapon,
			signed char *stat,int sacrifice_count,char *statname)
{
  char buf[200];

  if (sacrifice_count<2)
    return 0;
  sacrifice_count = isqrt(sacrifice_count/2);
  draw_info(op,"Your sacrifice was accepted.");
  *stat += sacrifice_count;
  weapon->last_eat++;
  sprintf(buf,"Weapon's bonus to %s improved by %d",statname,sacrifice_count);
  draw_info(op,buf);
  decrease_ob(improver);
  return 1;
}

/* Types of improvements, hidden in the sp field. */
#define IMPROVE_PREPARE 1
#define IMPROVE_DAMAGE 2
#define IMPROVE_WEIGHT 3
#define IMPROVE_ENCHANT 4
#define IMPROVE_STR 5
#define IMPROVE_DEX 6
#define IMPROVE_CON 7
#define IMPROVE_WIS 8
#define IMPROVE_CHA 9
#define IMPROVE_INT 10

/* build_weapon returns 0 if it was not able to work. */
/* #### We are hiding extra information about the weapon in the level and
   last_eat numbers for an object.  Hopefully this won't break anything ?? 
   level == max improve last_eat == current improve*/

int improve_weapon(object *op,object *improver,object *weapon)
{
  int sacrifice_count;
  char buf[300],*tmp;

  if(improver->stats.sp==IMPROVE_PREPARE) {
    if (weapon->level!=0) {
      draw_info(op,"Weapon already prepared.");
      return 0;
    }
    /* Could check for other things.  I'm assuming all things which provide
       other benefits are also magic. */
    if (weapon->magic!=0) {
      draw_info(op,"Cannot prepare magic weapons.");
      return 0;
    }
    sacrifice_count=check_sacrifice(op,improver);
    if (sacrifice_count<=0)
      return 0;
    sacrifice_count = isqrt(sacrifice_count);
    weapon->level=sacrifice_count;
    draw_info(op,"Your sacrifice was accepted.");
    sprintf(buf,"Your *%s may be improved %d times.",
	    weapon->name,sacrifice_count);
    draw_info(op,buf);
    tmp = (char *) malloc(strlen(weapon->name)+2);
    sprintf(tmp,"*%s",weapon->name);
    weapon->name=tmp;
    decrease_ob(improver);
    weapon->last_eat=0;
    return 1;
  }
  if (!(weapon->level>0)) {
    draw_info(op,"This weapon has not been prepared.");
    return 0;
  }
  if (weapon->level==weapon->last_eat) {
    draw_info(op,"This weapon cannot be improved any more.");
    return 0;
  }
  sacrifice_count = check_sacrifice(op,improver);
  if (sacrifice_count<=0)
    return 0;
  switch (improver->stats.sp) {
   case IMPROVE_DAMAGE:
    sacrifice_count = isqrt(sacrifice_count);
    weapon->stats.dam += sacrifice_count;
    weapon->weight += sacrifice_count*2000;
    draw_info(op,"Your sacrifice was accepted.");
    sprintf(buf,"Damage is increased by %d, weight by %d",
	    sacrifice_count,sacrifice_count*2000);
    draw_info(op,buf);
    weapon->last_eat++;
    decrease_ob(improver);
    return 1;
   case IMPROVE_WEIGHT:
    sacrifice_count = isqrt(sacrifice_count)*750;
    if (weapon->weight<sacrifice_count)
      weapon->weight=1;
    else
      weapon->weight-=sacrifice_count;
    draw_info(op,"Your sacrifice was accepted.");
    sprintf(buf,"Weapon weight reduced by %d to %d",
	    sacrifice_count,weapon->weight);
    draw_info(op,buf);
    weapon->last_eat++;
    decrease_ob(improver);
    return 1;
   case IMPROVE_ENCHANT:
    draw_info(op,"Your sacrifice was accepted.");
    weapon->magic++;
    weapon->last_eat++;
    weapon->weight=(weapon->weight*90)/100;
    sprintf(buf,"Weapon magic increased to %d, weight lowered to %d",
	    weapon->magic,weapon->weight);
    draw_info(op,buf);
    decrease_ob(improver);
    return 1;
   case IMPROVE_STR:
    return improve_weapon_stat(op,improver,weapon,
                               (signed char *) &(weapon->stats.Str),
			       sacrifice_count,(char *) "strength");
   case IMPROVE_DEX:
    return improve_weapon_stat(op,improver,weapon,
                               (signed char *) &(weapon->stats.Dex),
			       sacrifice_count,(char *) "dexterity");
   case IMPROVE_CON:
    return improve_weapon_stat(op,improver,weapon,
                               (signed char *) &(weapon->stats.Con),
			       sacrifice_count,(char *) "constitution");
   case IMPROVE_WIS:
    return improve_weapon_stat(op,improver,weapon,
                               (signed char *) &(weapon->stats.Wis),
			       sacrifice_count,(char *) "wisdom");
   case IMPROVE_CHA:
    return improve_weapon_stat(op,improver,weapon,
                               (signed char *) &(weapon->stats.Cha),
			       sacrifice_count,(char *) "charisma");
   case IMPROVE_INT:
    return improve_weapon_stat(op,improver,weapon,
                               (signed char *) &(weapon->stats.Int),
			       sacrifice_count,(char *) "intelligence");
   default:
    draw_info(op,"Unknown improvement type.");
    return 0;
  }
}

void money_change(object *op,char *towhat)
{
  object *buying;
  char buf[MAX_BUF],buf2[MAX_BUF];

  buying = get_archetype(towhat);

  if (buying==NULL) {
    LOG(llevError,"Unable to find archetype %s\n",towhat);
    return;
  }
  buying->nrof=100;
  strncpy(buf,query_cost_string(buying,op,F_BUY),MAX_BUF);
  if (pay_for_item(buying,op)) {
    sprintf(buf2,"You paid %s for %s.",buf,query_name(buying));
    draw_info(op,buf2);
    insert_ob_in_ob(buying,op);
  } else {
    sprintf(buf2,"You can't afford %s.",query_name(buying));
    draw_info(op,buf2);
    free_object(buying);
  }
}

/*
 * convert_item() returns 1 if anything was converted, otherwise 0
 */
#define CONV_FROM(xyz)	xyz->slaying
#define CONV_TO(xyz)	xyz->other_arch
#define CONV_NR(xyz)	(unsigned char) xyz->stats.sp
#define CONV_NEED(xyz)	(unsigned long) xyz->stats.food

int convert_item(object *item, object *converter) {
  int nr=0;
  object *tmp;
  if(item->type==PLAYER||CONV_FROM(converter)!=item->arch->name||
     (CONV_NEED(converter)&&CONV_NEED(converter)>item->nrof))
    return 0;
  if(CONV_NEED(converter)) {
    nr=item->nrof/CONV_NEED(converter);
    decrease_ob_nr(item,nr*CONV_NEED(converter));
  } else {
    remove_ob(item);
    free_object(item);
  }
  item=arch_to_object(converter->other_arch);
  if(CONV_NR(converter))
    item->nrof=CONV_NR(converter);
  if(nr)
    item->nrof*=nr;
  for(tmp=get_map_ob(converter->map,converter->x,converter->y);
      tmp!=NULL;
      tmp=tmp->above)
    if(tmp->type==SHOP_FLOOR)
      break;
  if(tmp!=NULL)
    SET_UNPAID(item);
  item->x=converter->x;
  item->y=converter->y;
  insert_ob_in_map(item,converter->map);
  return 1;
}

/* apply returns 0 if it wasn't possible to apply that object */

int apply(object *op, object *tmp) {
  char buf[MAX_BUF];
  object *env;
  int inven;

  if(tmp==NULL) {
    if(op!=NULL&&op->type==PLAYER)
      draw_info(op,"There is nothing to apply.");
    return 0;
  }
  inven=(tmp->env!=NULL);
  if(op->type==PLAYER&&!inven&&IS_FLYING(op)&&!IS_FLYING(tmp)&&!FLY_ON(tmp)&&
     !IS_WIZ(op)) {
/*  if(op->type==PLAYER||IS_MONSTER(op)) */
    draw_info(op,"But you are floating high above the ground!");
    return 0;
  }
  while(tmp!=NULL&&(!(WALK_ON(tmp)||FLY_ON(tmp))&&tmp->invisible))
    tmp=inven?tmp->below:tmp->above;
  if(tmp==NULL)
    return 0;
  if(WAS_WIZ(tmp)&&!WAS_WIZ(op)&&op->type==PLAYER) {
    draw_info(op,"The object disappears in a puff of smoke!");
    draw_info(op,"It must have been an illusion.");
    remove_ob(tmp);
    free_object(tmp);
    return 1;
  }
  if(op->type==PLAYER) {
    op->contr->last_used=tmp;
    op->contr->last_used_id=tmp->count;
  }
  env=tmp->env;
  switch(tmp->type) {
  case SPINNER:
    if(op->direction) {
      op->direction=absdir(op->direction-tmp->stats.sp);
      update_turn_face(op);
    }
    return 1;
  case DIRECTOR:
    if(op->direction) {
      op->direction=tmp->stats.sp;
      update_turn_face(op);
    }
    return 1;
  case BUTTON:
  case PEDESTAL:
    update_button(tmp);
    return 1;
  case ALTAR:
    if (check_altar (tmp)) {
      tmp->value = 1;  /* works only once */
      push_button(tmp);
    }
    return 1;
  case ARROW:
    if(IS_ALIVE(op)&&tmp->speed) {
      if(attack_ob(op,tmp)) {
        remove_ob(tmp);
        stop_arrow(tmp,op);
      }
      return 1;
    }
    return 0;
  case CONE: /* A cone in the form of a wall */
    if(IS_ALIVE(op)&&tmp->speed)
      hit_player(op,tmp->stats.dam*20,tmp,tmp->attacktype);
    break;
  case FBULLET:
  case BULLET:
    check_fired_arch(tmp);
    return 1;
  case TRAPDOOR:
    {
      int max;
      object *ab;
      if(!tmp->value) {
        int tot;
        for(ab=tmp->above,tot=0;ab!=NULL;ab=ab->above)
          if(!IS_FLYING(ab))
            tot+=ab->weight+ab->carrying;
        if(!(tmp->value=(tot>tmp->weight)?1:0))
          return 1;
        tmp->face.number=tmp->arch->faces[tmp->value];
        update_object(tmp);
      }
      for(ab=tmp->above,max=100;--max&&ab&&!IS_FLYING(ab);ab=ab->above) {
        transfer_ob(ab,(int)EXIT_X(tmp),(int)EXIT_Y(tmp));
        draw_info(ab,"You fall into a trapdoor!");
      }
    }
    return 1;
  case CONVERTER:
    if(convert_item(op,tmp))
      return 2;
    return 0;
  case HANDLE:
    draw_info(op,"You turn the handle.");
    tmp->value=tmp->value?0:1;
    tmp->face.number=tmp->arch->faces[tmp->value];
    update_object(tmp);
    push_button(tmp);
    return 1;
  case TRIGGER:
  case TRIGGER_BUTTON:
  case TRIGGER_PEDESTAL:
  case TRIGGER_ALTAR:
    check_trigger(tmp);
    return 1;
  case DEEP_SWAMP:
    deep_swamp(tmp, 1);
    return 1;
  case HOLE:
    if(tmp->stats.wc>0) /* Is the hole open? */
      return 1; /* Nope */
    {
    int i=find_free_spot(op->arch,op->map,EXIT_X(tmp),EXIT_Y(tmp),0,SIZEOFFREE);
      remove_ob(op);
      op->x=EXIT_X(tmp)+freearr_x[i],op->y=EXIT_Y(tmp)+freearr_y[i];
      insert_ob_in_map(op,op->map);
    }
    draw_info(op,"You fall through the hole!\n");
    return 1;
  case EXIT:
    if(op->type!=PLAYER)
      return 0;
    if(tmp->head!=NULL)
      tmp=tmp->head;
    if(!EXIT_PATH(tmp)) {
      sprintf(buf,"The %s is closed.",query_name(tmp));
      draw_info(op,buf);
      return 1;
    }
    if (tmp->msg)
        print_message(op, tmp->msg, 2);
    enter_exit(op,tmp);
    break;
  case SHOP_MAT:
    {
      SET_NO_APPLY(op);
      if(op->type!=PLAYER) {
        if(IS_UNPAID(op)) { /* Just move the item to an adjacent place */
          int i=find_free_spot(op->arch,op->map,op->x,op->y,1,9);
          if(!i) return 1;
          transfer_ob(op,op->x+freearr_x[i],op->y+freearr_y[i]);
          UNSET_NO_APPLY(op);
          return 1;
        }
        if(op->more||op->head) return 1; /* Some nasty bug has to be fixed here... */
        teleport(tmp,SHOP_MAT);
        UNSET_NO_APPLY(op);
        return 1;
      }
      if(get_payment(op)) {
        teleport(tmp,SHOP_MAT);
        if((tmp=get_map_ob(op->map,op->x,op->y))==NULL||tmp->type!=SHOP_FLOOR)
          draw_info(op,"Thank you for visiting our shop.");
      }
      else {
        int i=find_free_spot(op->arch,op->map,op->x,op->y,1,9);
        if(!i)
          LOG(llevError,"Internal shop-mat problem.\n");
        else {
          remove_ob(op);
          op->x+=freearr_x[i],op->y+=freearr_y[i];
          insert_ob_in_map(op,op->map);
        }
      }
      UNSET_NO_APPLY(op);
      return 1;
    }
  case SIGN:
    if(tmp->msg==NULL)
      draw_info(op,"Nothing is written on it.");
    else
      print_message(op,tmp->msg,2);
    return 1;
  case BOOK:
    if(tmp->msg==NULL) {
      char buf[MAX_BUF];
      sprintf(buf, "You open the %s and find it empty.", tmp->name);
      draw_info(op, buf);
    } else {
      char buf[MAX_BUF];
      sprintf(buf, "You open the %s and start reading.", tmp->name);
      draw_info(op, buf);
      print_message(op,tmp->msg,2);
    }
    return 1;
  case SPELLBOOK:
    if(op->type!=PLAYER)
      return 0;
    if(IS_UNPAID(tmp)) {
      draw_info(op,"You should pay for it first.");
      break;
    }
    sprintf(buf,"The spellbook contains the %d level spell %s.",
            spells[tmp->stats.sp].level,spells[tmp->stats.sp].name);
    draw_info(op,buf);
    if(check_spell_known(op,tmp->stats.sp)) {
      draw_info(op,"You already know that spell.\n");
      return 1;
    }
    if(spells[tmp->stats.sp].level>op->level) {
      draw_info(op,"You are not of a high enough level to learn it.");
      return 1;
    }
    if(RANDOM()%100<learn_spell[op->stats.Wis]) {
      draw_info(op,"You succeed in learning the spell!");
      op->contr->known_spells[op->contr->nrofknownspells++]=tmp->stats.sp;
      if(op->contr->nrofknownspells==1)
        op->contr->chosen_spell=tmp->stats.sp;
      sprintf(buf,"Type 'define cast %s",spells[tmp->stats.sp].name);
      draw_info(op,buf);
      draw_info(op,"to store the spell in a key.");
    } else
      draw_info(op,"You fail to learn the spell.\n");
    remove_ob(tmp);
    free_object(tmp);
    return 1;
  case SCROLL:
    if(IS_UNPAID(tmp)) {
      draw_info(op,"You should pay for it first.");
      break;
    }
    draw_info(op,"The scroll turns to dust.");
    sprintf(buf,"%s reads a scroll of %s.",op->name,spells[tmp->stats.sp].name);
    info_all(buf,6);
    decrease_ob(tmp);
    if(op->type==PLAYER) {
      op->contr->shoottype=4;
      op->contr->chosen_spell=tmp->stats.sp;
    }
    cast_spell(op,0,tmp->stats.sp,0,spellScroll);
    if(op->type==PLAYER) {
      if(op->contr->golem==NULL)
        op->contr->shoottype=0;
      draw_stats(op);
    }
    break;
  case POTION:
    if(op->type!=PLAYER)
      return 0; /* This might change */
    if(IS_UNPAID(tmp)) {
      draw_info(op,"You should pay for it first.");
      break;
    }
    if(tmp->immune||tmp->protected) {
      object *force;
      /* This is copied from change_abil(), should be moved to common func. */
      if((force=present_in_ob(FORCE,tmp))!=NULL)
        remove_force(force);
      force=get_archetype("force");
      force->immune=tmp->immune;
      force->protected=tmp->protected;
      force->speed_left= -1;
      insert_ob_in_ob(force,op);
      SET_APPLIED(force);
      change_abil(op,force);
    } else if (tmp->stats.sp)
      cast_spell(op,0,tmp->stats.sp,0,spellPotion);
    else {
      SET_APPLIED(tmp);
      if(tmp->stats.luck < -4 || !(RANDOM()%(10+tmp->stats.luck*2)))
        UNSET_APPLIED(tmp);
      if(!change_abil(op,tmp))
        draw_info(op,"Nothing happened.");
      else
        fix_player(op);
      UNSET_APPLIED(tmp);
    }
    decrease_ob(tmp);
    break;

/* Eneq(@csd.uu.se): Handle apply on containers. */
  case CONTAINER: 
    if(op->type!=PLAYER)
      return 0; /* This might change */
    op->contr->last_used = NULL;
    op->contr->last_used_id = 0;

    if (tmp->env!=op) {
      draw_info(op,"You must get it first.");
      break;
    }

    /* Do we already have an open container? */

    if (op->container&&op->container!=tmp) {
        draw_info(op,"Closing open container.");
        op->container=tmp;
        draw_all_look(op);
    } else if (op->container&&op->container==tmp) {
        draw_info(op,"Closing container.");
        op->container=NULL;
        draw_all_look(op);
    } else {
        draw_info (op, "Opened container.");
        op->container=tmp;
        draw_all_look(op);
    }
    break;

  case TREASURE:
    if(IS_UNPAID(tmp)) {
      draw_info(op,"You should pay for it first.");
      break;
    }
    decrease_ob(tmp);
    tmp=generate_treasure(T_RANDOM,tmp->level);
    if(tmp==NULL) {
      draw_info(op,"The chest was empty.");
      return 1;
    }
    draw_find(op,tmp);
    tmp->x=op->x,tmp->y=op->y;
    if(env==NULL)
      insert_ob_in_map(tmp,op->map);
    else
      insert_ob_in_ob(tmp,env);
    remove_ob(op);
    insert_ob_in_map(op,op->map);
    break;
  case WAND:
    if(apply_special(op,tmp))
      return 1;
    if(op->type==PLAYER) {
      if(IS_APPLIED(tmp)) {
        op->contr->shoottype=3; /* wands */
        op->contr->chosen_spell=tmp->stats.sp;
        fix_player(op);
      }
    } else {
      if(IS_APPLIED(tmp))
        SET_READY_WAND(op);
      else
        UNSET_READY_WAND(op);
    }
    return 1;
  case BOW:
    if(apply_special(op,tmp))
      return 0;
    if(IS_APPLIED(tmp)) {
      sprintf(errmsg,"You will now fire %ss.",get_archename(tmp->stats.maxsp));
      draw_info(op,errmsg);
      if(op->type==PLAYER) {
        op->contr->shoottype=1;
        fix_player(op);
      }
    }
    return 1;
  case WEAPON:
  case ARMOUR:
  case BOOTS:
  case GLOVES:
  case AMULET:
  case GIRDLE:
  case BRACERS:
  case SHIELD:
  case HELMET:
  case RING:
/* Mol(mol@meryl.csd.uu.se) compressed return & apply_s into one statement */
/* Frank: If done this way, a ! must be prepended */
    return !apply_special(op,tmp);
  case DRINK:
  case FOOD:
    if(IS_UNPAID(tmp)) {
      draw_info(op,"You should pay for it first.");
      return 1;
    }
    if(op->type!=PLAYER)
      op->stats.hp=op->stats.maxhp;
    else if(op->stats.food+tmp->stats.food>999) {
      if(tmp->type==FOOD)
        draw_info(op,"You can't possibly eat all that now.");
      else
        draw_info(op,"You can't possibly drink all that now.");
      return 1;
    }
    if(tmp->type==FOOD)
      draw_info(op,"The food tasted good.");
    else
      draw_info(op,"Ahhh...that booze tasted good.");
    op->stats.food+=tmp->stats.food;
    op->stats.hp+=tmp->stats.food/50;
    if(op->stats.hp>op->stats.maxhp)
      op->stats.hp=op->stats.maxhp;
    draw_stats(op);
    decrease_ob(tmp);
    return 1;
  case POISON:
    if(op->type!=PLAYER)
      return 0;
    if(IS_UNPAID(tmp)) {
      draw_info(op,"You should pay for it first.");
      return 1;
    }
    draw_info(op,"Yech!  That tasted poisonous!");
    strcpy(op->contr->killer,"poisonous booze");
    op->stats.hp+=tmp->stats.hp;
    op->stats.food-=op->stats.food/4;
    draw_stats(op);
    decrease_ob(tmp);
    return 1;
  case SAVEBED:
    if(op->type!=PLAYER)
      return 0;
#ifdef SAVE_PLAYER
    if(!op->contr->name_changed||!op->stats.exp) {
      draw_info(op,"You don't deserve to save your character yet.");
      return 1;
    }
    if(WAS_WIZ(op)) {
      draw_info(op,"Since you have cheated you can't save.");
      return 1;
    }
    remove_ob(op);
    op->contr->state=ST_PLAY_AGAIN;
    op->direction=0;
    op->contr->count_left=0;
    sprintf(buf,"%s leaves the game.",op->name);
    info_all(buf,5);
    info_flush();
    strcpy(op->contr->killer,"left");
    check_score(op); /* Always check score */
    (void)save_player(op,0);
    remove_lock(op->contr);
    draw_info(op,"Do you want to play again (a/q)?");
#else
    draw_info(op,"This game is compiled without the save-option.");
#endif
    return 1;
   case WEAPON_IMPROVER:
    if(op->type!=PLAYER)
      return 0;
    draw_info(op,"Applied weapon builder.");
    if (op->inv==NULL||op->inv->type!=15) {
      draw_info(op,"First item in inventory is not a weapon\n");
      return 0;
    }
    improve_weapon(op,tmp,op->inv);
    draw_all_inventory(op);
    return 1;
   case MONEY_CHANGER:
    if(op->type!=PLAYER)
      return 0;
    draw_info(op,"Applied money changer.");
    if (tmp->slaying==NULL) {
      LOG(llevError,"Money changer converts to nothing???\n");
      kill(getpid(),1);
    }
    money_change(op,tmp->slaying);
    return 1;
   case CLOCK: {
       time_t t = time(NULL);
       strftime(buf, sizeof(buf), "Time is %I:%M %p", localtime(&t));
       draw_info(op, buf);
	return 1;
   }
   /* Menu signs in shops by Mark Wedel (master@cats.ucsc.edu) */
  case MENU: 
	if (op->type!=PLAYER) return 0;
#ifdef SHOP_LISTINGS
	shop_listing(op);
#else
	draw_info(op,"No specials today.");
#endif
	return 1;

  default:
#if 0
    if(op->type==PLAYER) {
      sprintf(buf,"I don't know how to apply the %s.",query_name(tmp));
      draw_info(op,buf);
    }
#endif
    return 0;
  }
  return 1;
}

void apply_below(object *op) {
  object *tmp;
  char buf[MAX_BUF];

/* Eneq(@csd.uu.se): If we are digging in a container then we are to 
   preoccupied to be able to apply whats below. */

  if (op->container!=NULL) {
      sprintf(buf, "You are too preoccupied.");
      draw_info (op,buf);
  } else
    for(tmp=op->below;tmp!=NULL&&!apply(op,tmp);tmp=tmp->below);
#if 0
  if(tmp==NULL) {
    sprintf(buf,"I don't know how to apply the %s.",query_name(tmp));
    draw_info(op,buf);
  }
#endif
}

int apply_special(object *who,object *op) { /* wear/wield */
  object *tmp;
  char buf[MAX_BUF];
  int i;

  if(who==NULL) {
    LOG(llevError,"apply_special() from object without environment.\n");
    return 1;
  }
  if(op->env!=who) {
    draw_info(who,"You must get it first.");
    return 1;
  }
  if(IS_APPLIED(op)) {
    UNSET_APPLIED(op);
    switch(op->type) {
    case WEAPON:
      if(!change_abil(who,op)) {
        sprintf(buf,"You can't get rid of the %s.",query_name(op));
        SET_APPLIED(op);
        draw_info(who,buf);
        return 1;
      }
      sprintf(buf,"You unwield %s.",query_name(op));
      break;
    case ARMOUR:
    case HELMET:
    case SHIELD:
    case RING:
    case BOOTS:
    case GLOVES:
    case AMULET:
    case GIRDLE:
    case BRACERS:
      if(!change_abil(who,op)) {
        sprintf(buf,"You can't remove the %s.",query_name(op));
        SET_APPLIED(op);
        draw_info(who,buf);
        return 1;
      }
      sprintf(buf,"You unwear %s.",query_name(op));
      break;
    case BOW:
    case WAND:
      sprintf(buf,"You unready %s.",query_name(op));
      break;
    default:
      sprintf(buf,"You unapply %s.",query_name(op));
      break;
    }
    draw_info(who,buf);
    merge_ob(op,NULL);
    fix_player(who);
    if(who->type==PLAYER)
      draw_inventory(who);
    return 0;
  }
  i=0;
  for(tmp=who->inv;tmp!=NULL;tmp=tmp->below)
    if(tmp->type==op->type&&IS_APPLIED(tmp)&&tmp!=op)
      if(tmp->type==RING&&!i)
        i=1;
      else if(apply_special(who,tmp))
        return 1;
  if(op->nrof > 1)
    tmp = get_split_ob(op,op->nrof - 1);
  else
    tmp = NULL;
  switch(op->type) {
  case WEAPON:
    SET_APPLIED(op);
    if(!change_abil(who,op)) {
      UNSET_APPLIED(op);
      sprintf(buf,"You receive a jolt when you try to wield %s.",
              query_name(op));
      draw_info(who,buf);
      if(tmp!=NULL)
        insert_ob_in_ob(tmp,who);
      return 1;
    }
    sprintf(buf,"You wield %s.",query_name(op));
    break;
  case ARMOUR:
  case HELMET:
  case SHIELD:
  case RING:
  case BOOTS:
  case GLOVES:
  case AMULET:
  case GIRDLE:
  case BRACERS:
    SET_APPLIED(op);
    if(!change_abil(who,op)) {
      UNSET_APPLIED(op);
      sprintf(buf,"You receive a jolt when you try to wear %s.",
              query_name(op));
      draw_info(who,buf);
      if(tmp!=NULL)
        insert_ob_in_ob(tmp,who);
      return 1;
    }
    sprintf(buf,"You wear %s.",query_name(op));
    break;
  case BOW:
  case WAND:
    sprintf(buf,"You ready %s.",query_name(op));
    break;
  default:
    sprintf(buf,"You apply %s.",query_name(op));
  }
  SET_APPLIED(op);
  draw_info(who,buf);
  if(tmp!=NULL)
    insert_ob_in_ob(tmp,who);
  fix_player(who);
  if(IS_UNPAID(op)) /* Unapply unpaid items at once. */
    apply_special(who,op);
  if(who->type==PLAYER)
    draw_inventory(who);
  return 0;
}

int auto_apply (object *op) {
  object *tmp = NULL;
  int i;

  switch(op->type) {
  case SHOP_FLOOR:
    i=10; /* let's give it 10 tries */
    while((tmp=generate_treasure(GENERATE_TYPE(op),8))==NULL&&--i);
    if(tmp==NULL)
	break;
    tmp->x=op->x,tmp->y=op->y;
    SET_UNPAID(tmp);
    insert_ob_in_map(tmp,op->map);
    UNSET_AUTO_APPLY(op);
    break;

  case TREASURE:
    tmp=generate_treasure(GENERATE_TYPE(op), op->map == NULL ? 
			  14: op->map->difficulty);
    if(tmp!=NULL) {
      tmp->x=op->x,tmp->y=op->y;
      insert_ob_in_map(tmp,op->map);
    }
    remove_ob(op);
    free_object(op);
    break;
  }

  return tmp ? 1 : 0;
}

void fix_auto_apply(mapstruct *m) {
  object *tmp,*above;
  int x,y;
  for(x=0;x<m->mapx;x++)
    for(y=0;y<m->mapy;y++)
      for(tmp=get_map_ob(m,x,y);tmp!=NULL;tmp=above) {
        above=tmp->above;

	if(AUTO_APPLY(tmp))
          auto_apply(tmp);
        else if(tmp->type==TREASURE)
          tmp->level=m->difficulty;
	else if(tmp->type==TIMED_GATE)
	  tmp->speed = 0;
        if(tmp && tmp->arch && tmp->type!=PLAYER && tmp->arch->randomitems)
            create_treasure(tmp->arch->randomitems, tmp, GT_INVENTORY,
                            m->difficulty);
      }
  for(x=0;x<m->mapx;x++)
    for(y=0;y<m->mapy;y++)
      for(tmp=get_map_ob(m,x,y);tmp!=NULL;tmp=tmp->above)
	if (tmp->type==TRIGGER || tmp->type==TRIGGER_BUTTON ||
	    tmp->type==TRIGGER_PEDESTAL || tmp->type==TRIGGER_ALTAR)
	  check_trigger(tmp);
}
