/*
 * static char *rcsid_move_c =
 *    "$Id: move.c,v 1.1.1.1 1993/03/07 08:31:05 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <graphics.h>

int move_ob(object *op,int dir) {
  object *tmp=NULL;
  object *tmp_ob=NULL;

  if(op==NULL) {
    LOG(llevError,"Trying to move NULL.\n");
    return 0;
  }

  if(op->more!=NULL && op->head==NULL)
    remove_ob(op);

/* Vick's (vick@bern.docs.uu.se) @921108 -> If a monster can apply
   an earthwall (or a door), then walking into it means tearing it down. */

  if (op->will_apply&4 &&
      !out_of_map(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir])) {

    tmp_ob=get_map_ob(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir]);

    if (tmp_ob!=NULL) {
      while(tmp_ob->above != NULL)
        tmp_ob=tmp_ob->above;
    }
    if (tmp_ob!=NULL && tmp_ob->type == EARTHWALL)
      hit_player(tmp_ob,5,op,AT_PHYSICAL); /* Tear down the earthwall */

  }
  if (op->will_apply&8 &&
      !out_of_map(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir])) {

    tmp_ob=get_map_ob(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir]);
    if (tmp_ob!=NULL) {
      while(tmp_ob->above != NULL)
        tmp_ob=tmp_ob->above;
    }
    if (tmp_ob!=NULL && tmp_ob->type == DOOR)
      hit_player(tmp_ob,9999,op,AT_PHYSICAL); /* Break open the door. */

  }


/* Eneq(@csd.uu.se): Use blocked_two when selecting direction. */


  if(WIZPASS(op)?out_of_map(op->map,op->x+freearr_x[dir],
                                  op->y+freearr_y[dir]):
            blocked_two(op,op->x+freearr_x[dir],op->y+freearr_y[dir])) {
    if(op->more!=NULL && op->head==NULL)
      insert_ob_in_map(op,op->map);
    return 0;
  }

  if(op->more==NULL && op->head==NULL)
    remove_ob(op);                            /* Removes it from the map */
  if(op->more!=NULL)
    tmp=op->more,op->more=NULL;
#if 0
  if(WIZPASS(op)&&blocked(op->map,op->x++freearr_x[dir],
                          op->y+freearr_y[dir])) {
    if(tmp!=NULL)
      op->more=tmp;
    if(op->head==NULL)
      insert_ob_in_map(op,op->map);
    return 0;
  }
#endif

  if(tmp!=NULL)
    if(!move_ob(tmp,dir)) {
      if(tmp!=NULL)
        op->more=tmp;
      if(op->head==NULL)
        insert_ob_in_map(op,op->map);
      return 0;
    }
  op->x+=freearr_x[dir],op->y+=freearr_y[dir];  /* Move this object */
  if(tmp!=NULL)
    op->more=tmp;
  if(op->head==NULL)
    insert_ob_in_map(op,op->map);
  return 1;
}

/*
 * transfer_ob(): Move an object (even linked objects) to another spot
 * on the same map.
 */

void transfer_ob(object *op,int x,int y) {
  int i=find_first_free_spot(op->arch,op->map,x,y);
  object *tmp;
  if(op->head!=NULL)
    op=op->head;
  remove_ob(op);
  for(tmp=op;tmp!=NULL;tmp=tmp->more)
    tmp->x=x+freearr_x[i]+(tmp->arch==NULL?0:tmp->arch->clone.x),
    tmp->y=y+freearr_y[i]+(tmp->arch==NULL?0:tmp->arch->clone.y);
  insert_ob_in_map(op,op->map);
}

void teleport(object *teleporter,unsigned char tele_type) {
  object *altern[120]; /* Better use c/malloc here in the future */
  int i,j,k,nrofalt=0;
  object *other_teleporter,*teleported=teleporter->above,*tmp;

  if(teleported==NULL) return;
  if(teleported->head!=NULL)
    teleported=teleported->head;
  for(i= -5;i<6;i++)
    for(j= -5;j<6;j++) {
      if(out_of_map(teleporter->map,teleporter->x+i,teleporter->y+j))
        continue;
      other_teleporter=get_map_ob(teleporter->map,
                                  teleporter->x+i,teleporter->y+j);
      if(other_teleporter==NULL||other_teleporter->type!=tele_type||
         other_teleporter==teleporter)
        continue;
      altern[nrofalt++]=other_teleporter;
    }
  if(!nrofalt) {
    LOG(llevError,"No alternative teleporters around!\n");
    return;
  }
  other_teleporter=altern[RANDOM()%nrofalt];
  if(!(k=find_free_spot(teleported->arch,other_teleporter->map,
                        other_teleporter->x,other_teleporter->y,1,9)))
    return;
  remove_ob(teleported);
  for(tmp=teleported;tmp!=NULL;tmp=tmp->more)
    tmp->x=other_teleporter->x+freearr_x[k]+
           (tmp->arch==NULL?0:tmp->arch->clone.x),
    tmp->y=other_teleporter->y+freearr_y[k]+
           (tmp->arch==NULL?0:tmp->arch->clone.y);
  insert_ob_in_map(teleported,other_teleporter->map);
}

void recursive_roll(object *op,int dir,object *pusher) {
  char buf[MAX_BUF];
  if(!roll_ob(op,dir,pusher)) {
    sprintf(buf,"You fail to push the %s.",query_name(op));
    draw_info(pusher,buf);
    return;
  }
  (void) move_ob(pusher,dir);
  sprintf(buf,"You roll the %s.",query_name(op));
  draw_info(pusher,buf);
  return;
}

int roll_ob(object *op,int dir, object *pusher) {
  object *tmp;
  int x=op->x+freearr_x[dir],y=op->y+freearr_y[dir];
  if(!CAN_ROLL(op)||(op->weight&&RANDOM()%(op->weight/50000)>pusher->stats.Str))
    return 0;
  if(out_of_map(op->map,x,y))
    return 0;
  for(tmp=get_map_ob(op->map,op->x+freearr_x[dir],op->y+freearr_y[dir]);
      tmp!=NULL;tmp=tmp->above)
    if(IS_ALIVE(tmp)||(NO_PASS(tmp)&&!roll_ob(tmp,dir,pusher)))
      return 0;
  remove_ob(op);
  op->x+=freearr_x[dir],op->y+=freearr_y[dir];
  insert_ob_in_map(op,op->map);
  return 1;
}

int push_ob(object *who, int dir, object *pusher) {
  char buf[MAX_BUF];
  int str1, str2;
  object *owner;
  if (who->head != NULL)
    who = who->head;
  owner = get_owner(who);
  if (who->more == NULL && owner == pusher) {
    int temp;
    remove_ob(who);
    remove_ob(pusher);
    temp = pusher->x;
    pusher->x = who->x;
    who->x = temp;
    temp = pusher->y;
    pusher->y = who->y;
    who->y = temp;
    insert_ob_in_map (who,who->map);
    insert_ob_in_map (pusher,pusher->map);
    return 0;
  }
  if(UNAGGRESSIVE(who) && owner != pusher)
    who->enemy = pusher;
  str1 = (who->stats.Str?who->stats.Str:who->level);
  str2 = (pusher->stats.Str?pusher->stats.Str:pusher->level);
  if(IS_WIZ(who) || RANDOM()%(str1/2+1) + str1 >= RANDOM()%(str2/2+1) + str2 ||
     !move_ob(who,dir))
  {
    if (who ->type == PLAYER) {
      sprintf(buf,"%s tried to push you.",pusher->name);
      draw_info(who,buf);
    }
    if (IS_MONSTER(who)) {
      sprintf(buf,"Your pushing annoys %s.",who->name);
      draw_info(pusher, buf);
    }
    return 0;
  }
  if (who->type == PLAYER) {
    sprintf(buf,"%s pushed you.",pusher->name);
    draw_info(who,buf);
  }
  if (IS_MONSTER(who)) {
    if(owner == pusher)
      sprintf(buf,"%s doesn't seem pleased with your action.",who->name);
    else
      sprintf(buf,"%s is defenitely annoyed at your pushing.",who->name);
    draw_info(pusher,buf);
  }
  return 1;
}
