/*
 * static char *rcsid_xutil_c =
 *   "$Id: xutil.c,v 1.5 1993/04/25 16:08:37 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#include <graphics.h>
#include <funcpoint.h>
#include <loader.h>

char *colorname[] = {
                              "Black",              /* 0  */
                              "White",              /* 1  */
                              "DodgerBlue4",        /* 2  */
                              "Red",                /* 3  */
                              "orange1",            /* 4  */
                              "DodgerBlue",         /* 5  */
                              "DarkOrange2",        /* 6  */
                              "ForestGreen",        /* 7  */
                              "DarkSeaGreen",       /* 8  */
                              "Grey50",             /* 9  */
                              "sienna",             /* 10 */
                              "Gold",               /* 11 */
                              "Khaki"               /* 12 */ 
                            };

/*
 * Converts between Fontindex and XChar2b types.
 */

XChar2b fontindex_to_XChar2b(Fontindex s)
{
  XChar2b c;

  c.byte1 = s/256;
  c.byte2 = s%256;

  return c;
}


/*
 * ReadBitmaps(): When bitmaps are used instead of fonts, this function
 * does the actual reading of bitmap-file, and returns the
 * bitmaps array.  It assumes the bitmap file found in the LIBDIR 
 * directory.
 */


Pixmap *ReadBitmaps(Display *d) {
    char buf[MAX_BUF];
    FILE *fp;
    int i, count = 0;
    Pixmap *pixmaps;

    if (!nrofpixmaps)
	nrofpixmaps = ReadBmapNames ();

    pixmaps = (Pixmap *) malloc(sizeof(Pixmap) * nrofpixmaps);
    for (i=0; i < nrofpixmaps; i++)
	pixmaps[i] = 0;

    sprintf (buf,"%s/crossfire.cfb",LIBDIR);
    if ((fp = fopen(buf,"r"))==NULL) {
	perror("Can't open bmaps file");
	exit(-1);
    }

    LOG(llevDebug,"Building ximages...");
    for (i=0; i<nroffiles; i++) {
	if(pixmaps[xbm_values[i]] != 0) {
	    LOG(llevError,"Warning: two entries in bmaps: %d\n",xbm_values[i]);
	    continue;
	}

	if (fread (buf, 24 * 3, 1, fp) != 1) {
	    LOG(llevError,"Warning: cannot read from file\n");
	    break;
	}

	pixmaps[xbm_values[i]] =  XCreateBitmapFromData
	    (d, RootWindow (d, DefaultScreen(d)), buf, 24, 24);

	if (!pixmaps[xbm_values[i]]) {
	    LOG(llevError,"Warning: Cannot create Pixmap %d\n",xbm_values[i]);
	    pixmaps[xbm_values[i]] = 0;
	}

	if(++count > CHECK_ACTIVE_MAPS/10) {
	    printf (".");
	    fflush (stdout);
	    count = 0;
	    (*process_active_maps_func)();
	}
    }

    LOG(llevDebug,"done\n");

    /*
     * Now fill out the unused holes with pointers to a blank pixmap
     * to avoid crashes in case trying to draw a nonexistant pixmap.
     */
    for (i = 0; i < nrofpixmaps; i++)
	if (pixmaps[i] == 0)
	    pixmaps[i] = pixmaps[blank_face.number];
    return pixmaps;
}

/*
 * This function adds the path to the fontpath of the given display.
 * It's mostly copied from the X11R5 distribution.
 */

void set_font_path(Display *dpy, char *path) {
  char **currentList = NULL; int ncurrent = 0;
  char **directoryList = NULL; int ndirs = 0;

  currentList = XGetFontPath (dpy, &ncurrent);
  if(currentList==NULL) {
    LOG(llevError,"Unable to get old font path.\n");
    return;
  }
  {
    register char *cp = path;
    ndirs=1;
    while((cp=strchr(cp, ','))!=NULL)
      ndirs++,cp++;
    directoryList=(char **) malloc(ndirs*sizeof(char *));
    if(!directoryList) {
      LOG(llevError,"Unable to allocate memory for font path directory.\n");
      return;
    }
  }
  {
    int i=0;
    char *cp = path;
    directoryList[i++]=cp;
    while((cp=strchr(cp, ','))!=NULL)
      directoryList[i++]=cp+1,
      *cp++='\0';
    if(i!=ndirs) {
      LOG(llevError,"Internal error, only parsed %d of %d dirs.\n",i,ndirs);
      return;
    }
  }
  {
    int nnew=ndirs+ncurrent;
    char **newList = (char **) malloc (nnew * sizeof(char *));

    if(!newList) {
      LOG(llevError,"Couldn't get memory for new fontpath.\n");
      return;
    }
/* #if defined(SYSV) || defined(SVR4) */
    memcpy((char *)newList,(char *)directoryList,
           (unsigned) (ndirs*sizeof (char *)));
    memcpy((char *) (newList + ndirs), (char *) currentList,
           (unsigned) (ncurrent*sizeof (char *)));
    XSetFontPath(dpy,newList, nnew);
    free((char *)newList);
  }
  if (directoryList)
    free((char *) directoryList);
  if (currentList)
    XFreeFontPath (currentList);
}

/*
 * Checks if "crossfire" is present somewhere in the fontpath of
 * the given display.
 */

int check_font_path(Display *dpy) {
  int count;
  char **list;

  list = XListFonts(dpy, font_graphic, 1, &count);
  LOG(llevDebug, "Matching fonts to %s: %d (%s)\n",
      font_graphic,count,count?*list:"");
  XFreeFontNames(list);
  return count;
}

/*
 * Uses check_font_path() and set_font_path() to check and, if needed
 * fix the fontpath for a player.
 * If it fails, it sets the "use_pixmaps" flag in the player structure,
 * which will prompt the read_bmaps() function at a later time.
 */

int fixfontpath(player *pl) {

  if (check_font_path(pl->gdisp))
    return 0;

  if(fix_fontpath) {
      LOG(llevError,"Trying to fix fontpath for display %s.\n",pl->name);
      fflush(logfile);
      set_font_path(pl->gdisp,FontDir);
      if(check_font_path(pl->gdisp))
        return 0;
  }
  LOG(llevError,"Failed, switching to pixmaps (this might take a while).\n");
  pl->use_pixmaps = 1;
  sprintf(errmsg,"Display %s doesn't have the right fontpath.",pl->name);
  return 1;
}

/***************************************************************************
Any problems with colors e-mail  tvangod@icst.csuchico.edu.
Tyler Van Gorder, June 1, 1992
***************************************************************************/

/*
 * allocate_colors() tries to get enough colors for the game-window.
 * If it fails, it tries to use a private colormap.
 * If that also fails, it switches mode to black/white.
 */

void allocate_colors(player *p, Window w) {

  static int i, tried = 0;
  Status status;

  if(no_color) {
    p->iscolor=0;
    return;
  }
  p->iscolor = 1;
  p->depth = 0;
  p->vis = DefaultVisual(p->gdisp,p->gscreen);
  if ( p->vis->class == PseudoColor ){
    p->colormap = DefaultColormap(p->gdisp,p->gscreen);
    p->depth = DefaultDepth(p->gdisp,p->gscreen);
  }
  else{
    LOG(llevError,"Switching to black and white.\n");
    p->iscolor = 0;
  }
try_private:
  if (p->depth > 3 && p->iscolor) {
    unsigned long pixels[13];
    for (i=0; i<13; i++){
      status = XLookupColor(p->gdisp,p->colormap, colorname[i],&p->exactcolor,
                            &p->discolor[i]);
      if (!status){
        LOG(llevError,"Can't find colour.\n");
        LOG(llevError,"Switching to black and white.\n");
        p->iscolor = 0;
        break;
      }
      status = XAllocColor(p->gdisp,p->colormap,&p->discolor[i]);
      if (!status) {
        if (!tried) {
          LOG(llevError, "Not enough colours. Trying a private colourmap.\n");
          XFreeColors(p->gdisp, p->colormap, pixels, i-1, 0);
          p->colormap = XCreateColormap(p->gdisp, w, p->vis, AllocNone);
          XSetWindowColormap(p->gdisp, w, p->colormap);
          tried = 1;
          goto try_private;
        } else {
          LOG(llevError, "Failed. Switching to black and white.\n");
          p->iscolor = 0;
          break;
        }
      }
      pixels[i] = p->discolor[i].pixel;
    }
  }
  else {
     LOG(llevError,"You have a black and white terminal.\n");
     p->iscolor = 0;
  }
}
