#include <global.h>
#include <debug.h>
#include <xio.h>
#include <X11.h>
#include <CrUtil.h>
#include <Defines.h>

extern    Pixmap *pixmaps;       /* list of pixmaps */

void FaceDraw (Widget w, GC gc, Face *face, int x, int y) {
    XChar xbuf;

    if (HAS_COLOUR(w)) {
      XSetForeground (XtDisplay (w), gc, discolor[face->fg].pixel);
      XSetBackground (XtDisplay (w), gc, discolor[face->bg].pixel);
    }
    
    if (use_pixmaps)
	XCopyPlane(XtDisplay (w), pixmaps[face->number], 
		   XtWindow(w), gc, 0, 0, FONTSIZE, FONTSIZE, x, y, 1);

    else {
	xbuf = FontindexToXChar (face->number);
	XDRAWIMAGESTRING (XtDisplay (w),XtWindow(w), gc, x, y + 24, &xbuf, 1);
    }
    return;
}

 
GC GCCreate (Widget w) {
    XGCValues values;
    if (use_pixmaps)
	return XtAllocateGC (w, 0, 0L, NULL, GCBackground | GCForeground, 0);

    values.font = XLoadFont (XtDisplay(w),FONTNAME);
    return XtAllocateGC 
	(w, 0, GCFont, &values, GCBackground | GCForeground, 0);
}


