/*
 * static char *rcsid_global_h =
 *   "$Id: global.h,v 1.5 1993/04/12 18:57:34 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#ifndef _global_h
#define _global_h

#include "includes.h"

#ifdef TWO_BYTES_FONT
#define XDRAWIMAGESTRING(disp,win,gc,x,y,str,len) \
XDrawImageString16(disp,win,gc,x,y,str,len)
#define FontindexToXChar(s) fontindex_to_XChar2b(s)
#define XCharToFontindex(s) ((Fontindex) ((s).byte1*256 +  (s).byte2))
typedef unsigned short Fontindex;
typedef XChar2b XChar; 

#else

#define XDRAWIMAGESTRING(disp,win,gc,x,y,str,len) \
XDrawImageString(disp,win,gc,x,y,(char *)(str),len)
#define FontindexToXChar(s) ((Fontindex) (s))
#define XCharToFontindex(s) ((XChar) (s))
typedef unsigned char Fontindex;
typedef unsigned char XChar;
#endif

#include "structs.h"

/*****************************************************************************
 * GLOBAL VARIABLES:							     *
 *****************************************************************************/

/*
 * These are the beginnings of linked lists:
 */

player *first_player;
mapstruct *first_map;
treasurelist *first_treasurelist;
archetype *first_archetype;
objectlink *first_friendly_object;	/* Objects monsters will go after */
sockets *first_socket;			/* Start of linked list of sockets */

/*
 * The editor uses these (will get them out of here later):
 */

long fix_fontpath;
long synchronize;
long no_color;
long editor;     /* if true, edit maps instead of playing (almost obsolete) */
int write_state; /* 1= write to level, 2=write to name */
int write_pos;   /* Position in write_buf */
int write_d;     /* Which position in the button we start writing from */
int button_flag;
int last_bard;
int fix_walls;
int monsters;
int generators;
int hidden;
int others;

/*
 * Variables set by different flags (see init.c):
 */

int maplevel;
long delete_last_file;
long warn_archetypes;		/* If true, write warnings when failing */
				/* to find archetypes when loading from file */
long init_done;			/* Ignores signals until init_done is true */
long trying_emergency_save;	/* True when emergency_save() is reached */
LogLevel debug;			/* Set with -d flag */
long default_split_window;	/* Set with -w flag */
long dump_monsters;		/* Set with -m flag */
int use_pixmaps;		/* Set with -pix flag */
long nroferrors;		/* If it exceeds MAX_ERRORS, call fatal() */

/*
 * Global pointers to the original argv, argc and genv given to main()
 */

int gargc;
char **gargv,**genv;

/*
 * Misc global variables:
 */
FILE *logfile;			/* Used by server/daemon.c */
int exiting;			/* True if the game is about to exit */
int server_mode;		/* True if the game is in server mode */
char *name;			/* The name of the game, usually "crossfire" */
int nrofpixmaps;		/* The number of the highest pixmap */
long last_micro;		/* When process_active_maps() was last exec */
long nroftreasures;		/* Only used in malloc_info() */

archetype *empty_archetype;	/* Nice to have fast access to it */
archetype *map_archetype;

char *chrfont;
char first_map_path[MAX_BUF];	/* The start-level */
jmp_buf jump_addr;
Atom    Protocol_atom, Kill_atom;
XClientMessageEvent *cmev;
char errmsg[VERY_BIG_BUF];
long ob_count;
archetype *ring_arch,*amulet_arch,*staff_arch; /* Used in treasure.c */
char *undead_name;	/* Used in hit_player() in main.c */
sockets *active_socket;

extern int freearr_x[SIZEOFFREE], freearr_y[SIZEOFFREE];

extern Face blank_face;
extern Face blocked_face;
extern Face stipple1_face;
extern Face stipple2_face;
extern MapLook blank_look;

char *LibDir;
char *FontDir;
char *PlayerDir;
char *MapDir;
char *ArcheTypes;
char *Treasures;

extern long max_time;	/* loop time */

char *font_graphic;

#ifndef __CEXTRACT__
#include "libproto.h"
#endif

#ifdef __hpux__ /* Must do this after including proto.h */
#define strdup_local(str) strdup(str);
#endif

#ifdef SPEED_GAME

#define set_map(M,X,Y,C)	((M)->map[(X)+((M)->mapx*(Y))]=*(C))
#define get_map(M,X,Y)		(&(M)->map[(X)+((M)->mapx*(Y))])
#define set_omap(M,X,Y,C)	((M)->omap[(X)+((M)->mapx*(Y))]=(C))
#define get_omap(M,X,Y)		((M)->omap[(X)+((M)->mapx*(Y))])
#define set_map_ob(M,X,Y,tmp)	((M)->map_ob[(X)+((M)->mapx*(Y))]=(tmp))
#define get_map_ob(M,X,Y)	((M)->map_ob[(X)+((M)->mapx*(Y))])
#define out_of_map(M,X,Y)	((X)<0||(X)>=(M)->mapx||(Y)<0||(Y)>=(M)->mapy)

#endif

#ifdef USE_CALLOC
# define CALLOC(x,y)	calloc(x,y)
# define CFREE(x)	cfree(x)
#else
# define CALLOC(x,y)	malloc(x*y)
# define CFREE(x)	free(x)
#endif

/*
 * Made this a macro since it's mostly used in time-critical areas:
 * (Hopefully a good optimizer will be able to move the if() out of
 * any loop where this macro is used.  That wouldn't have been possible
 * if this was a function!)
 */

#define draw_face(pl,win,gc,x,y,face) \
{ \
  if(pl->use_pixmaps) \
  { \
    XCopyPlane(pl->gdisp,pl->pixmaps[(face)],win,gc,0,0,24,24, \
               (unsigned int) (x),(unsigned int) ((y) - 24),1); \
  } \
  else \
  { \
    XChar buf; \
    buf = FontindexToXChar((Fontindex) (face)); \
    XDRAWIMAGESTRING(pl->gdisp,win,gc,x,y,&buf,1); \
  } \
}

/*
 * Have to define LOG() to nothing if NO_LOG is defined.
 */
#ifdef NO_LOG
#define LOG()
#endif

#endif /* _global_h */
