/*
 * static char *rcsid_login_c =
 *   "$Id: login.c,v 1.8 1993/04/12 18:58:01 frankj Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to frankj@ifi.uio.no.
*/

#include <global.h>
#ifndef __CEXTRACT__
#include <sproto.h>
#endif
#include <spells.h>
#include "/usr/include/sys/stat.h" /***** !!!!! *****/

extern void sub_weight (object *, signed long);
extern void add_weight (object *, signed long);

int penalty;

void emergency_save(int d) {
#ifdef SAVE_PLAYER
  player *pl;
  penalty=d;
  trying_emergency_save = 1;
  if(editor)
    return;
  LOG(llevError,"Emergency save:  ");
  for(pl=first_player;pl!=NULL;pl=pl->next) {
    if(!pl->ob) {
      LOG(llevError, "No name, ignoring this.\n");
      continue;
    }
    LOG(llevError,"%s ",pl->ob->name);
    draw_info(pl->ob,"Emergency save...");
/* Mol(mol@meryl.csd.uu.se) 921121 Patch to get players back to a predefined
   position  i.e. the village.  It's VERY frustrating to start where you
   emergency saved if there's any monster hanging around.
   EMERGENCY_* are defined in define.h
 */
    if(pl->ob->map!=NULL)
      strcpy(pl->ob->map->path, EMERGENCY_MAPPATH);
    pl->ob->x = EMERGENCY_X;
    pl->ob->y = EMERGENCY_Y;

    if(!save_player(pl->ob,0)) {
      LOG(llevError, "(failed) ");
      draw_info(pl->ob,"Emergency save failed, checking score...");
    }
    check_score(pl->ob);
  }
  LOG(llevError,"\n");
#endif
}

void delete_character(char *name) {
  char buf[MAX_BUF];

#ifdef SAVE_HOMEDIR
  sprintf(buf,"%s/%s/%s.pl",(char *) getenv("HOME"),PlayerDir,name);
#else
  sprintf(buf,"%s/%s/%s.pl",LibDir,PlayerDir,name);
#endif
  if(unlink(buf)== -1 && debug)
    perror("crossfire (delete character)");
}

void remove_lock(player *pl) {
#ifdef LOCK_PLAYER
  char buf[MAX_BUF];

  if(pl->ob == NULL)
    return;
#ifdef SAVE_HOMEDIR
  sprintf(buf, "%s/%s", (char *) getenv("HOME"), PlayerDir);
  (void) create_savedir_if_needed(buf);
  
  sprintf(buf,"%s/%s/%s.lock",(char *) getenv("HOME"),PlayerDir,pl->ob->name);
#else
  sprintf(buf,"%s/%s/%s.lock",LibDir,PlayerDir,pl->ob->name);
#endif
  if(!rmdir(buf)) {
#ifdef DEBUG
    perror("Couldn't remove lockfile(dir)");
#endif
  }
#endif
}

int lock_player(char *name) {
#ifdef LOCK_PLAYER
  char buf[MAX_BUF];

#ifdef SAVE_HOMEDIR
  sprintf(buf, "%s/%s", (char *) getenv("HOME"), PlayerDir);
  (void) create_savedir_if_needed(buf);
  
  sprintf(buf,"%s/%s/%s.lock",(char *) getenv("HOME"),PlayerDir,name);
#else
  sprintf(buf,"%s/%s/%s.lock",LibDir,PlayerDir,name);
#endif
  if(!mkdir(buf,0770))
    return 0;
  if(errno != EEXIST) {
    perror("Couldn't create lockfile(dir)");
    return 1;
  }
  return 1;
#else
  return 0;
#endif
}

int check_name(player *me,char *name) {
  player *pl;
  for(pl=first_player;pl!=NULL;pl=pl->next)
    if(pl!=me&&pl->ob->name!=NULL&&!strcmp(pl->ob->name,name)) {
      draw_info(me->ob,"That name is already in use.");
      return 0;
    }
  if(lock_player(name)) {
    draw_info(me->ob,"That name is already in use.");
    return 0;
  }
  if(!playername_ok(name)) {
    draw_info(me->ob,"That name contains illegal characters.");
    remove_lock(me);
    return 0;
  }
  return 1;
}

KeyCode chartokeycode(object *pl,char *str) {
  KeySym ks=XStringToKeysym(str);
  if(ks==NoSymbol)
    return 0;
  return XKeysymToKeycode(pl->contr->gdisp,ks);
}

char *keycodetochar(object *pl,KeyCode k) {
  KeySym ks=XKeycodeToKeysym(pl->contr->gdisp,k,0);
  static char buf[MAX_BUF];
  if(ks==NoSymbol)
    strcpy(buf,"(null)");
  else
    strcpy(buf,XKeysymToString(ks));
  return buf;
}

#if defined(MACH)
#ifndef S_ISDIR
#define S_ISDIR(x) (((x) & S_IFMT) == S_IFDIR)
#endif
#endif

int create_savedir_if_needed(char *savedir)
{
  struct stat *buf;

  if ((buf = (struct stat *) calloc(1, sizeof(struct stat))) == NULL) {
    perror("Unable to save playerfile... out of memory.");
    return 0;
  } else {
    stat(savedir, buf);
    if ((buf->st_mode & S_IFDIR) == 0)
#if defined(_IBMR2) || defined(___IBMR2)
      if (mkdir(savedir, S_ISUID|S_ISGID|S_IRUSR|S_IWUSR|S_IXUSR))
#else
      if (mkdir(savedir, S_ISUID|S_ISGID|S_IREAD|S_IWRITE|S_IEXEC))
#endif
	{
	perror("Unable to create player savedir,");
	perror(savedir);
	return 0;
      }
    free(buf);
  }
 return 1;
}

void destroy_object (object *op)
{
    object *tmp;
    while ((tmp = op->inv))
	destroy_object (tmp);
    remove_ob(op);
    free_object(op);
}


/* If flag is set, it's only backup, ie dont remove objects from inventory*/
int save_player(object *op, int flag) {
#ifdef SAVE_PLAYER
  FILE *fp;
  char filename[MAX_BUF], *tmpfilename;
  object *tmp, *container=NULL;
  player *pl = op->contr;
  int i;
  long checksum;

  penalty=flag&2;

  flag&=1;

  if(WAS_WIZ(op)||!pl->name_changed||(!flag&&!op->stats.exp)) {
    if(!flag) {
      draw_info(op,"Your name is not valid,");
      draw_info(op,"Game not saved.");
    }
    return 0;
  }

  if (flag == 0)
    terminate_all_pets(op);

#ifdef SAVE_HOMEDIR
  sprintf(filename,"%s/%s", (char *) getenv("HOME"), PlayerDir);
  (void) create_savedir_if_needed(filename);
  
  sprintf(filename,"%s/%s/%s.pl",(char *) getenv("HOME"),PlayerDir,op->name);
#else
  sprintf(filename,"%s/%s/%s.pl",LibDir,PlayerDir,op->name);
#endif
  tmpfilename = tempnam(TMPDIR,NULL);
  fp=fopen(tmpfilename, "w");
  if(!fp) {
    draw_info(op, "Can't open file for save.");
    free(tmpfilename);
    return 0;
  }

/* Eneq(@csd.uu.se): If we have an open container hide it. */
   if (op->container)  {
     container=op->container;
       op->container=NULL;
   }

  fprintf(fp,"password %s\n",pl->password);
#ifdef SET_TITLE
  if(pl->own_title[0]!='\0')
    fprintf(fp,"title %s\n",pl->own_title);
#endif /* SET_TITLE */
#ifdef SAVE_WINDOW_POSITIONS
  if(pl->valid_save_positions && pl->split_window) {
    fprintf(fp,"win_pos");
    for(i=0;i<6;i++)
      fprintf(fp," %d %d %u %u",
	      pl->win_pos[i].x,pl->win_pos[i].y,
	      pl->win_pos[i].w,pl->win_pos[i].h);
    fprintf(fp,"\n");
  }
#endif /* SAVE_WINDOW_POSITIONS */
#ifdef EXPLORE_MODE
  fprintf(fp,"explore %d\n",pl->explore);
#endif
  fprintf(fp,"gen_hp %d\n",pl->gen_hp);
  fprintf(fp,"gen_sp %d\n",pl->gen_sp);
  fprintf(fp,"listening %d\n",pl->listening);
  fprintf(fp,"spell %d\n",pl->chosen_spell);
  fprintf(fp,"shoottype %d\n",pl->shoottype);
  fprintf(fp,"berzerk %d\n",pl->berzerk);
  fprintf(fp,"peaceful %d\n",pl->peaceful);
  fprintf(fp,"scroll %d\n",pl->scroll);
  fprintf(fp,"digestion %d\n",pl->digestion);
  if (op->map!=NULL)
    fprintf(fp,"map %s\n",op->map->path);
  else
    fprintf(fp,"map %s\n", first_map_path);
  fprintf(fp,"weapon_sp %f\n",pl->weapon_sp);
  fprintf(fp,"Str %d\n",pl->orig_stats.Str);
  fprintf(fp,"Dex %d\n",pl->orig_stats.Dex);
  fprintf(fp,"Con %d\n",pl->orig_stats.Con);
  fprintf(fp,"Int %d\n",pl->orig_stats.Int);
  fprintf(fp,"Wis %d\n",pl->orig_stats.Wis);
  fprintf(fp,"Cha %d\n",pl->orig_stats.Cha);
  fprintf(fp,"confkeys %d\n",K_RUN2);
  for(i=K_MOVE_0;i<=K_RUN2;i++)
    fprintf(fp,"%s\n",keycodetochar(op,pl->keys[i]));
  for(i=0;i<NROFPUSHKEYS;i++)
    if(pl->pushstring[i][0]!='\0'&&pl->pushkeys[i]) {
      char *cp=keycodetochar(op,pl->pushkeys[i]);
      if(cp!=NULL)
        fprintf(fp,"pushkey %s %s\n",cp,pl->pushstring[i]);
    }
  fprintf(fp,"lev_array %d\n",op->level>10?10:op->level);
  for(i=1;i<=pl->last_level&&i<=10;i++) {
    fprintf(fp,"%d\n",pl->levhp[i]);
    fprintf(fp,"%d\n",pl->levsp[i]);
  }
  for(i=0;i<pl->nrofknownspells;i++)
    fprintf(fp,"known_spell %s\n",spells[pl->known_spells[i]].name);
  fprintf(fp,"endplst\n");

#if 0
  save_object(fp,op,3); /* Save character, no check and don't remove object*/
  pl->freeze_inv=1;

  if(flag)
    for(tmp=op->inv;tmp!=NULL;tmp=tmp->below)
      save_object(fp,tmp,3); /* don't check and don't remove */
  else
    while ((tmp=op->inv)!=NULL) 
    {
        if(tmp->name == NULL)
          break; /* Something is very wrong, dont create huuuge files... */
        if(STARTEQUIP(tmp)) {
          remove_ob(tmp);
          free_object(tmp);
        } else
          save_object(fp,tmp,0); /* check and remove */
    }
#else
  pl->freeze_inv = 1;
  save_object(fp, op, 3); /* don't check and don't remove */

  if(!flag)
      while ((tmp = op->inv))
	  destroy_object (tmp);
#endif

  fclose(fp); 
  checksum = calculate_checksum(tmpfilename, 0);
  fp = fopen(filename,"w");
  if(!fp) {
    draw_info(op, "Can't open file for save.");
    unlink(tmpfilename);
    free(tmpfilename);
    return 0;
  }
  fprintf(fp,"checksum %x\n",checksum);
  copy_file(tmpfilename, fp);
  unlink(tmpfilename);
  free(tmpfilename);
  fclose(fp);
  pl->freeze_inv=0;

  /* Eneq(@csd.uu.se): Reveal the container if we have one. */
  if (flag&&container!=NULL) 
    op->container = container;

  if(!flag)
    draw_all_inventory(op);
  chmod(filename,SAVE_MODE);
  return 1;
#endif
}

/*
 * calculate_checksum:
 * Evil scheme to avoid tampering with the player-files 8)
 * The cheat-flag will be set if the file has been changed.
 */

long calculate_checksum(char *filename, int checkdouble) {
#ifdef USE_CHECKSUM
  long checksum = 0;
  int offset = 0;
  FILE *fp;
  char buf[MAX_BUF], *cp;
  if ((fp = fopen(filename,"r")) == NULL)
    return 0;
  while(fgets(buf,MAX_BUF,fp)) {
    if(checkdouble && !strncmp(buf,"checksum",8))
      continue;
    for(cp=buf;*cp;cp++) {
      if(++offset>28)
        offset = 0;
      checksum^=(*cp<<offset);
    }
  }
  fclose(fp);
  return checksum;
#else
  return 0;
#endif
}

void copy_file(char *filename, FILE *fpout) {
  FILE *fp;
  char buf[MAX_BUF];
  if((fp = fopen(filename,"r")) == NULL)
    return;
  while(fgets(buf,MAX_BUF,fp)!=NULL)
    fputs(buf,fpout);
  fclose(fp);
}

void check_login(object *op) {
#ifdef SAVE_PLAYER
  FILE *fp;
  char filename[MAX_BUF];
  char buf[MAX_BUF],bufall[MAX_BUF];
  object *tmp;
  int i,value,pushk=0,x,y;
  long checksum = 0;
  player *pl = op->contr;

  strcpy (pl->maplevel, first_map_path);
#ifdef SAVE_HOMEDIR
  sprintf(filename,"%s/%s/%s.pl",(char *) getenv("HOME"),PlayerDir,op->name);
#else
  sprintf(filename,"%s/%s/%s.pl",LibDir,PlayerDir,op->name);
#endif
  fp=open_and_uncompress(filename,1);
  if (fp==NULL) {
    confirm_password(op);
  } else {
    int correct = 0;
    if(fgets(bufall,MAX_BUF,fp) != NULL) {
      if(!strncmp(bufall,"checksum ",9)) {
        checksum = strtol_local(bufall+9,(char **) NULL, 16);
        (void) fgets(bufall,MAX_BUF,fp);
      }
      if(sscanf(bufall,"password %s\n",buf))
        /* New password scheme: */
        correct=check_password(pl->write_buf+1,buf);
      else { /* Old scheme when passwords were stored in ascii */
        bufall[strlen(bufall)-1]='\0';
        correct= !strcmp(bufall,pl->write_buf+1);
      }
    }
    if (!correct) {
      draw_info(op," ");
      draw_info(op,"Wrong Password!");
      draw_info(op," ");
      remove_lock(pl);
      if(op->name!=NULL)
        free_string(op->name);
      op->name=add_string("noname");
      pl->last_value= -1;
      draw_stats(op);
      get_name(op);
    } else {
#if SAVE_INTERVAL
      pl->last_save_time=time(NULL);
#endif /* SAVE_INTERVAL */
#ifdef SIMPLE_PARTY_SYSTEM
      pl->party_number = (-1);
#endif /* SIMPLE_PARTY_SYSTEM */
#ifdef SAVE_WINDOW_POSITIONS
      pl->valid_save_positions=0;
#endif /* SAVE_WINDOW_POSITIONS */
#ifdef SEARCH_ITEMS
      pl->search_str[0]='\0';
#endif /* SEARCH_ITEMS */
      pl->name_changed=1;
      pl->orig_stats.Str=0;
      pl->orig_stats.Dex=0;
      pl->orig_stats.Con=0;
      pl->orig_stats.Int=0;
      pl->orig_stats.Wis=0;
      pl->orig_stats.Cha=0;
      while (fgets(bufall,MAX_BUF,fp)!=NULL) {
        sscanf(bufall,"%s %d\n",buf,&value);
        if (!strcmp(buf,"endplst"))
          break;
#ifdef SET_TITLE
	else if (!strcmp(buf,"title"))
          sscanf(buf,"title %s[^\n]",pl->own_title);
#endif /* SET_TITLE */
#ifdef SAVE_WINDOW_POSITIONS
	else if (!strcmp(buf,"win_pos") && pl->split_window) {
	  pl->valid_save_positions=
	    (sscanf(bufall,
		    "win_pos %d %d %u %u %d %d %u %u %d %d %u %u %d %d %u %u %d %d %u %u %d %d %u %u",
		    &pl->win_pos[0].x,&pl->win_pos[0].y,
		    &pl->win_pos[0].w,&pl->win_pos[0].h,
		    &pl->win_pos[1].x,&pl->win_pos[1].y,
		    &pl->win_pos[1].w,&pl->win_pos[1].h,
		    &pl->win_pos[2].x,&pl->win_pos[2].y,
		    &pl->win_pos[2].w,&pl->win_pos[2].h,
		    &pl->win_pos[3].x,&pl->win_pos[3].y,
		    &pl->win_pos[3].w,&pl->win_pos[3].h,
		    &pl->win_pos[4].x,&pl->win_pos[4].y,
		    &pl->win_pos[4].w,&pl->win_pos[4].h,
		    &pl->win_pos[5].x,&pl->win_pos[5].y,
		    &pl->win_pos[5].w,&pl->win_pos[5].h)==24);
	}
#endif /* SAVE_WINDOW_POSITIONS */
#ifdef EXPLORE_MODE
      else if (!strcmp(buf,"explore"))
        pl->explore = value;
#endif
        else if (!strcmp(buf,"gen_hp"))
          pl->gen_hp=value;
        else if (!strcmp(buf,"spell"))
          pl->chosen_spell=value;
        else if (!strcmp(buf,"shoottype"))
          pl->shoottype=value;
        else if (!strcmp(buf,"gen_sp"))
          pl->gen_sp=value;
        else if (!strcmp(buf,"listening"))
          pl->listening=value;
        else if (!strcmp(buf,"berzerk"))
          pl->berzerk=value;
        else if (!strcmp(buf,"peaceful"))
          pl->peaceful=value;
        else if (!strcmp(buf,"scroll"))
          pl->scroll=value;
        else if (!strcmp(buf,"digestion"))
          pl->digestion=value;
        else if (!strcmp(buf,"map"))
	    sscanf(bufall,"map %s", pl->maplevel);
        else if (!strcmp(buf,"weapon_sp"))
          sscanf(buf,"weapon_sp %f",&pl->weapon_sp);
        else if (!strcmp(buf,"Str"))
          pl->orig_stats.Str=value;
        else if (!strcmp(buf,"Dex"))
          pl->orig_stats.Dex=value;
        else if (!strcmp(buf,"Con"))
          pl->orig_stats.Con=value;
        else if (!strcmp(buf,"Int"))
          pl->orig_stats.Int=value;
        else if (!strcmp(buf,"Wis"))
          pl->orig_stats.Wis=value;
        else if (!strcmp(buf,"Cha"))
          pl->orig_stats.Cha=value;
        else if (!strcmp(buf,"confkeys")) {
          for(i=K_MOVE_0;i<=value;i++) {
            char buf[MAX_BUF];
            fscanf(fp,"%s\n",buf);
            pl->keys[i]=chartokeycode(op,buf);
          }
        } else if (!strcmp(buf,"lev_array")){
          for(i=1;i<=value;i++) {
            int j;
            fscanf(fp,"%d\n",&j);
            pl->levhp[i]=j;
            fscanf(fp,"%d\n",&j);
            pl->levsp[i]=j;
          }
        } else if (!strcmp(buf,"spell_array")) {
          pl->nrofknownspells=value;
          for(i=0;i<pl->nrofknownspells;i++) {
            int j;
            fscanf(fp,"%d\n",&j);
            pl->known_spells[i]=j;
          }
        } else if (!strcmp(buf,"known_spell")) {
          char *cp=strchr(bufall,'\n');
          *cp='\0';
          cp=strchr(bufall,' ');
          cp++;
          for(i=0;i<NROFREALSPELLS;i++)
            if(!strcmp(spells[i].name,cp)) {
              pl->known_spells[pl->nrofknownspells++]=i;
              break;
            }
          if(i==NROFREALSPELLS)
            LOG(llevDebug, "Error: unknown spell (%s)\n",cp);
        } else if (!strcmp(buf,"pushkey")) {
          char *cp1,*cp2=strchr(bufall,' ')+1;
          cp1=strchr(cp2,' ');
          *cp1='\0';cp1++; /* No error checking...ouch */
          pl->pushkeys[pushk]=chartokeycode(op,cp2);
          cp2=strchr(cp1,'\n');
          *cp2='\0'; /* The player files had better be correct... */
          strcpy(pl->pushstring[pushk++],cp1);
        } else
          LOG(llevError,"Warning, oldfashioned variable in save-file: %s\n",
                  buf);
      }
#if 0 
      /* we MUST clear the stats structure here, so that if a stat was
         zero when it was saved, it will be restored as a zero */
      op->stats.Str= 0;
      op->stats.Dex= 0;
      op->stats.Con= 0;
      op->stats.Wis= 0;
      op->stats.Cha= 0;
      op->stats.Int= 0;
      op->stats.hp = 0;
      op->stats.maxhp = 0;
      op->stats.sp = 0;
      op->stats.maxsp = 0;
      op->stats.exp = 0;
      op->stats.food = 0;
      op->stats.dam = 0;

     load_object(fp,op); /* The first object is always the player */
#else
      /* sigh */
      free_object (op);
      op = pl->ob = LoadObject (fp);
#endif

      x=op->x; y=op->y;
      /* if old save file, try recover from it */
      if(!op->arch) {
         draw_info(op,"Error: unknown class. (probably old save file)\n");
         op->arch = find_archetype (op->race);
      }
      if(!op->arch) { /* and fail... */
        draw_info(op,"Fatal error: Can't find archetype\n");
        LOG(llevError, "Error: Unknown class; %s.\n", op->race);
      }

      strncpy(pl->title, op->arch->clone.name,MAX_NAME);
      enter_exit(op,NULL); /* This won't insert the player any longer! */
      if (op->stats.hp<0||op->stats.food<0) {
        clear_win_info(op);
        draw_info(op,"Your character was dead, when you quit.");
        draw_info(op," ");
        draw_info(op,"Do you want to play this character again (a/q)?");
        remove_lock(pl);
        delete_character(op->name);
        pl->state = ST_PLAY_AGAIN;
      } else {
        pl->name_changed=1;
        pl->state = ST_PLAYING;
        op->carrying=0;
        pl->freeze_inv=1;
        tmp=get_object();

#if 0
        while(load_object(fp,tmp)) {
          object *otmp,*optmp;

          SET_NO_FIX_PLAYER(tmp);
          insert_ob_in_ob(tmp,op);

/* Eneq(@csd.uu.se): Subtract the weight of all that is carried inside 
   containers, this will be added when restored. */
          for (otmp=tmp->inv, tmp->inv=NULL;otmp!=NULL;otmp=optmp) {
              if (otmp->nrof)
                  sub_weight(tmp,otmp->weight*otmp->nrof);
              else
                  sub_weight(tmp,otmp->weight+otmp->carrying);
              SET_NO_FIX_PLAYER(otmp);
              optmp=otmp->below;
              insert_ob_in_ob(otmp,tmp);
              UNSET_NO_FIX_PLAYER(otmp);
          }

          UNSET_NO_FIX_PLAYER(tmp);
          if(tmp->type==WEAPON&&IS_APPLIED(tmp))
            pl->weapon_sp=WEAPON_SPEED(tmp);
          tmp=get_object();
        }
        free_object(tmp);

        /* The following will be removed in future releases: */
        if(pl->orig_stats.Str==0) { /* Convertion player-files: */
          for(tmp=op->inv;tmp!=NULL;tmp=tmp->below)
            if(IS_APPLIED(tmp)) {
               UNSET_APPLIED(tmp);
               switch(tmp->type) {
               case RING:
               case WEAPON:
               case ARMOUR:
               case BRACERS:
               case HELMET:
               case SHIELD:
               case BOOTS:
               case GLOVES:
               case AMULET:
                 change_abil(op,tmp);
               }
             }
          pl->orig_stats.Str=op->stats.Str;
          pl->orig_stats.Dex=op->stats.Dex;
          pl->orig_stats.Con=op->stats.Con;
          pl->orig_stats.Int=op->stats.Int;
          pl->orig_stats.Wis=op->stats.Wis;
          pl->orig_stats.Cha=op->stats.Cha;
        }
#endif

        pl->freeze_inv=0;
        draw_all_inventory(op);
#if 0
        fix_player(op);
#else
	fix_weight ();
#endif
        if(!pl->split_window)
          XClearWindow(pl->gdisp,pl->win_root);
        draw_all_info(op);
        draw_all_inventory(op);
        draw_all_message(op);
        draw_info(op,"Welcome Back!");
        if(pl->loading == NULL) {
          if(!out_of_map(op->map,x,y))
            op->x=x, op->y=y;
          insert_ob_in_map(op,op->map);
        } else {
          LOG(llevError,"Warning: map was not in memory (%s).\n",
                  op->map->path);
          pl->removed = 0; /* Pl. will be inserted when map is loaded */
        }
        refresh(op);
        draw_all_look(op);
        close_and_delete(fp);
        LOG(llevDebug,"Checksums: %x %x\n",
                checksum,calculate_checksum(filename,1));
#ifdef CHECKSUM_ENABLED
        if(calculate_checksum(filename) != checksum) {
          draw_info(op,"Since your savefile has been tampered with,");
          draw_info(op,"you will not be able to save again.");
          set_cheat(op);
        }
#endif
      }
    }
    if (pl->state != ST_PLAYING)
      close_and_delete(fp); 
  }
  pl->last_value= -1;
  qsort(pl->known_spells,pl->nrofknownspells,
	sizeof(pl->known_spells[0]),spell_sort); /* Ignore warnings? */
  draw_stats(op);
#ifdef SAVE_WINDOW_POSITIONS
  if(pl->valid_save_positions && pl->split_window) {
    unsigned long xwc_mask=0;
    XWindowChanges xwc;
    xwc_mask=CWX|CWY|CWWidth|CWHeight;
    
    xwc.x=pl->win_pos[0].x;xwc.y=pl->win_pos[0].y;
    xwc.width=pl->win_pos[0].w;xwc.height=pl->win_pos[0].h;
    XConfigureWindow(pl->gdisp,pl->win_game,xwc_mask,&xwc);

    xwc.x=pl->win_pos[1].x;xwc.y=pl->win_pos[1].y;
    xwc.width=pl->win_pos[1].w;xwc.height=pl->win_pos[1].h;
    XConfigureWindow(pl->gdisp,pl->win_stats,xwc_mask,&xwc);

    xwc.x=pl->win_pos[2].x;xwc.y=pl->win_pos[2].y;
    xwc.width=pl->win_pos[2].w;xwc.height=pl->win_pos[2].h;
    XConfigureWindow(pl->gdisp,pl->win_info,xwc_mask,&xwc);

    xwc.x=pl->win_pos[3].x;xwc.y=pl->win_pos[3].y;
    xwc.width=pl->win_pos[3].w;xwc.height=pl->win_pos[3].h;
    XConfigureWindow(pl->gdisp,pl->win_inv,xwc_mask,&xwc);

    xwc.x=pl->win_pos[4].x;xwc.y=pl->win_pos[4].y;
    xwc.width=pl->win_pos[4].w;xwc.height=pl->win_pos[4].h;
    XConfigureWindow(pl->gdisp,pl->win_look,xwc_mask,&xwc);

    xwc.x=pl->win_pos[5].x;xwc.y=pl->win_pos[5].y;
    xwc.width=pl->win_pos[5].w;xwc.height=pl->win_pos[5].h;
    XConfigureWindow(pl->gdisp,pl->win_message,xwc_mask,&xwc);
  }
    
#endif /* SAVE_WINDOW_POSITIONS */
  return;
#endif
}
  
int spell_sort(unsigned char *a1,unsigned char *a2)
{
  return strcmp(spells[*a1].name,spells[*a2].name);
}

