/*
 * This file contains various commands that are used by the new client/server
 *	++Jam
 */

#include <global.h>
#include <commands.h>
#include <sproto.h>

#ifndef tolower
#define tolower(C)      (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))
#endif


static int compare_A(const void *a, const void *b)
{
  return strcmp(((CommArray_s *)a)->name, ((CommArray_s *)b)->name);
}

static CommArray_s *find_command_element(char *cmd, CommArray_s *commarray,
    int commsize)
{
  CommArray_s *asp, dummy;
  char *cp;

  for (cp=cmd; *cp; cp++)
    *cp =tolower(*cp);

  dummy.name =cmd;
  asp =(CommArray_s *)bsearch((void *)&dummy,
			      (void *)commarray, commsize,
			      sizeof(CommArray_s), compare_A);
  return asp;
}

int execute_newserver_command(object *pl, char *command)
{

  CommArray_s *csp;
  char *cp;

  pl->contr->has_hit=0;
  /*
   * No arguments?
   */
  if (!(cp=strchr(command, ' '))) {
      if ((csp=find_command_element(command, NewServerCommands,
	NewServerCommandSize))==NULL)
	    csp=find_command_element(command, Commands, CommandsSize);

	if (csp==NULL) {
	    char buf[MAX_BUF];

	    sprintf(buf, "'%s' is not a valid command.", command);
	    new_draw_info(NDI_UNIQUE, 0,pl, buf);
	    return 0;
	}
	if (csp->time && csp->time>pl->speed_left) {
		LOG(llevDebug,"execute_newclient_command: Player issued command that takes more time than he has left.\n");
	}
	pl->speed_left -= csp->time;
	return csp->func(pl, NULL);
  }
  /*
   * Command with some arguments
   */

  *(cp++) ='\0';
    if ((csp=find_command_element(command, NewServerCommands,
	NewServerCommandSize))==NULL)
	    csp=find_command_element(command, Commands, CommandsSize);

    if (csp==NULL) {
	char buf[MAX_BUF];

	sprintf(buf, "'%s' is not a valid command.", command);
	new_draw_info(NDI_UNIQUE, 0,pl, buf);
	return 0;
    }
    if (csp->time && csp->time>pl->speed_left) {
	LOG(llevDebug,"execute_newclient_command: Player issued command that takes more time than he has left.\n");
    }
    pl->speed_left -= csp->time;
    return csp->func(pl, cp);
}

int command_run(object *op, char *params)
{
    op->contr->run_on=1;
    return (move_player(op, params?atoi(params):0));
}

int command_run_stop(object *op, char *params)
{
    op->contr->run_on=0;
    return 1;
}

int command_fire(object *op, char *params)
{
    op->contr->fire_on=1;
    return move_player(op, params?atoi(params):0);
}

int command_fire_stop(object *op, char *params)
{
    op->contr->fire_on=0;
    return 1;
}

int bad_command(object *op, char *params)
{
    new_draw_info(NDI_UNIQUE, 0,op,"bind and unbind are no longer handled on the server");
    return 1;
}
