
/* This containes item logic for client/server.  IT doesn't contain
 * the actual commands that send the data, but does contain
 * the logic for what items should be sent.
 */


#include <global.h>
#include <object.h>	/* LOOK_OBJ */
#include <newclient.h>

enum {a_none, a_readied, a_wielded, a_worn, a_active, a_applied};
#if 0
static char *apple_string[] = {
    "", " (readied)", " (wielded)", " (worn)", " (active)", " (applied)"
};
#endif

#define F_APPLIED	0x000F
#define F_LOCATION	0x00F0
#define F_CLEAR_INV	0x0100
#define F_UNPAID	0x0200
#define F_MAGIC		0x0400
#define F_CURSED	0x0800
#define F_DAMNED	0x1000
#define F_OPEN		0x2000
#define F_NOPICK	0x4000

/* 
 *  This is a similar to query_name, but returns flags
 *  to be sended to client. 
 */
unsigned int query_flags (object *op)
{
    unsigned int flags = 0;

    if(QUERY_FLAG(op,FLAG_APPLIED)) {
	switch(op->type) {
	  case BOW:
	  case WAND:
	  case ROD:
	  case HORN:
	    flags = a_readied;
	    break;
	  case WEAPON:
	    flags = a_wielded;
	    break;
	  case ARMOUR:
	  case HELMET:
	  case SHIELD:
	  case RING:
	  case BOOTS:
	  case GLOVES:
	  case AMULET:
	  case GIRDLE:
	  case BRACERS:
	  case CLOAK:
	    flags = a_worn;
	    break;
	  case CONTAINER:
	    flags = a_active;
	    break;
	  default:
	    flags = a_applied;
	    break;
	}
    }
    if (op->type == CONTAINER && ((op->env && op->env->container == op) || 
	(!op->env && QUERY_FLAG(op,FLAG_APPLIED))))
	flags |= F_OPEN;
    
    if (QUERY_FLAG(op,FLAG_KNOWN_CURSED)) {
	if(QUERY_FLAG(op,FLAG_DAMNED))
	    flags |= F_DAMNED;
	else if(QUERY_FLAG(op,FLAG_CURSED))
	    flags |= F_CURSED;
    }
    if (QUERY_FLAG(op,FLAG_KNOWN_MAGICAL) && !QUERY_FLAG(op,FLAG_IDENTIFIED))
	flags |= F_MAGIC;
    if (QUERY_FLAG(op,FLAG_UNPAID))
	flags |= F_UNPAID;

    return flags;
}

void esrv_draw_look(object *pl)
{
#if ERICSERVER
    object *tmp, *last;
    int flags, clear = F_CLEAR_INV; /* deletes old items in look window */

    for (tmp=get_map_ob(pl->map,pl->x,pl->y); tmp && tmp->above;tmp=tmp->above)
	; 

    esrv_new_location (0);    /* ground */

    for (last=NULL; tmp!=last; tmp=tmp->below) {
	if (QUERY_FLAG(tmp, FLAG_IS_FLOOR) && !last) {
	    last = tmp->below;  /* assumes double floor mode */
	    if (last && QUERY_FLAG(last, FLAG_IS_FLOOR))
		last = last->below;
	}
	if (LOOK_OBJ(tmp)) {
	    flags = query_flags (tmp);
	    flags |= clear;
	    if (QUERY_FLAG(tmp, FLAG_NO_PICK))
		flags |=  F_NOPICK;
	    esrv_add_item (pl->contr->eric_server, tmp->count, flags,
			   QUERY_FLAG(tmp, FLAG_NO_PICK) ? -1 : tmp->weight,
			   tmp->face->number, query_short_name(tmp));
	    clear = 0;
	}
    }
    esrv_send_simple_cmd (pl->contr->eric_server, "item");
#endif
}

void esrv_send_inventory(object *pl, object *op)
{
#if ERICSERVER
    object *tmp;
    int flags, clear = F_CLEAR_INV; /* deletes old items in look window */
    
    esrv_new_location (op->count);
    
    for (tmp=op->inv; tmp; tmp=tmp->below) {
	if (LOOK_OBJ(tmp)) {
	    flags = query_flags (tmp);
	    flags |= clear;
	    if (QUERY_FLAG(tmp, FLAG_NO_PICK))
		flags |=  F_NOPICK;
	    esrv_add_item (pl->contr->eric_server, tmp->count, flags, 
			   QUERY_FLAG(tmp, FLAG_NO_PICK) ? -1 : tmp->weight,
			   tmp->face->number, query_short_name(tmp));
	    clear = 0;
	}
    }
    esrv_send_simple_cmd (pl->contr->eric_server, "item");
#endif
}

void esrv_send_item(object *pl, object*op)
{
#if ERICSERVER
    if (! LOOK_OBJ(op)) 
	return;
    if (!op->env) /* tmp. solution to keep items right order in look window */
	esrv_draw_look(pl);

    esrv_new_location (op->env ? op->env->count : 0);
    esrv_add_item (pl->contr->eric_server, op->count, query_flags(op), 
		   op->weight, op->face->number, query_short_name(op));
    esrv_send_simple_cmd (pl->contr->eric_server, "item");
#endif
}

