#include "xmalloc.h"
#include <malloc.h>
#include "libc.h"

/*
 *   eutl - A collection of useful libraries
 *   xmalloc - malloc wrappers which use the errlib routines so clients
 *             can assume the mallocs succeeded.
 *
 *   (c) Copyright 1993 Eric Anderson 
 *
 * My thanks to Geoffrey Collyer and Henry Spencer for providing the basis
 * for this copyright.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. The authors are not responsible for the consequences of use of this
 *    software, no matter how awful, even if they arise from flaws in it.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Since few users ever read sources,
 *    credits must appear in the documentation.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.  Since few users
 *    ever read sources, credits must appear in the documentation.
 *
 * 4. This notice may not be removed or altered.
 */

static ErrorFunction erf = AbortErrorFunction;
char *xmalloc_packagever = "XMalloc 1.0";
char *xmalloc_Enomem = "Out of Memory";

void xmalloc_seterf(ErrorFunction nerf)
{
  erf = nerf;
}

void *xmalloc(unsigned long size)
{
  void *ret;

  if (size==0)
    size=1;
  ret = malloc(size);
  if (ret==NULL) {
    erf(xmalloc_packagever,xmalloc_Enomem,
	"Unable to allocate %d bytes\n",size);
  }
  return ret;
}

void *xrealloc(void *old,unsigned long size)
{
  void *ret;

  if (old == NULL)
    return xmalloc(size);
  ret = realloc(old,size);
  if (ret == NULL) 
    erf(xmalloc_packagever,xmalloc_Enomem,
	"Unable to reallocate to %d bytes\n",size);
  return ret;
}

void *xbzmalloc(unsigned long size)
{
  void *ret;
  
  ret = xmalloc(size);
  bzero(ret,size);
  return ret;
}

    
