/*
 * net.c
 *
 * TCP support for 3Dc.
 */
/*

    3Dc, a game of 3-Dimensional Chess
    Copyright (C) 1995  Paul Hicks

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    E-Mail: P.Hicks@net-cs.ucd.ie
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "3Dc.h"
#include "machine.h"

int TCP_FD;
int SERVER = 0, CLIENT = 0;

int SetupServer(int port)
{
  int sock;
  int namelen, optval;
  struct sockaddr_in addr;
  struct protoent *proto;

  proto = getprotobyname("tcp");
  if (!proto)
    {
      fprintf(stderr, "Error: getprotobyname failed.\n");  
      return 1;
    }

  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = htonl(INADDR_ANY);
  sock = socket(PF_INET, SOCK_STREAM, proto->p_proto);
  if (sock == -1)
    {
      fprintf(stderr, "Error: socket failed.\n");  
      return 1;
    }

  if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&optval, sizeof(optval)) < 0)
    {
      fprintf(stderr, "Error: setsockopt failed.\n");
      return 1;
    }

  if (bind(sock, (SOCKADDR)&addr, sizeof(addr)) == -1)
    {
      fprintf(stderr, "Error: bind failed.\n");  
      return 1;
    }

  if (listen(sock, 1))
    {
      fprintf(stderr, "Error: listen failed\n");
      return(1);
    }

  printf("Waiting for connection to port %i.\n", port);
  TCP_FD = accept(sock, (SOCKADDR)&addr, &namelen);
  printf("Connection made!  You are the white player.\n");

  SERVER = 1;
  return 0;
}

int SetupClient(const char *server, const int port)
{
  int sock;
  struct sockaddr_in addr;
  struct protoent *proto;
  struct hostent *host;

  proto = getprotobyname("tcp");
  if (!proto)
    {
      fprintf(stderr, "Error: getprotobyname failed.\n");  
      return(1);
    }

  host = gethostbyname(server);
  if (!host)
    {
      fprintf(stderr, "Error: gethostbyname failed.\n");  
      return(1);
    }
          
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = inet_addr(server);
  memcpy((char *)&addr.sin_addr, (char *)(*host->h_addr_list), host->h_length);
  sock = socket(PF_INET, SOCK_STREAM, proto->p_proto);
  if (sock == -1)
    {
      fprintf(stderr, "Error: socket failed.\n");  
      return 1;
    }

  printf("Trying port %i of %s.\n", port, server);
  if (connect(sock, (SOCKADDR)&addr, sizeof(addr)) == -1)
    {
      fprintf(stderr, "Error: connect failed.\n");
      return 1;
    }
  printf("Connection made! You are the black player.\n");

  TCP_FD = sock;
  CLIENT = 1;
  return 0;
}
