/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _GAME
#define _GAME

#include "types.h"

#define PLACE_ONE       0
#define PLACE_MULTIPLE  1
#define PLACE_ALL       2

void     GAME_PlaceClick(Int32 iCountry, Int32 iPlaceType);
void     GAME_PlaceArmies(Int32 iCountry, Int32 iPlaceType);
Flag     GAME_ValidPlaceDst(Int32 iPlaceDst);

void     GAME_MoveArmies(Int32 iSrcCountry, Int32 iDstCountry, 
			 Int32 iNumArmies);
void     GAME_MoveClick(Int32 iCountry);
Flag     GAME_ValidMoveSrc(Int32 iMoveSrc);
Flag     GAME_ValidMoveDst(Int32 iMoveSrc, Int32 iMoveDst);

void     GAME_Attack(Int32 iSrcCountry, Int32 iDstCountry, Flag fCacheNotify);
void     GAME_AttackClick(Int32 iCountry);
Flag     GAME_ValidAttackSrc(Int32 iCountry, Flag fVerbose);
Flag     GAME_ValidAttackDst(Int32 iAttackSrc, Int32 iCountry, Flag fVerbose);
Flag     GAME_ValidAttackDice(Int32 iAttackDice, Int32 iCountry);

Int32    GAME_GetContinentBonus(Int32 iPlayer);
void     GAME_PlayerDied(Int32 iDeadPlayer);
void     GAME_GetCard(Int32 iPlayer);
void     GAME_ExchangeCards(Int32 *piCards);
void     GAME_GameOverMan(void);

#endif
