/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _UTILS
#define _UTILS

#include <X11/Intrinsic.h>
#include <stdio.h>
#include "types.h"

#define QUERY_YES          0
#define QUERY_NO           1
#define QUERY_CANCEL       2
#define QUERY_INPROGRESS  -1

#define PRINT_BLANK       -1

#define PLAYER_NONE       -1

#define CURSOR_PLAY        0
#define CURSOR_WAIT        1

/* X11 Graphical */
void  UTIL_PrintArmies(Int32 iCountry, Int32 iNumArmies, Int32 iColor);
void  UTIL_DisplayMessage(CString strFrom, CString strMessage);
void  UTIL_DisplayComment(CString strComment);
void  UTIL_DisplayError(CString strError);
void  UTIL_SetPlayerTurnIndicator(Int32 iPlayer);
void  UTIL_DisplayActionCString(Int32 iState, Int32 iPlayer);
void  UTIL_CenterShell(Widget wCenter, Widget wBase, Int32 *x, Int32 *y);
Int32 UTIL_GetArmyNumber(Int32 iMinArmies, Int32 iMaxArmies, Flag fLetCancel);
Int32 UTIL_PopupDialog(CString strTitle, CString strQuestion, 
		       Int32 iNumOptions, CString strOption1, 
		       CString strOption2, CString strOption3);
void  UTIL_QueryYes(Widget w, XtPointer pData, XtPointer pCalldata);
void  UTIL_QueryNo(Widget w, XtPointer pData, XtPointer pCalldata); 
void  UTIL_QueryCancel(Widget w, XtPointer pData, XtPointer pCalldata);
void  UTIL_LightCountry(Int32 iCountry);
void  UTIL_DarkenCountry(Int32 iCountry);
void  UTIL_RefreshMsgDest(Int32 iNumCStrings);
void  UTIL_SetCursorShape(Int32 iShape);
void  UTIL_DrawNiceLine(Int32 iSrcCountry, Int32 iDstCountry);

/* Notification */
void  UTIL_PlaceNotification(XtPointer msgMess, XtIntervalId *pId);
void  UTIL_AttackNotification(XtPointer msgMess, XtIntervalId *pId);
void  UTIL_MoveNotification(XtPointer msgMess, XtIntervalId *pId);

/* Non-X11 */
void    UTIL_ServerEnterState(Int32 iNewState);
void    UTIL_ServerEndTurn(void);
Flag    UTIL_PlayerIsLocal(Int32 iPlayer);
Int32   UTIL_NumPlayersAtClient(Int32 iClient);
void    UTIL_ExitProgram(Int32 iExitValue);
FILE   *UTIL_OpenFile(CString strName, CString strOptions);

#endif


