/****************************************************************************************************************
 *
 *  Copyright (c) 1992 by Antoine Dumesnil de Maricourt. All rights reserved.
 *
 *  This program is distributed in the hope that it will be useful.
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted, so long as the following
 *  conditions are met:
 *       o credit to the authors is acknowledged following current
 *         academic behaviour
 *       o no fees or compensation are charged for use, copies, or
 *         access to this software
 *       o this copyright notice is included intact.
 *  This software is made available AS IS, and no warranty is made about 
 *  the software or its performance. 
 * 
 *  Bug descriptions, use reports, comments or suggestions are welcome.
 *  Send them to    dumesnil@etca.fr   or to:
 *       
 *       Antoine de Maricourt
 *       ETCA CREA-SP
 *       16 bis, avenue Prieur de la Cote d'Or
 *       94114 Arcueil Cedex
 *       France
 */
 /* Modified by Randy Hootman (rph@netcom.com) to compile under Linux */

#ifndef _sg_h_
#define _sg_h_

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>

#define SG_Black              1	        /*  Done  */
#define SG_White              2	        /*  Done  */
#define SG_Comment            3	        /*  Done  */
#define SG_nodeName           4	        /*  Done  */
#define SG_nodeValue          5
#define SG_CHeck              6
#define SG_GoodBlack          7
#define SG_GoodWhite          8
#define SG_TEsuji             9
#define SG_BadMove           10
#define SG_BlackLeft         11	        /*  Done  */
#define SG_WhiteLeft         12	        /*  Done  */
#define SG_FiGure            13
#define SG_AddBlack          14	        /*  Done  */
#define SG_AddWhite          15	        /*  Done  */
#define SG_AddEmpty          16	        /*  Done  */
#define SG_PLayer            17
#define SG_GameName          18	        /*  Done  */
#define SG_GameComment       19	        /*  Done  */
#define SG_EVent             20	        /*  Done  */
#define SG_ROund             21	        /*  Done  */
#define SG_DaTe              22	        /*  Done  */
#define SG_PlaCe             23	        /*  Done  */
#define SG_PlayerBlack       24	        /*  Done  */
#define SG_PlayerWhite       25	        /*  Done  */
#define SG_REsult            26	        /*  Done  */
#define SG_USer              27	        /*  Done  */
#define SG_TiMe              28	        /*  Done  */
#define SG_SOurce            29	        /*  Done  */
#define SG_GaMe              30
#define SG_SiZe              31
#define SG_VieW              32	        /*  Done  */
#define SG_BlackSpec         33
#define SG_WhiteSpec         34
#define SG_EvaLuation        35
#define SG_EXpected          36
#define SG_SeLected          37
#define SG_Marked            38
#define SG_Letters           39
#define SG_BlackRank         40	        /*  Done  */
#define SG_WhiteRank         41	        /*  Done  */
#define SG_HAndicap          42	        /*  Done  */
#define SG_KoMi              43	        /*  Done  */
#define SG_TerritoryBlack    44
#define SG_TerritoryWhite    45
#define SG_SeCure            46
#define SG_ReGion            47
#define SG_KO                48
#define SG_Illegal           49

#define SG_MaxID             SG_Illegal

#define SG_unVieW            SG_Illegal + 1
#define SG_ko                SG_Illegal + 2

typedef struct _SG_Property {
  int id;

  union {
    long           ivalue;
    unsigned char *pvalue;
  } data;

  struct _SG_Property *next;

} SG_Property, *SG_PropertyPtr;

typedef struct _SG_Node {
 
  short             type;

  short             num;
  char              color;
  char              x;
  char              y;
  char              player;

  unsigned char    *setup;
  SG_PropertyPtr    property;
    
  struct _SG_Node  *up;
  struct _SG_Node  *down;
  struct _SG_Node  *left;
  struct _SG_Node  *right;

} SG_Node, *SG_NodePtr;  

#define SG_NoType               0
#define SG_EventType            1
#define SG_MoveType             2
#define SG_DiagramType          4

#define SG_EmptyPoint           0
#define SG_Border               1
#define SG_WhiteStone           2
#define SG_BlackStone           3

#define SG_Event                0
#define SG_Move                 1
#define SG_VariationMove        2
#define SG_Diagram              3
#define SG_VariationDiagram     4

#define SG_SetupProperty        1
#define SG_CommentProperty      2
#define SG_GameNameProperty     3

#define SG_EOS                  0xff

#define SG_SETMASK              ((1 << 7) | (1 << 6))
#define SG_SETB                 ((1 << 7) | (1 << 6))
#define SG_SETW                 (1 << 7)
#define SG_SETEB                (1 << 6)
#define SG_SETEW                0
#define SG_SETE                 SG_SETEB

#define SG_OK                   0
#define SG_PlaySuicide          1
#define SG_PlayKo               2
#define SG_PlayIllegal          3

#define SG_EOFERR               1
#define SG_NSTERR               2
#define SG_NCLERR               3
#define SG_NCTERR               4
#define SG_NDGERR               5

typedef struct {
  char             *keyword;
  char             *print;
  int               id;
  int               node_id;
} SG_KWData;

extern SG_KWData                sg_keywords[];

extern SG_NodePtr               SG_MakeNode     ();
extern SG_PropertyPtr           SG_GetProperty  ();
extern void                     SG_MakeProperty ();
extern void                     SG_FreeNode     ();
extern SG_NodePtr               SG_RemoveNode   ();
extern SG_NodePtr               SG_ReadTree     ();
extern int                      SG_WriteTree    ();

#ifdef _GNU_SOURCE
extern void                     SG_strcat       (char **, char *, char);
extern void                     SG_strcpy       (char **, char *, char);
#else
extern void                     SG_strcat       ();
extern void                     SG_strcpy       ();
#endif

#endif    /* _sg_h_ */














