/*
 * Programm XBLAST V1.04 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1993
 * started August 1993
 *
 *
 * File: const.h
 * constants and types for main.c, maze.c, graphics.c .
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define TRUE 1
#define FALSE 0

#define DEVELOP FALSE

#define MAX_VICTORIES 5

#define FADE_STEP 16

#define DEAD_TIME 8

#ifdef DOUBLE_SPEED
#define TIME_STEP 24
#else
#define TIME_STEP 48 /* 48 */
#endif
#define STUN_TIME 16
#define GAME_TIME (60*TIME_STEP + DEAD_TIME)


#define NEW_INVINCIBLE 64
#define EXTRA_INVINCIBLE 160
#define MAX_LIVES 3
#define MAX_RANGE 10

#define BIG_WIDTH 112
#define BIG_HEIGHT 144

#define SPRITE_WIDTH 48
#define SPRITE_HEIGHT 69
#define SPRITE_Y_OFF 20
#define SPRITE_X_OFF 8

#define WINNER_WIDTH 64
#define WINNER_HEIGHT 69
#define WINNER_Y_OFF 20
#define WINNER_X_OFF 0

#define LED_WIDTH 16
#define LED_HEIGHT 16

#define PIXW (MAZE_W * BLOCK_WIDTH)
#define PIXH (MAZE_H * BLOCK_HEIGHT)
#define SCOREH (BLOCK_HEIGHT+LED_HEIGHT)

#ifdef DOUBLE_SPEED
#define BOMB_VX 16
#define BOMB_VY 12
#else
#define BOMB_VX 16
#define BOMB_VY 12
#endif
#define BOMB_STUN_X 32
#define BOMB_STUN_Y 24


  /* Blockbitmaps */

#define BLKaroLight      0
#define BLKaroDark       1
#define BLPyramid        2
#define BLWall           3
#define BLExtra          4
#define BLRange          5
#define BLBomb           6
#define BLChest          7
#define BLTrap           8
#define BLHex            9
#define BLHexExtra       10
#define BLHexWall        11
#define BLLegoFloor      12
#define BLLegoWhite      13
#define BLLegoBlack      14
#define BLScoreRightUp   15
#define BLScoreRightDown 16
#define BLScoreMidUp     17
#define BLScoreMidDown   18
#define BLScoreLeftUp    19
#define BLScoreLeftDown  20
#define BLBricks         20
#define BLScoreFloor     21
#define BLIronFloor      22
#define BLDarkBlock      23
#define BLDarkHouse      24
#define BLLightHouse     25
#define BLCityFree       26
#define BLControlNum     27
#define BLControlAlpha   28
#define BLDisplay        29
#define BLSphereLight    30
#define BLSphereDark     31
#define BLSphereHalf     32
#define BLInvincible     33
#define BLTemple         34
#define BLRemoteControl  35
#define BLBookShelf      36
#define BLChessFloor     37
#define BLChessSphere    38
#define BLPumpkin        39
#define BLRIP            40
#define BLDarkWay        41
#define BLKaroLight_S    42
#define BLExtra_O        43
#define BLKaroDark_S     44
#define BLChest_O        45
#define BLIronFloor_S    46
#define BLBricks_O       47
#define BLSphereHalf_S   48
#define BLSphereLight_O  49
#define BLHexExtra_O     50
#define BLChessFloor_S   51
#define BLChessSphere_O  52
#define BLLegoFloor_S    53
#define BLLegoBlack_O    54
#define BLCityFree_S     55
#define BLLightHouse_O   56
#define BLDarkWay_S      57
#define BLPumpkin_O      58
#define BLKick           59
#define BLPyramidRise    60
#define BLWallRise       61
#define BLDarkBlockRise  62
#define BLRIPRise        63
#define BLDarkHouseRise  64
#define BLIgnite         65
#define BLBox            66
#define BLButtonFloor    67
#define BLDarkButton     68

#define MAX_BLOCK_TILES  69








