/*
 * Programm XBLAST V1.04 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1994
 * started August 1993
 *
 * File: data.h
 * level data 
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 1; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/* special init functions */
     
extern void special_init_void();
extern void special_init_kick();
extern void special_init_race();
extern void special_init_shrink();
extern void special_init_shrink_2();
extern void special_init_shrink_2_and_kick();

/* special revive_functions */

extern void special_revive_void();
extern void special_revive_race();
extern void special_revive_kick();

/* special game_fucntions */

extern void special_game_void();
extern void special_game_shrink();
extern void special_game_shrink_2();


/* special extra_functions */

extern void special_extra_void();
extern void special_extra_invincible();
extern void special_extra_kick();
extern void special_extra_RC();
extern void special_extra_stunned();
extern void special_extra_ignite_all();


/* special key_functions */

extern void special_key_void();
extern void special_key_RC();


#define _ BTFree
#define B BTBlock
#define R BTBlockRise
#define X BTExtra
#define b BTBomb
#define r BTRange
#define s BTSick
#define q BTSpecial

#define ShadowNone  0
#define ShadowBlock 1
#define ShadowExtra 2
#define ShadowFull  3

static BMLevelData Seek_N_Destroy =
{
  "Seek'n Destroy",
  special_init_shrink_2,
  special_revive_void,
  special_game_shrink_2,
  special_extra_kick,
  special_key_void,
  {
    { SPRITE_UP, SPRITE_LEFT },
    { SPRITE_UP, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_LEFT }
  },
  2, 1, GoStop,
  {16,48,48,60,56},
#if 1
  { BLKaroLight, BLKaroLight_S, BLPyramid, BLPyramidRise, BLExtra, BLExtra_O, 
      BLBomb, BLRange, BLTrap, BLKick },
  ShadowFull,
#else
  { BLButtonFloor, BLButtonFloor, BLPyramid, BLPyramidRise, 
      BLBox, BLBox, 
      BLBomb, BLRange, BLTrap, BLKick },
  ShadowNone,
#endif
  {
    /* Seek'n'Destroy */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,_,_,X,_,X,_,X,_,_,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,_,_,X,_,X,_,X,_,_,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData Treasure_Hunt =
{
  "Treasure Hunt",
  special_init_shrink_2,
  special_revive_void,
  special_game_shrink_2,
  special_extra_kick,
  special_key_void,
  {
    { SPRITE_UP, SPRITE_LEFT },
    { SPRITE_UP, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_LEFT }
  },
  2, 1, GoStop,
  {20,34,44,56,56},
  { BLKaroDark, BLKaroDark_S, BLWall, BLWallRise, BLChest, BLChest_O, 
      BLBomb, BLRange, BLTrap, BLKick},
  ShadowFull,
  {
    /* Treasure Hunt */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,_,_,X,_,_,_,X,_,_,_,B },
    { B,_,B,X,B,B,X,B,B,X,B,_,B },
    { B,_,B,X,X,_,_,_,X,X,B,_,B },
    { B,_,X,X,B,X,B,X,B,X,X,_,B },
    { B,X,B,_,X,_,_,_,X,_,B,X,B },
    { B,_,B,_,B,X,B,X,B,_,B,_,B },
    { B,_,X,X,B,X,X,X,B,X,X,_,B },
    { B,_,B,_,B,X,B,X,B,_,B,_,B },
    { B,X,B,_,X,_,_,_,X,_,B,X,B },
    { B,_,X,X,B,X,B,X,B,X,X,_,B },
    { B,_,B,X,X,_,_,_,X,X,B,_,B },
    { B,_,B,X,B,B,X,B,B,X,B,_,B },
    { B,_,_,_,X,_,_,_,X,_,_,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData Shrinking_World =
{
  "Shrinking World",
  special_init_shrink,
  special_revive_void,
  special_game_shrink,
  special_extra_void,
  special_key_void,
  {
    { SPRITE_UP, SPRITE_LEFT },
    { SPRITE_UP, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_LEFT }
  },
  2, 1, GoStop,
  {16,48,48,48,48},
#if 0
  { BLIronFloor, BLIronFloor_S, BLDarkBlock, BLDarkBlockRise, 
      BLBricks, BLBricks_O, BLBomb, BLRange, BLTrap, BLScoreFloor },
  ShadowFull,
#else
  { BLButtonFloor, BLButtonFloor, BLDarkBlock, BLDarkBlockRise, 
      BLBox, BLBox     , BLBomb, BLRange, BLTrap, BLScoreFloor },
  ShadowNone,
#endif
  {
    /* Shrinking World */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,_,_,X,_,X,_,X,_,_,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,_,_,X,_,X,_,X,_,_,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData XBlast_2000 =
{
  "XBlast 2000",
  special_init_shrink_2,
  special_revive_void,
  special_game_shrink_2,
  special_extra_invincible,
  special_key_void,
  {
    { SPRITE_UP+2*BLOCK_HEIGHT,   SPRITE_LEFT+2*BLOCK_WIDTH  },
    { SPRITE_UP+2*BLOCK_HEIGHT,   SPRITE_RIGHT-2*BLOCK_WIDTH },
    { SPRITE_DOWN-2*BLOCK_HEIGHT, SPRITE_RIGHT-2*BLOCK_WIDTH },
    { SPRITE_DOWN-2*BLOCK_HEIGHT, SPRITE_LEFT+2*BLOCK_WIDTH  }
  },
  2, 1, GoStop,
  {16,32,48,64,64},
  { BLSphereHalf, BLSphereHalf_S, BLSphereDark, BLSphereLight, BLSphereLight, 
      BLSphereLight_O, BLBomb, BLRange, BLTrap, BLInvincible },
  ShadowFull,
  {
    /* Xbomb 2000 */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,X,_,_,X,_,_,_,X,_,_,X,B },
    { B,_,B,_,B,X,B,X,B,_,B,_,B },
    { B,_,_,_,X,_,_,_,X,_,_,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,_,_,X,_,X,_,B },
    { B,_,B,_,B,_,B,_,B,_,B,_,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,_,B,_,B,_,B,_,B,_,B,_,B },
    { B,_,X,_,X,_,_,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,_,_,X,_,_,_,X,_,_,_,B },
    { B,_,B,_,B,X,B,X,B,_,B,_,B },
    { B,X,_,_,X,_,_,_,X,_,_,X,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData Full_Power =
{
  "Full Power Level",
  special_init_shrink_2_and_kick,
  special_revive_kick,
  special_game_shrink_2,
  special_extra_void,
  special_key_void,
  {
    { SPRITE_UP, SPRITE_LEFT },
    { SPRITE_UP, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_LEFT }
  },
  10, 5, GoStop,
  { 0, 0, 0, 0, 0},
  { BLIronFloor, BLIronFloor_S, BLDarkBlock, BLDarkBlockRise, BLExtra, BLExtra,
      BLBomb, BLRange, BLTrap, BLInvincible },
  ShadowBlock,
  {
    /* Full Power Level */
    { B,B,B,B,B, B,B,B,B,B, B,B,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,_,B,_,B, _,B,_,B,_, B,_,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,_,B,_,B, _,B,_,B,_, B,_,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,_,B,_,B, _,B,_,B,_, B,_,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,_,B,_,B, _,B,_,B,_, B,_,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,_,B,_,B, _,B,_,B,_, B,_,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,_,B,_,B, _,B,_,B,_, B,_,B },
    { B,_,_,_,_, _,_,_,_,_, _,_,B },
    { B,B,B,B,B, B,B,B,B,B, B,B,B }
  },

};



static BMLevelData Hexagon_Excitation =
{
  "Hexagon Excitation",
  special_init_shrink_2,
  special_revive_void,
  special_game_shrink_2,
  special_extra_kick,
  special_key_void,
  {
    { SPRITE_UP, SPRITE_LEFT },
    { SPRITE_UP, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_LEFT }
  },
  2, 1, GoStop,
  {16,48,52,60, 56},
  { BLHex, BLHex, BLHexWall, BLHexExtra, BLHexExtra, BLHexExtra_O, 
      BLBomb, BLRange, BLTrap, BLKick },
  ShadowNone,
  {
    /* Hexagon Excitation */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,_,_,X,_,B,_,X,_,_,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,X,X,X,_,X,_,X,X,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,B,X,_,X,_,X,B,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,X,X,X,X,_,X,X,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,B,X,_,X,_,X,B,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,X,X,_,X,_,X,X,X,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,_,_,X,_,B,_,X,_,_,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData Running_Man =
{
  "Running Man",
  special_init_race,
  special_revive_race,
  special_game_void,
  special_extra_RC,
  special_key_RC,
  {
    { SPRITE_UP, SPRITE_LEFT },
    { SPRITE_UP, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_RIGHT},
    { SPRITE_DOWN, SPRITE_LEFT }
  },
  2, 1, GoStop,
  {20,36,36,48, 48},
  { BLChessFloor, BLChessFloor_S, BLBookShelf, BLBookShelf, BLChessSphere, 
      BLChessSphere_O, BLBomb, BLRange, BLTrap, BLRemoteControl },
  ShadowBlock,
  {
    /* Running Man */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,_,_,X,_,X,_,X,_,_,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,X,_,_,_,X,_,_,_,X,_,B },
    { B,_,B,_,B,X,B,X,B,_,B,_,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,_,B,_,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,X,B,X,B,_,B,_,B,X,B,X,B },
    { B,_,X,_,X,_,X,_,X,_,X,_,B },
    { B,_,B,_,B,X,B,X,B,_,B,_,B },
    { B,_,X,_,_,_,X,_,_,_,X,_,B },
    { B,_,B,X,B,X,B,X,B,X,B,_,B },
    { B,_,_,_,X,_,X,_,X,_,_,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData Legoland =
{
  "Legoland",
  special_init_void,
  special_revive_void,
  special_game_void,
  special_extra_void,
  special_key_void,
  {
    { SPRITE_UP+2*BLOCK_HEIGHT,   SPRITE_LEFT+2*BLOCK_WIDTH  },
    { SPRITE_UP+2*BLOCK_HEIGHT,   SPRITE_RIGHT-2*BLOCK_WIDTH },
    { SPRITE_DOWN-2*BLOCK_HEIGHT, SPRITE_RIGHT-2*BLOCK_WIDTH },
    { SPRITE_DOWN-2*BLOCK_HEIGHT, SPRITE_LEFT+2*BLOCK_WIDTH  }
  },
  2, 1, GoStop,
  {16,40,54,48, 48},
  { BLLegoFloor, BLLegoFloor_S, BLLegoWhite, BLLegoFloor, BLLegoBlack, 
      BLLegoBlack_O, BLBomb, BLRange, BLTrap, BLScoreFloor  },
  ShadowFull,
  {
    /* Legoland */
    { q,q,q,q,q,q,q,q,q,q,q,q,q },
    { q,R,R,R,R,R,R,R,R,R,R,R,q },
    { q,R,B,B,B,B,B,B,B,B,B,R,q },
    { q,R,B,_,_,X,X,X,_,_,B,R,q },
    { q,R,B,_,B,_,B,_,B,_,B,R,q },
    { q,R,B,X,X,X,X,X,X,X,B,R,q },
    { q,R,B,_,B,X,B,X,B,_,B,R,q },
    { q,R,B,X,X,_,_,_,X,X,B,R,q },
    { q,R,B,_,B,X,B,X,B,_,B,R,q },
    { q,R,B,X,X,X,X,X,X,X,B,R,q },
    { q,R,B,_,B,_,B,_,B,_,B,R,q },
    { q,R,B,_,_,X,X,X,_,_,B,R,q },
    { q,R,B,B,B,B,B,B,B,B,B,R,q },
    { q,R,R,R,R,R,R,R,R,R,R,R,q },
    { q,q,q,q,q,q,q,q,q,q,q,q,q }
  },

};



static BMLevelData Paradise_City =
{
  "Paradise City",
  special_init_shrink_2,
  special_revive_void,
  special_game_shrink_2,
  special_extra_void,
  special_key_void,
  {
    { SPRITE_UP+4*BLOCK_HEIGHT,   SPRITE_LEFT+4*BLOCK_WIDTH  },
    { SPRITE_UP+4*BLOCK_HEIGHT,   SPRITE_RIGHT-4*BLOCK_WIDTH },
    { SPRITE_DOWN-4*BLOCK_HEIGHT, SPRITE_RIGHT-4*BLOCK_WIDTH },
    { SPRITE_DOWN-4*BLOCK_HEIGHT, SPRITE_LEFT+4*BLOCK_WIDTH  }
  },
  2, 1, GoStop,
  {12,24,40,40, 40 },
  { BLCityFree, BLCityFree_S, BLDarkHouse, BLDarkHouseRise, BLLightHouse, 
      BLLightHouse_O, BLBomb, BLRange, BLTrap, BLInvincible },
  ShadowFull,
  {
    /* Paradise City */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,r,_,b,_,r,_,b,_,r,_,B },
    { B,r,B,X,B,X,B,X,B,X,B,r,B },
    { B,_,X,X,_,X,_,X,_,X,X,_,B },
    { B,b,B,_,B,X,B,X,B,_,B,b,B },
    { B,_,X,X,X,_,_,_,X,X,X,_,B },
    { B,r,B,_,B,_,B,_,B,_,B,r,B },
    { B,_,X,X,X,_,_,_,X,X,X,_,B },
    { B,r,B,_,B,_,B,_,B,_,B,r,B },
    { B,_,X,X,X,_,_,_,X,X,X,_,B },
    { B,b,B,_,B,X,B,X,B,_,B,b,B },
    { B,_,X,X,_,X,_,X,_,X,X,_,B },
    { B,r,B,X,B,X,B,X,B,X,B,r,B },
    { B,_,r,_,b,_,r,_,b,_,r,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }
  },

};



static BMLevelData Halloween =
{
  "Hallowe'en",
  special_init_shrink_2,
  special_revive_void,
  special_game_shrink_2,
  special_extra_ignite_all,
  special_key_void,
  {
    { SPRITE_UP+2*BLOCK_HEIGHT,   SPRITE_LEFT+2*BLOCK_WIDTH  },
    { SPRITE_UP+2*BLOCK_HEIGHT,   SPRITE_RIGHT-2*BLOCK_WIDTH },
    { SPRITE_DOWN-2*BLOCK_HEIGHT, SPRITE_RIGHT-2*BLOCK_WIDTH },
    { SPRITE_DOWN-2*BLOCK_HEIGHT, SPRITE_LEFT+2*BLOCK_WIDTH  }
  },
  2, 1, GoStop,
  {16,32,40,50,58},
  { BLDarkWay, BLDarkWay_S, BLRIP, BLRIPRise, BLPumpkin, BLPumpkin_O, 
      BLBomb, BLRange, BLTrap, BLIgnite },
  ShadowFull,
  {
    /* Hallowe'en */
    { B,B,B,B,B,B,B,B,B,B,B,B,B },
    { B,_,X,_,_,X,_,X,_,_,X,_,B },
    { B,X,B,X,B,B,X,B,B,X,B,X,B },
    { B,_,X,_,_,X,_,X,_,_,X,_,B },
    { B,_,B,_,B,B,X,B,B,_,B,_,B },
    { B,_,X,_,X,_,_,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,B,_,X,_,X,_,B },
    { B,X,B,X,B,X,B,X,B,X,B,X,B },
    { B,_,X,_,X,_,_,_,X,_,X,_,B },
    { B,_,B,_,B,B,X,B,B,_,B,_,B },
    { B,_,X,_,_,X,_,X,_,_,X,_,B },
    { B,X,B,X,B,B,X,B,B,X,B,X,B },
    { B,_,X,_,_,X,_,X,_,_,X,_,B },
    { B,B,B,B,B,B,B,B,B,B,B,B,B }  
  },

};



/* This is the graphics for the Scoreboard */

static BMLevelData ScoreBoard =
{
  "SCOREBOARD",
  special_init_void,
  special_revive_void,
  special_game_void,
  special_extra_void,
  special_key_void,
  {
    { BLOCK_HEIGHT*3 + 24 , BLOCK_WIDTH*4},
    { BLOCK_HEIGHT*5 + 24 , BLOCK_WIDTH*4},
    { BLOCK_HEIGHT*7 + 24 , BLOCK_WIDTH*4},
    { BLOCK_HEIGHT*9 + 24 , BLOCK_WIDTH*4},
  },
  0, 0, GoStop,
  {0,0,0,0,0},
  { BLScoreLeftUp, BLScoreLeftDown, 
      BLScoreMidUp, BLScoreMidDown, 
      BLScoreRightUp, BLScoreRightDown,
      BLScoreFloor },
  ShadowNone,
  {
    /* Score Board */
    {  0,0,1,6,0,1,0,1,0,1,0,1,6, },
    {  0,0,1,6,0,1,0,1,0,1,0,1,6, },
    {  0,0,1,6,0,1,0,1,0,1,0,1,6, },
    {  0,0,1,6,2,3,2,3,2,3,2,3,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, },
    {  0,0,1,6,4,5,4,5,4,5,4,5,6, }
  },

};



/* This is the graphics for the congratulations screen */

static BMLevelData Congratulations =
{
  "CONGRATULATIONS",
  special_init_void,
  special_revive_void,
  special_game_void,
  special_extra_void,
  special_key_void,
  {
    { BLOCK_HEIGHT*3 + 24 , BLOCK_WIDTH}, 
    { BLOCK_HEIGHT*3 + 24 , BLOCK_WIDTH*13},
    { BLOCK_HEIGHT*9 + 24 , BLOCK_WIDTH*13}, 
    { BLOCK_HEIGHT*9 + 24 , BLOCK_WIDTH},
  },
  0, 0, GoStop,
  {0,0,0,0,0},
  { BLScoreLeftUp, BLScoreLeftDown, 
      BLScoreMidUp, BLScoreMidDown, 
      BLScoreRightUp, BLScoreRightDown,
    BLScoreFloor },
  ShadowNone,
  {
    /* Congratulations */
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,4,5,6,6,6,6,4,5,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,0,0,1,6,6,6,6 },
    {  0,0,1,6,6,6,0,0,1,6,6,6,6 },
    {  0,0,1,6,6,6,0,0,1,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
    {  0,0,1,6,4,5,6,6,6,6,4,5,6 },
    {  0,0,1,6,6,6,6,6,6,6,6,6,6 },
  }    

};


/* This is important */

#undef _ 
#undef B 
#undef X 
#undef b 
#undef r 
#undef s 
#undef q 



#define TOTAL_LEVEL (LEVEL_MAX+2)

static BMLevelData *maze_data[TOTAL_LEVEL] = 
{
  &Seek_N_Destroy,
  &Treasure_Hunt,
  &Shrinking_World,
  &XBlast_2000,
  &Full_Power,
  &Hexagon_Excitation,
  &Running_Man,
  &Legoland,
  &Paradise_City,
  &Halloween,
  /* No new levels beyond this point */
  &ScoreBoard,
  &Congratulations
};



