/*
 * Programm XBLAST V1.04 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * May 16th 1994
 * started August 1993
 *
 * File: setup.c 
 * interactive setup for xblast
 * (only text input by now)
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#ifndef Lynx
#include <malloc.h>
#endif
#include <string.h>
#include "include.h"
#include "mytypes.h"
#include "const.h"


extern void do_bell();
extern void no_bell();

static char *def_home=".";
static char *setup_file="/.xblast";



int load_setup(/*label,*/ num_player, num_disp, display, ps, max_victories,
		       random_mode, start_level, sound_flag, max_lives)
/*     char *label;*/
     int *num_player, *num_disp;
     char *display[MAX_PLAYER];
     BMPlayer *ps;
     int *max_victories, *random_mode, *start_level, *sound_flag, *max_lives;
{
  FILE *fp;
  char *home,*ptr;
  char zeile[200],filename[200];
  int i, return_value = 0;

  if ( (home = getenv("HOME")) == NULL )
    home = def_home;
  
  strcpy( filename, home );
  strcat( filename, setup_file );

  if ( (fp = fopen(filename,"r")) == NULL)
    {
      printf("Couldn't open file %s\n",filename);
      return_value = 1;
    }
  else
    {
      /* Dummy */
      fscanf(fp,"%s",zeile);

      fscanf(fp,"%d %d",num_player,num_disp);
      for (i=0; i<*num_player; i++)
	{
	  fscanf(fp,"%s",zeile);
	  ptr = (char *)malloc( (strlen(zeile)+1)*sizeof(char) );
	  strcpy(ptr, zeile);
	  ps[i].name = ptr;
	}
      for (i=0; i<*num_disp; i++)
	{
	  fscanf(fp,"%s",zeile);
	  ptr = (char *)malloc( (strlen(zeile)+1)*sizeof(char) );
	  strcpy(ptr, zeile);
	  display[i] = ptr;
	}
      fscanf(fp,"%d %d %d %d %d",max_victories, random_mode, start_level, 
	     sound_flag, max_lives);
      if (*random_mode)
	*start_level = rand() % LEVEL_MAX;

      fclose (fp);

      return_value = 0;
    }
  
  return(return_value);
}



void save_setup(/*label,*/ num_player, num_disp, display, ps, max_victories,
		       random_mode, start_level, sound_flag, max_lives)
/*     char *label;*/
     int num_player, num_disp;
     char *display[MAX_PLAYER];
     BMPlayer *ps;
     int max_victories, random_mode, start_level, sound_flag, max_lives;
{
  FILE *fp;
  char *home,*ptr;
  char zeile[200],filename[200];
  int i;

  if ( (home = getenv("HOME")) == NULL )
    home = def_home;
  
  strcpy( filename, home );
  strcat( filename, setup_file );
  
  if ( (fp = fopen(filename,"w")) == NULL)
    {
      printf("WARNING: Couldn't open file %s!\n",filename);
    }
  else
    {
      fprintf(fp,"setup\n");

      fprintf(fp,"%d %d\n",num_player,num_disp);
      for (i=0; i< num_player; i++)
	fprintf(fp,"%s\n",ps[i].name);

      for (i=0; i< num_disp; i++)
	if (display[i] != NULL)
	  fprintf(fp,"%s\n",display[i]);
	else
	  fprintf(fp,"%s\n",getenv("DISPLAY"));

      fprintf(fp,"%d %d %d %d %d\n",max_victories, random_mode, start_level, 
	     sound_flag, max_lives);

      fclose (fp);
    }
}



void interactive_setup(num_player, num_disp, display, ps, max_victories,
		       random_mode, start_level, sound_flag, max_lives)
     int *num_player, *num_disp;
     char *display[MAX_PLAYER];
     BMPlayer *ps;
     int *max_victories, *random_mode, *start_level, *sound_flag, *max_lives;
     
{
  static char zeile[200];
  char *ptr;
  int i;
  int flag;

  printf("\n");
  printf("XBlast - Interactive Setup!\n");

  do 
    {
      printf("Load old setup (y/n)? ");
      scanf("%s",zeile);
    }
  while ( (zeile[0]!='y') && (zeile[0]!='n') );

  flag = TRUE;

  if(zeile[0]=='y')
    {
      flag = load_setup(num_player, num_disp, display, ps, max_victories,
			random_mode, start_level, sound_flag, max_lives);
    }

  if (flag)
    {
      if (zeile[0]=='y')
	*sound_flag = TRUE;
      else
	*sound_flag = FALSE;
      /* First the  number of players */
      do 
	{
	  printf("How many players [2-4]? ");
	  scanf("%d",num_player);
	}
      while ( (*num_player < 2) || (*num_player > MAX_PLAYER) );
      
      /* number of displays */
      do
	{
	  printf("How many displays [%d-%d]? ",(*num_player+1)/2 ,*num_player);
	  scanf("%d",num_disp);
	}
      while ( ( *num_disp > *num_player) || ( (*num_disp *2) < *num_player) ) ;
      
      for (i=0; i < *num_player; i++)
	{
	  printf("Name of player [%d](display %d)? ",i+1,i % *num_disp + 1);
	  scanf("%s",zeile);
	  ptr = (char *)malloc( (strlen(zeile)+1)*sizeof(char) );
	  strcpy(ptr, zeile);
	  ps[i].name = ptr;
	}
      
      if ( ( getenv("DISPLAY")==NULL ) 
	  ||  ( strlen(getenv("DISPLAY")) == 0 ) )
	{
	  printf("Your display? ");
	  scanf("%s",zeile);
	  ptr = (char *)malloc( (strlen(zeile)+1)*sizeof(char) );
	  strcpy(ptr, zeile);
	  display[0] = ptr;
	}
      else
	{
	  display[0]=NULL;
	  printf("Your Display is %s\n",getenv("DISPLAY"));
	}
      
      /* name displays */
      for (i=1; i < *num_disp; i++)
	{
	  printf("Other display [%d]? ",i+1);
	  scanf("%s",zeile);
	  ptr = (char *)malloc( (strlen(zeile)+1)*sizeof(char) );
	  strcpy(ptr, zeile);
	  display[i] = ptr;
	}
      
      
      /* number of victorires */
      do
	{
	  printf("Number of victories [%d-%d]? ",1,MAX_VICTORIES);
	  scanf("%d",max_victories);
	}
      while( (*max_victories<1) || (*max_victories>MAX_VICTORIES) );
      

      /* number of lifes */

      do
	{
	  printf("Number of lifes [%d-%d]? ",1,MAX_LIVES);
	  scanf("%d",max_lives);
	}
      while( (*max_lives<1) || (*max_lives>MAX_LIVES) );
      

      /* Random levels */
      
      do 
	{
	  printf("Random level order (y/n)? ");
	  scanf("%s",zeile);
	}
      while ( (zeile[0]!='y') && (zeile[0]!='n') );
      
      if (zeile[0]=='y')
	{
	  *random_mode = TRUE;
	  *start_level = rand() % LEVEL_MAX;
	}
      else
	{
	  *random_mode = FALSE;
	  do
	    {
	      printf("Starting level [1-%d]? ",LEVEL_MAX);
	      scanf("%d",start_level);
	    }
	  while ( (*start_level<1) || (*start_level > LEVEL_MAX) );
	  (*start_level) --;
	}
      
      do 
	{
	  printf("Sound (y/n)? ");
	  scanf("%s",zeile);
	}
      while ( (zeile[0]!='y') && (zeile[0]!='n') );
      
      if (zeile[0]=='y')
	*sound_flag = TRUE;
      else
	*sound_flag = FALSE;
      

      do 
	{
	  printf("Save setup (y/n)? ");
	  scanf("%s",zeile);
	}
      while ( (zeile[0]!='y') && (zeile[0]!='n') );

      if(zeile[0]=='y')
	save_setup(*num_player, *num_disp, display, ps, *max_victories,
		   *random_mode, *start_level, *sound_flag, *max_lives);
      
    }
}





