#include "struct.h"
#include "defs.h"
#include "paths.h"
#include "data.h"
#include "proto.h"

#define MAXPATH 50

int paths[NUMPATHS][MAXPATH][2] = {
    { /* PEELLEFT = 0*/
	0, 3,
	15,3,
	14,3,
	13,3,
	12,3,
	11,3,
	10,3,
	9,3,
	8,3,
	-1,-1,
    },
    { /* PEELRIGHT = 1 */
	0,3,
	1,3,
	2,3,
	3,3,
	4,3,
	5,3,
	6,3,
	7,3,
	8,3,
	-1,-1,
    },
    { /* LOOP = 2 */
	8,2,
	9,2,
	10,2,
	11,2,
	12,2,
	13,2,
	14,2,
	15,2,
	0,2,
	1,2,
	2,2,
	3,2,
	4,2,
	5,2,
	6,2,
	7,2,
	8,2,
	-1,-1,
    },
    { /* SWOOP1 = 3 */
	8,20,
	9,3,
	10,3,
	11,3,
	12,3,
	-1,-1,
    },
    { /* SWOOP2 = 4 */
	8,20,
	7,3,
	6,3,
	5,3,
	4,3,
	-1,-1,
    },
    { /* ZIGZAG = 5 */
	7,15,	8,2,
	9,15,	8,2,
	7,15,	8,2,
	9,15,   8,2,
	-1,-1,
    },
    { /* LOOP2 = 6 */
	8,2, 7,2, 6,2, 5,2, 4,2, 3,2, 2,2, 1,2, 0,2, 15,2, 14,2, 13,2, 12,2, 11,2, 10,2, 9,2, 8,2,
	-1,-1,
    },
    { /* SPIN = 7 */
	8,1, 7,1, 6,1, 5,1, 4,1, 3,1, 2,1, 1,1, 0,1, 15,1, 14,1, 13,1, 12,1, 11,1, 10,1, 9,1, 8,1,
	-1,-1,
    },
    { /* LEFTDIAG */
	8,2,
	9,2,
	10,30,
	9,2,
	8,1,
	-1,-1,
    },
    { /* RIGHTDIAG */
	8,2,
	7,2,
	6,30,
	7,2,
	8,1,
	-1,-1,
    },
    { /* ENTER1 */
	8,65, 9,5, 10,5, 11,5, 12,5, 13,5, 14,20, -1,-1,
    },	  
    { /* ENTER2 */
	8,65, 7,5, 6,5, 5,5, 4,5, 3,5, 2,20, -1,-1,
    },
	    /* ENTER3 */
    {-1,-1},
    /* ENTER4 */
    { 10,45, 11,5, 12,20, 13,5, 14,10, -1,-1, },
    /* ENTER5 */
    { 6,45, 5,5, 4,20, 3,5, 2,10, -1,-1, },
    /* ENTER6 */
    { 8,80, 6,10, 4,40, 0,20, 14,30, -1,-1},
    /* ENTER7 */
    { 8,80, 10,10, 12,40, 0,20, 2,30, -1,-1},
    /* ENTER8 */
    { 0,50, 2,50, 3,5, 4,5, 5,5, 6,5, 7,5, 8,5, 9,5, 10,5, 11,5, 12,30, 13,5, 14,5, 15,5, 0,5, -1,-1},
    /* ENTER9 */
    { 0,50, 14,50, 13,5, 12,5, 11,5, 10,5, 9,5, 8,5, 7,5, 6,5, 5,5, 4,30, 3,5, 2,5, 1,5, 0,5, -1,-1},
    /* ENTER10 */
    { 4,80, 10,30, 0,70, -1,-1 },
    /* ENTER11 */
    { 12,80, 6,30, 0,70, -1,-1 },
    /* ENTER12 */
    { 14,80, -1, -1},
    /* ENTER13 */
    { 2,80, -1,-1},
    /* ENTER14 */									     
    { 4,8, 3,6, 2,8, 1,10, 2,8, 3,6, 4,4, 5,6, 6,8, 7,10, 6,8, 5,6, 4,4, 3,6, 2,8, 1,10, 0,20, -1,-1},
    /* 15 */
    { 12,60, 11,3, 10,3, 9,3, 8,3, 7,3, 6,3, 5,3, 4,3, 3,3, 2,3, 1,3, 0,3,	
	  15,3, 14,3, 13,3, 12,3, 11,3, 10,3, 9,3, 8,3, 7,3, 6,3, 5,3, 4,3, 3,3, 2,3, 1,3, 0,3,		
	  15,3, 14,3, 13,3, 12,3, 11,3, 10,3, 9,3, 8,3, 7,3, 6,3, 5,3, 4,3, 3,3, 2,3, 1,3, 0,20, -1,-1},	
    /* 16 */
    { 4,60, 5,3, 6,3, 7,3, 8,3, 9,3, 10,3, 11,3, 12,3, 13,3, 14,3, 15,3, 0,3,
	  1,3, 2,3, 3,3, 4,3, 5,3, 6,3, 7,3, 8,3, 9,3, 10,3, 11,3, 12,3, 13,3, 14,3, 15,3, 0,3,
	  1,3, 2,3, 3,3, 4,3, 5,3, 6,3, 7,3, 8,3, 9,3, 10,3, 11,3, 12,3, 13,3, 14,3, 15,3, 0,20, -1, -1},
    /* 17 */
    {
	7,15,	8,3,
	9,15,	8,3,
	7,15,	8,3,
	9,15,   8,3,
	7,15,	8,3,
	9,15,	8,3,
	-1,-1,	  
    },
    /* 18 */
    { 12,60, 4,30, 12,30, 4,30, 12,30, 8,20, -1,-1 },
    /* 19 */
    { 10,80, -1,-1, },
    /* 20 */
    { 6,80, -1,-1, },
};	

/* enter_paths are for new ships.  consists of starting co-ordinates, number of frames
   to wait at the start (presumably offscreen) and a path to follow.
   path -1 means this ship is not used on this level
   at end of path, ship flies into convoy position on it's own from wherever it winds up
*/

struct enter_path {
    int shape, x, y, delay, path;
};

/* Not that anyone else is likely to touch this mess, but if you do, I highly recommend doing it
   in emacs M-x picture-mode. */

struct enter_path ep[NUMLEVELS][MAXALIENS] = {
    {	
	{ 0, -1, -1, -1, -1},
	{ 0, -1, -1, -1, -1},
	{ 0, -1, -1, -1, -1},
	{ 0, 200, -30, 435, P_ENTER1 },
	{ 0, -1, -1, -1, -1},
	{ 0, -1, -1, -1, -1},
	{ 0, 200, -30, 430, P_ENTER2 },
	{ 0, -1, -1, -1, -1},
	{ 0, -1, -1, -1, -1},
	{ 0, -1, -1, -1, -1},
	  
	{ 1, -1, -1, -1, -1},
	{ 1, -1, -1, -1, -1},
	{ 1, 200, -30,425, P_ENTER1 },
	{ 1, 200, -30,420, P_ENTER2 },
	{ 1, 200, -30,415, P_ENTER1 },
	{ 1, 200, -30,410, P_ENTER2 },
	{ 1, 200, -30,405, P_ENTER1 },
	{ 1, 200, -30,400, P_ENTER2 },
	{ 1, -1, -1, -1, -1},
	{ 1, -1, -1, -1, -1},
	             
	{ 2, 200, -30,345, P_ENTER1 },
	{ 2, 200, -30,340,P_ENTER2 },
	{ 2, 200, -30,335, P_ENTER1 },
	{ 2, 200, -30,330, P_ENTER2 },
	{ 2, 200, -30,325, P_ENTER1 },
	{ 2, 200, -30,320, P_ENTER2 },
	{ 2, 200, -30,315, P_ENTER1 },
	{ 2, 200, -30,310, P_ENTER2 },
	{ 2, 200, -30,305, P_ENTER1 },
	{ 2, 200, -30,300, P_ENTER2 },
	              
	{ 3, 200, -30,245, P_ENTER1 },
	{ 3, 200, -30,240, P_ENTER2 },
	{ 3, 200, -30,235, P_ENTER1 },
	{ 3, 200, -30,230, P_ENTER2 },
	{ 3, 200, -30,225, P_ENTER1 },
	{ 3, 200, -30,220, P_ENTER2 },
	{ 3, 200, -30,215, P_ENTER1 },
	{ 3, 200, -30,210, P_ENTER2 },
	{ 3, 200, -30,205, P_ENTER1 },
	{ 3, 200, -30,200, P_ENTER2 },
	             
	{ 4, 200, -30,145, P_ENTER1 },
	{ 4, 200, -30,140, P_ENTER2 },
	{ 4, 200, -30,135, P_ENTER1 },
	{ 4, 200, -30,130, P_ENTER2 },
	{ 4, 200, -30,125, P_ENTER1 },
	{ 4, 200, -30,120, P_ENTER2 },
	{ 4, 200, -30,115, P_ENTER1 },
	{ 4, 200, -30,110, P_ENTER2 },
	{ 4, 200, -30,105, P_ENTER1 },
	{ 4, 200, -30,100, P_ENTER2 },
	             
	{ 5, 200, -30, 50, P_ENTER1 },
	{ 5, 200, -30, 45, P_ENTER2 },
	{ 5, 200, -30, 40, P_ENTER1 },
	{ 5, 200, -30, 35, P_ENTER2 },
	{ 5, 200, -30, 30, P_ENTER1 },
	{ 5, 200, -30, 25, P_ENTER2 },
	{ 5, 200, -30, 20, P_ENTER1 },
	{ 5, 200, -30, 15, P_ENTER2 },
	{ 5, 200, -30, 10, P_ENTER1 },
	{ 5, 200, -30,  5, P_ENTER2 },
	  
    },
    {
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, 200,  -30, 435, P_ENTER1 },
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0,  -1,   -1,  -1, -1},
	{ 0, 200,  -30, 430, P_ENTER2 },
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},

	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},
	{ 1, 200,  -30, 425, P_ENTER1 },
	{ 1, 200,  -30, 420, P_ENTER2 },
	{ 1, 200,  -30, 415, P_ENTER1 },
	{ 1, 200,  -30, 410, P_ENTER2 },
	{ 1, 200,  -30, 405, P_ENTER1 },
	{ 1, 200,  -30, 400, P_ENTER2 },
	{ 1,  -1,   -1,  -1, -1},	 
	{ 1,  -1,   -1,  -1, -1},
	             
	{ 2, 410,  125, 345, P_ENTER4 },
	{ 2, 410,  125, 340, P_ENTER4 },
	{ 2, 410,  125, 335, P_ENTER4 },
	{ 2, 410,  125, 330, P_ENTER4 },
	{ 2, 410,  125, 325, P_ENTER4 },
	{ 2, 410,  125, 320, P_ENTER4 },
	{ 2, 410,  125, 315, P_ENTER4 },
	{ 2, 410,  125, 310, P_ENTER4 },
	{ 2, 410,  125, 305, P_ENTER4 },
	{ 2, 410,  125, 300, P_ENTER4 },
	               		 
	{ 3, -30,  125, 245, P_ENTER5 },
	{ 3, -30,  125, 240, P_ENTER5 },
	{ 3, -30,  125, 235, P_ENTER5 },
	{ 3, -30,  125, 230, P_ENTER5 },
	{ 3, -30,  125, 225, P_ENTER5 },
	{ 3, -30,  125, 220, P_ENTER5 },
	{ 3, -30,  125, 215, P_ENTER5 },
	{ 3, -30,  125, 210, P_ENTER5 },
	{ 3, -30,  125, 205, P_ENTER5 },
	{ 3, -30,  125, 200, P_ENTER5 },
	              		 
	{ 4, 410,  125, 145, P_ENTER4 },
	{ 4, 410,  125, 140, P_ENTER4 },
	{ 4, 410,  125, 135, P_ENTER4 },
	{ 4, 410,  125, 130, P_ENTER4 },
	{ 4, 410,  125, 125, P_ENTER4 },
	{ 4, 410,  125, 120, P_ENTER4 },
	{ 4, 410,  125, 115, P_ENTER4 },
	{ 4, 410,  125, 110, P_ENTER4 },
	{ 4, 410,  125, 105, P_ENTER4 },
	{ 4, 410,  125, 100, P_ENTER4 },
	              		 
	{ 6, -30,  125,  50, P_ENTER5 },
	{ 6, -30,  125,  45, P_ENTER5 },
	{ 6, -30,  125,  40, P_ENTER5 },
	{ 6, -30,  125,  35, P_ENTER5 },
	{ 6, -30,  125,  30, P_ENTER5 },
	{ 6, -30,  125,  25, P_ENTER5 },
	{ 6, -30,  125,  20, P_ENTER5 },
	{ 6, -30,  125,  15, P_ENTER5 },
	{ 6, -30,  125,  10, P_ENTER5 },
	{ 6, -30,  125,   5, P_ENTER5 },
	        		 
    },
    { /* level 3*/
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, -30,  125, 405, P_ENTER5 },
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0,  -1,   -1,  -1, -1},
	{ 0, -30,  125, 400, P_ENTER5 },
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},

	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},
	{ 1, -30,  125, 435, P_ENTER5 },
	{ 1, -30,  125, 430, P_ENTER5 },
	{ 1, -30,  125, 425, P_ENTER5 },
	{ 1, -30,  125, 420, P_ENTER5 },
	{ 1, -30,  125, 415, P_ENTER5 },
	{ 1, -30,  125, 410, P_ENTER5 },
	{ 1,  -1,   -1,  -1, -1},	 
	{ 1,  -1,   -1,  -1, -1},
	             	  
	{ 2, 100,  -30, 345, P_ENTER6 },
	{ 2, 300,  -30, 340, P_ENTER7 },
	{ 2, 100,  -30, 335, P_ENTER6 },
	{ 2, 300,  -30, 330, P_ENTER7 },
	{ 2, 100,  -30, 325, P_ENTER6 },
	{ 2, 300,  -30, 320, P_ENTER7 },
	{ 2, 100,  -30, 315, P_ENTER6 },
	{ 2, 300,  -30, 310, P_ENTER7 },
	{ 2, 100,  -30, 305, P_ENTER6 },
	{ 2, 300,  -30, 300, P_ENTER7 },
/*--*/  { 6, 100,  -30, 245, P_ENTER6 },
	{ 6, 300,  -30, 240, P_ENTER7 },
	{ 6, 100,  -30, 235, P_ENTER6 },
	{ 6, 300,  -30, 230, P_ENTER7 },
	{ 6, 100,  -30, 225, P_ENTER6 },
	{ 6, 300,  -30, 220, P_ENTER7 },
	{ 6, 100,  -30, 215, P_ENTER6 },
	{ 6, 300,  -30, 210, P_ENTER7 },
	{ 6, 100,  -30, 205, P_ENTER6 },
	{ 6, 300,  -30, 200, P_ENTER7 },
/*--*/  { 7, 100,  -30, 145, P_ENTER6 },
	{ 7, 300,  -30, 140, P_ENTER7 },
	{ 7, 100,  -30, 135, P_ENTER6 },
	{ 7, 300,  -30, 130, P_ENTER7 },
	{ 7, 100,  -30, 125, P_ENTER6 },
	{ 7, 300,  -30, 120, P_ENTER7 },
	{ 7, 100,  -30, 115, P_ENTER6 },
	{ 7, 300,  -30, 110, P_ENTER7 },
	{ 7, 100,  -30, 105, P_ENTER6 },
	{ 7, 300,  -30, 100, P_ENTER7 },
/*--*/  { 7, 100,  -30,  45, P_ENTER6 },
	{ 7, 300,  -30,  40, P_ENTER7 },
	{ 7, 100,  -30,  35, P_ENTER6 },
	{ 7, 300,  -30,  30, P_ENTER7 },
	{ 7, 100,  -30,  25, P_ENTER6 },
	{ 7, 300,  -30,  20, P_ENTER7 },
	{ 7, 100,  -30,  15, P_ENTER6 },
	{ 7, 300,  -30,  10, P_ENTER7 },
	{ 7, 100,  -30,   5, P_ENTER6 },
	{ 7, 300,  -30,   0, P_ENTER7 },
	                	 
    },
    { /*level 4*/
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, 100,  530, 405, P_ENTER8 },
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0, 100,  530, 400, P_ENTER8 },
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},

	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},
	{ 1, 100,  530, 435, P_ENTER8 },
	{ 1, 100,  530, 430, P_ENTER8 },
	{ 1, 100,  530, 425, P_ENTER8 },
	{ 1, 100,  530, 420, P_ENTER8 },
	{ 1, 100,  530, 415, P_ENTER8 },
	{ 1, 100,  530, 410, P_ENTER8 },
	{ 1,  -1,   -1,  -1, -1},	  
	{ 1,  -1,   -1,  -1, -1},
	               	
	{ 2, 430,  530, 345, P_ENTER12},
	{ 2, 430,  530, 340, P_ENTER12},
	{ 2, 430,  530, 335, P_ENTER12},
	{ 2, 430,  530, 330, P_ENTER12},
	{ 2, 430,  530, 325, P_ENTER12},
	{ 2, 430,  530, 320, P_ENTER12},
	{ 2, 430,  530, 315, P_ENTER12},
	{ 2, 430,  530, 310, P_ENTER12},
	{ 2, 430,  530, 305, P_ENTER12},
	{ 2, 430,  530, 300, P_ENTER12},
/*--*/  { 3, -30,  530, 245, P_ENTER13},
	{ 3, -30,  530, 240, P_ENTER13},
	{ 3, -30,  530, 235, P_ENTER13},
	{ 3, -30,  530, 230, P_ENTER13},
	{ 3, -30,  530, 225, P_ENTER13},
	{ 3, -30,  530, 220, P_ENTER13},
	{ 3, -30,  530, 215, P_ENTER13},
	{ 3, -30,  530, 210, P_ENTER13},
	{ 3, -30,  530, 205, P_ENTER13},
	{ 3, -30,  530, 200, P_ENTER13},
/*--*/  { 7, -30,  250, 145, P_ENTER16},
	{ 7, -30,  250, 140, P_ENTER16},
	{ 7, -30,  250, 135, P_ENTER16},
	{ 7, -30,  250, 130, P_ENTER16},
	{ 7, -30,  250, 125, P_ENTER16},
	{ 7, -30,  250, 120, P_ENTER16},
	{ 7, -30,  250, 115, P_ENTER16},
	{ 7, -30,  250, 110, P_ENTER16},
	{ 7, -30,  250, 105, P_ENTER16},
	{ 7, -30,  250, 100, P_ENTER16},
/*--*/  { 7, 430,  250,  45, P_ENTER15},
	{ 7, 430,  250,  40, P_ENTER15},
	{ 7, 430,  250,  35, P_ENTER15},
	{ 7, 430,  250,  30, P_ENTER15},
	{ 7, 430,  250,  25, P_ENTER15},
	{ 7, 430,  250,  20, P_ENTER15},
	{ 7, 430,  250,  15, P_ENTER15},
	{ 7, 430,  250,  10, P_ENTER15},
	{ 7, 430,  250,   5, P_ENTER15},
	{ 7, 430,  250,   0, P_ENTER15},
	                	 
    },
    { /*level 5*/
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, 100,  530, 405, P_ENTER8 },
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0, 100,  530, 400, P_ENTER8 },
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},

	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},
	{ 1, 100,  530, 435, P_ENTER8 },
	{ 1, 100,  530, 430, P_ENTER8 },
	{ 1, 100,  530, 425, P_ENTER8 },
	{ 1, 100,  530, 420, P_ENTER8 },
	{ 1, 100,  530, 415, P_ENTER8 },
	{ 1, 100,  530, 410, P_ENTER8 },
	{ 1,  -1,   -1,  -1, -1},	  
	{ 1,  -1,   -1,  -1, -1},
	               	
	{ 2, 430,  530, 345, P_ENTER12},
	{ 2, 430,  530, 340, P_ENTER12},
	{ 2, 430,  530, 335, P_ENTER12},
	{ 2, 430,  530, 330, P_ENTER12},
	{ 2, 430,  530, 325, P_ENTER12},
	{ 2, 430,  530, 320, P_ENTER12},
	{ 2, 430,  530, 315, P_ENTER12},
	{ 2, 430,  530, 310, P_ENTER12},
	{ 2, 430,  530, 305, P_ENTER12},
	{ 2, 430,  530, 300, P_ENTER12},
/*--*/  { 3, -30,  530, 245, P_ENTER13},
	{ 3, -30,  530, 240, P_ENTER13},
	{ 3, -30,  530, 235, P_ENTER13},
	{ 3, -30,  530, 230, P_ENTER13},
	{ 3, -30,  530, 225, P_ENTER13},
	{ 3, -30,  530, 220, P_ENTER13},
	{ 3, -30,  530, 215, P_ENTER13},
	{ 3, -30,  530, 210, P_ENTER13},
	{ 3, -30,  530, 205, P_ENTER13},
	{ 3, -30,  530, 200, P_ENTER13},
/*--*/  { 7, 100,  530, 140, P_ENTER8 },
	{ 7, 300,  530, 140, P_ENTER9 },
	{ 7, 100,  530, 130, P_ENTER8 },
	{ 7, 300,  530, 130, P_ENTER9 },
	{ 7, 100,  530, 120, P_ENTER8 },
	{ 7, 300,  530, 120, P_ENTER9 },
	{ 7, 100,  530, 110, P_ENTER8 },
	{ 7, 300,  530, 110, P_ENTER9 },
	{ 7, 100,  530, 100, P_ENTER8 },
	{ 7, 300,  530, 100, P_ENTER9 },
/*--*/  { 7, 200,  -30,  45, P_ENTER1 },
	{ 7, 200,  -30,  40, P_ENTER2 },
	{ 7, 200,  -30,  35, P_ENTER1 },
	{ 7, 200,  -30,  30, P_ENTER2 },
	{ 7, 200,  -30,  25, P_ENTER1 },
	{ 7, 200,  -30,  20, P_ENTER2 },
	{ 7, 200,  -30,  15, P_ENTER1 },
	{ 7, 200,  -30,  10, P_ENTER2 },
	{ 7, 200,  -30,   5, P_ENTER1 },
	{ 7, 200,  -30,   0, P_ENTER2 },
	                	 
    },
    { /*level 6*/
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},    
	{ 0, -30,  350, 405, P_ENTER14},
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},        
	{ 0, -30,  350, 400, P_ENTER14},
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},

	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},    
	{ 1, -30,  350, 435, P_ENTER14},
	{ 1, -30,  350, 430, P_ENTER14},
	{ 1, -30,  350, 425, P_ENTER14},
	{ 1, -30,  350, 420, P_ENTER14},
	{ 1, -30,  350, 415, P_ENTER14},
	{ 1, -30,  350, 410, P_ENTER14},
	{ 1,  -1,   -1,  -1, -1},	  
	{ 1,  -1,   -1,  -1, -1},
	               	
	{ 2, 430,  530, 345, P_ENTER12},
	{ 2, 430,  530, 340, P_ENTER12},
	{ 2, 430,  530, 335, P_ENTER12},
	{ 2, 430,  530, 330, P_ENTER12},
	{ 2, 430,  530, 325, P_ENTER12},
	{ 2, 430,  530, 320, P_ENTER12},
	{ 2, 430,  530, 315, P_ENTER12},
	{ 2, 430,  530, 310, P_ENTER12},
	{ 2, 430,  530, 305, P_ENTER12},
	{ 2, 430,  530, 300, P_ENTER12},
/*--*/  { 6, -30,  530, 245, P_ENTER13},
	{ 6, -30,  530, 240, P_ENTER13},
	{ 6, -30,  530, 235, P_ENTER13},
	{ 6, -30,  530, 230, P_ENTER13},
	{ 6, -30,  530, 225, P_ENTER13},
	{ 6, -30,  530, 220, P_ENTER13},
	{ 6, -30,  530, 215, P_ENTER13},
	{ 6, -30,  530, 210, P_ENTER13},
	{ 6, -30,  530, 205, P_ENTER13},
	{ 6, -30,  530, 200, P_ENTER13},
/*--*/  { 7, 100,  530, 145, P_ENTER8 },
	{ 7, 100,  530, 140, P_ENTER8 },
	{ 7, 100,  530, 135, P_ENTER8 },
	{ 7, 100,  530, 130, P_ENTER8 },
	{ 7, 100,  530, 125, P_ENTER8 },
	{ 7, 100,  530, 120, P_ENTER8 },
	{ 7, 100,  530, 115, P_ENTER8 },
	{ 7, 100,  530, 110, P_ENTER8 },
	{ 7, 100,  530, 105, P_ENTER8 },
	{ 7, 100,  530, 100, P_ENTER8 },
/*--*/  { 7, -30,  250,  45, P_ENTER14},
	{ 7, -30,  250,  40, P_ENTER14},
	{ 7, -30,  250,  35, P_ENTER14},
	{ 7, -30,  250,  30, P_ENTER14},
	{ 7, -30,  250,  25, P_ENTER14},
	{ 7, -30,  250,  20, P_ENTER14},
	{ 7, -30,  250,  15, P_ENTER14},
	{ 7, -30,  250,  10, P_ENTER14},
	{ 7, -30,  250,   5, P_ENTER14},
	{ 7, -30,  250,   0, P_ENTER14},	                	     
    },

    { /* level 7 */
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, -30,  250, 406, P_ENTER10},
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0, 430,  250, 400, P_ENTER11},
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},

	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},
	{ 1, -30,  250, 435, P_ENTER10},
	{ 1, 430,  250, 430, P_ENTER11},
	{ 1, -30,  250, 425, P_ENTER10},
	{ 1, 430,  250, 420, P_ENTER11},
	{ 1, -30,  250, 415, P_ENTER10},
	{ 1, 430,  250, 410, P_ENTER11},
	{ 1,  -1,   -1,  -1, -1},	  
	{ 1,  -1,   -1,  -1, -1},
	             	
	{ 2, 100,  530, 340, P_ENTER8 },
	{ 2, 300,  530, 340, P_ENTER9 },
	{ 2, 100,  530, 330, P_ENTER8 },
	{ 2, 300,  530, 330, P_ENTER9 },
	{ 2, 100,  530, 320, P_ENTER8 },
	{ 2, 300,  530, 320, P_ENTER9 },
	{ 2, 100,  530, 310, P_ENTER8 },
	{ 2, 300,  530, 310, P_ENTER9 },
	{ 2, 100,  530, 300, P_ENTER8 },
	{ 2, 300,  530, 300, P_ENTER9 },
/*--*/  { 3, 100,  530, 240, P_ENTER8 },
	{ 3, 300,  530, 240, P_ENTER9 },
	{ 3, 100,  530, 230, P_ENTER8 },
	{ 3, 300,  530, 230, P_ENTER9 },
	{ 3, 100,  530, 220, P_ENTER8 },
	{ 3, 300,  530, 220, P_ENTER9 },
	{ 3, 100,  530, 210, P_ENTER8 },
	{ 3, 300,  530, 210, P_ENTER9 },
	{ 3, 100,  530, 200, P_ENTER8 },
	{ 3, 300,  530, 200, P_ENTER9 },
/*--*/  { 6, 100,  530, 140, P_ENTER8 },
	{ 6, 300,  530, 140, P_ENTER9 },
	{ 6, 100,  530, 130, P_ENTER8 },
	{ 6, 300,  530, 130, P_ENTER9 },
	{ 6, 100,  530, 120, P_ENTER8 },
	{ 6, 300,  530, 120, P_ENTER9 },
	{ 6, 100,  530, 110, P_ENTER8 },
	{ 6, 300,  530, 110, P_ENTER9 },
	{ 6, 100,  530, 100, P_ENTER8 },
	{ 6, 300,  530, 100, P_ENTER9 },
/*--*/  { 6, 100,  530,  40, P_ENTER8 },
	{ 6, 300,  530,  40, P_ENTER9 },
	{ 6, 100,  530,  30, P_ENTER8 },
	{ 6, 300,  530,  30, P_ENTER9 },
	{ 6, 100,  530,  20, P_ENTER8 },
	{ 6, 300,  530,  20, P_ENTER9 },
	{ 6, 100,  530,  10, P_ENTER8 },
	{ 6, 300,  530,  10, P_ENTER9 },
	{ 6, 100,  530,   0, P_ENTER8 },
	{ 6, 300,  530,   0, P_ENTER9 },
	                	 
    },
    { /* level 8 */
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, -30,  250, 405, P_ENTER16},
	{ 0,  -1,   -1,  -1, -1},         
	{ 0,  -1,   -1,  -1, -1},        
	{ 0, -30,  250, 400, P_ENTER16},
	{ 0,  -1,   -1,  -1, -1},         
	{ 0,  -1,   -1,  -1, -1},     
	{ 0,  -1,   -1,  -1, -1},     
				      
	{ 1,  -1,   -1,  -1, -1},     
	{ 1,  -1,   -1,  -1, -1},     
	{ 1, -30,  250, 435, P_ENTER16},
	{ 1, -30,  250, 430, P_ENTER16},
	{ 1, -30,  250, 425, P_ENTER16},
	{ 1, -30,  250, 420, P_ENTER16},
	{ 1, -30,  250, 415, P_ENTER16},
	{ 1, -30,  250, 410, P_ENTER16},
	{ 1,  -1,   -1,  -1, -1},         
	{ 1,  -1,   -1,  -1, -1},
	             	
	{ 6, -30,  530, 340, P_ENTER13},
	{ 6, 430,  530, 340, P_ENTER12},
	{ 6, -30,  530, 330, P_ENTER13},
	{ 6, 430,  530, 330, P_ENTER12},
	{ 6, -30,  530, 320, P_ENTER13},
	{ 6, 430,  530, 320, P_ENTER12},
	{ 6, -30,  530, 310, P_ENTER13},
	{ 6, 430,  530, 310, P_ENTER12},
	{ 6, -30,  530, 300, P_ENTER13},
	{ 6, 430,  530, 300, P_ENTER12},
/*--*/  { 7, 200,  -30, 245, P_ENTER2 },
	{ 7, 200,  -30, 240, P_ENTER2 },
	{ 7, 200,  -30, 235, P_ENTER2 },
	{ 7, 200,  -30, 230, P_ENTER2 },
	{ 7, 200,  -30, 225, P_ENTER2 },
	{ 7, 200,  -30, 220, P_ENTER2 },
	{ 7, 200,  -30, 215, P_ENTER2 },
	{ 7, 200,  -30, 210, P_ENTER2 },
	{ 7, 200,  -30, 205, P_ENTER2 },
	{ 7, 200,  -30, 200, P_ENTER2 },
/*--*/  { 8, 200,  -30,  95, P_ENTER17},
	{ 8, 200,  -30,  90, P_ENTER17},
	{ 8, 200,  -30,  85, P_ENTER17},
	{ 8, 200,  -30,  80, P_ENTER17},
	{ 8, 200,  -30,  75, P_ENTER17},
	{ 8, 200,  -30,  70, P_ENTER17},
	{ 8, 200,  -30,  65, P_ENTER17},
	{ 8, 200,  -30,  60, P_ENTER17},
	{ 8, 200,  -30,  55, P_ENTER17},
	{ 8, 200,  -30,  50, P_ENTER17},
/*--*/  { 8, 200,  -30,  45, P_ENTER17},
	{ 8, 200,  -30,  40, P_ENTER17},
	{ 8, 200,  -30,  35, P_ENTER17},
	{ 8, 200,  -30,  30, P_ENTER17},
	{ 8, 200,  -30,  25, P_ENTER17},
	{ 8, 200,  -30,  20, P_ENTER17},
	{ 8, 200,  -30,  15, P_ENTER17},
	{ 8, 200,  -30,  10, P_ENTER17},
	{ 8, 200,  -30,   5, P_ENTER17},
	{ 8, 200,  -30,   0, P_ENTER17},
	                	 
    },
    { /* level 9 */
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, -30,  250, 405, P_ENTER16},
	{ 0,  -1,   -1,  -1, -1},         
	{ 0,  -1,   -1,  -1, -1},        
	{ 0, -30,  250, 400, P_ENTER16},
	{ 0,  -1,   -1,  -1, -1},         
	{ 0,  -1,   -1,  -1, -1},     
	{ 0,  -1,   -1,  -1, -1},     
	        		      
	{ 1,  -1,   -1,  -1, -1},     
	{ 1,  -1,   -1,  -1, -1},     
	{ 1, -30,  250, 435, P_ENTER16},
	{ 1, -30,  250, 430, P_ENTER16},
	{ 1, -30,  250, 425, P_ENTER16},
	{ 1, -30,  250, 420, P_ENTER16},
	{ 1, -30,  250, 415, P_ENTER16},
	{ 1, -30,  250, 410, P_ENTER16},
	{ 1,  -1,   -1,  -1, -1},         
	{ 1,  -1,   -1,  -1, -1},
	             	
	{ 6, 100,  530, 340, P_ENTER8 },
	{ 6, 300,  530, 340, P_ENTER9 },
	{ 6, 100,  530, 330, P_ENTER8 },
	{ 6, 300,  530, 330, P_ENTER9 },
	{ 6, 100,  530, 320, P_ENTER8 },
	{ 6, 300,  530, 320, P_ENTER9 },
	{ 6, 100,  530, 310, P_ENTER8 },
	{ 6, 300,  530, 310, P_ENTER9 },
	{ 6, 100,  530, 300, P_ENTER8 },
	{ 6, 300,  530, 300, P_ENTER9 },
/*--*/  { 7, 200,  -30, 245, P_ENTER1 },
	{ 7, 200,  -30, 240, P_ENTER1 },
	{ 7, 200,  -30, 235, P_ENTER1 },
	{ 7, 200,  -30, 230, P_ENTER1 },
	{ 7, 200,  -30, 225, P_ENTER1 },
	{ 7, 200,  -30, 220, P_ENTER1 },
	{ 7, 200,  -30, 215, P_ENTER1 },
	{ 7, 200,  -30, 210, P_ENTER1 },
	{ 7, 200,  -30, 205, P_ENTER1 },
	{ 7, 200,  -30, 200, P_ENTER1 },
/*--*/  { 8, 430,  530, 145, P_ENTER12},
	{ 8, 430,  530, 140, P_ENTER12},
	{ 8, 430,  530, 135, P_ENTER12},
	{ 8, 430,  530, 130, P_ENTER12},
	{ 8, 430,  530, 125, P_ENTER12},
	{ 8, 430,  530, 120, P_ENTER12},
	{ 8, 430,  530, 115, P_ENTER12},
	{ 8, 430,  530, 110, P_ENTER12},
	{ 8, 430,  530, 105, P_ENTER12},
	{ 8, 430,  530, 100, P_ENTER12},
/*--*/  { 9, 360,  -30,   0, P_ENTER17},/* muahaha! */ 
	{ 9, 320,  -30,   0, P_ENTER17},
	{ 9, 280,  -30,   0, P_ENTER17},
	{ 9, 240,  -30,   0, P_ENTER17},
	{ 9, 200,  -30,   0, P_ENTER17},
	{ 9, 160,  -30,   0, P_ENTER17},
	{ 9, 120,  -30,   0, P_ENTER17},
	{ 9,  80,  -30,   0, P_ENTER17},
	{ 9,  40,  -30,   0, P_ENTER17},
	{ 9,   0,  -30,   0, P_ENTER17},
	       	        	 
    },
    { /* level 10 */
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	{ 0, -30,  250, 405, P_ENTER10},
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},	 
	{ 0, 430,  250, 400, P_ENTER11},
	{ 0,  -1,   -1,  -1, -1},	  
	{ 0,  -1,   -1,  -1, -1},
	{ 0,  -1,   -1,  -1, -1},
	  
	{ 1,  -1,   -1,  -1, -1},
	{ 1,  -1,   -1,  -1, -1},
	{ 1, -30,  250, 435, P_ENTER10},
	{ 1, 430,  250, 430, P_ENTER11},
	{ 1, -30,  250, 425, P_ENTER10},
	{ 1, 430,  250, 420, P_ENTER11},
	{ 1, -30,  250, 415, P_ENTER10},
	{ 1, 430,  250, 410, P_ENTER11},
	{ 1,  -1,   -1,  -1, -1},	  
	{ 1,  -1,   -1,  -1, -1},
	             	            
	{ 7, 200,  -30, 345, P_ENTER2 },
	{ 7, 200,  -30, 340, P_ENTER1 },
	{ 7, 200,  -30, 335, P_ENTER2 },
	{ 7, 200,  -30, 330, P_ENTER1 },
	{ 7, 200,  -30, 325, P_ENTER2 },
	{ 7, 200,  -30, 320, P_ENTER1 },
	{ 7, 200,  -30, 315, P_ENTER2 },
	{ 7, 200,  -30, 310, P_ENTER1 },
	{ 7, 200,  -30, 305, P_ENTER2 },
	{ 7, 200,  -30, 300, P_ENTER1 },
/*--*/  { 8, 430,  250, 245, P_ENTER15},
	{ 8, -30,  250, 240, P_ENTER16},
	{ 8, 430,  250, 235, P_ENTER15},
	{ 8, -30,  250, 230, P_ENTER16},
	{ 8, 430,  250, 225, P_ENTER15},
	{ 8, -30,  250, 220, P_ENTER16},
	{ 8, 430,  250, 215, P_ENTER15},
	{ 8, -30,  250, 210, P_ENTER16},
	{ 8, 430,  250, 205, P_ENTER15},
	{ 8, -30,  250, 200, P_ENTER16},
/*--*/  { 9, 100,  530, 145, P_ENTER8 },
	{ 9, 300,  530, 140, P_ENTER9 },
	{ 9, 100,  530, 135, P_ENTER8 },
	{ 9, 300,  530, 130, P_ENTER9 },
	{ 9, 100,  530, 125, P_ENTER8 },
	{ 9, 300,  530, 120, P_ENTER9 },
	{ 9, 100,  530, 115, P_ENTER8 },
	{ 9, 300,  530, 110, P_ENTER9 },
	{ 9, 100,  530, 105, P_ENTER8 },
	{ 9, 300,  530, 100, P_ENTER9 },
/*--*/  {10, 430,  250,  45, P_ENTER18},
	{10, 430,  250,  40, P_ENTER18},
	{10, 430,  250,  35, P_ENTER18},
	{10, 430,  250,  30, P_ENTER18},
	{10, 430,  250,  25, P_ENTER18},
	{10, 430,  250,  20, P_ENTER18},
	{10, 430,  250,  15, P_ENTER18},
	{10, 430,  250,  10, P_ENTER18},
	{10, 430,  250,   5, P_ENTER18},
	{10, 430,  250,   0, P_ENTER18},
	                	 
    },
    { /* level 11 */
	{11,  -1,   -1,  -1, -1},
	{11,  -1,   -1,  -1, -1},
	{11,  -1,   -1,  -1, -1},
	{11, -30,  250, 405, P_ENTER10},
	{11,  -1,   -1,  -1, -1},	  
	{11,  -1,   -1,  -1, -1},	 
	{11, 430,  250, 400, P_ENTER11},
	{11,  -1,   -1,  -1, -1},	  
	{11,  -1,   -1,  -1, -1},
	{11,  -1,   -1,  -1, -1},
	  
	{12,  -1,   -1,  -1, -1},
	{12,  -1,   -1,  -1, -1},
	{12, -30,  250, 435, P_ENTER10},
	{12, 430,  250, 430, P_ENTER11},
	{12, -30,  250, 425, P_ENTER10},
	{12, 430,  250, 420, P_ENTER11},
	{12, -30,  250, 415, P_ENTER10},
	{12, 430,  250, 410, P_ENTER11},
	{12,  -1,   -1,  -1, -1},	  
	{12,  -1,   -1,  -1, -1},
	             	            
	{13, 200,  -30, 345, P_ENTER2 },
	{13, 200,  -30, 340, P_ENTER1 },
	{13, 200,  -30, 335, P_ENTER2 },
	{13, 200,  -30, 330, P_ENTER1 },
	{13, 200,  -30, 325, P_ENTER2 },
	{13, 200,  -30, 320, P_ENTER1 },
	{13, 200,  -30, 315, P_ENTER2 },
	{13, 200,  -30, 310, P_ENTER1 },
	{13, 200,  -30, 305, P_ENTER2 },
	{13, 200,  -30, 300, P_ENTER1 },
/*--*/  {14, 430,  530, 245, P_ENTER12},
	{14, -30,  530, 240, P_ENTER13},
	{14, 430,  530, 235, P_ENTER12},
	{14, -30,  530, 230, P_ENTER13},
	{14, 430,  530, 225, P_ENTER12},
	{14, -30,  530, 220, P_ENTER13},
	{14, 430,  530, 215, P_ENTER12},
	{14, -30,  530, 210, P_ENTER13},
	{14, 430,  530, 205, P_ENTER12},
	{14, -30,  530, 200, P_ENTER13},
/*--*/  {15, -30,  530, 145, P_ENTER13},
	{15, -30,  530, 140, P_ENTER13},
	{15, -30,  530, 135, P_ENTER13},
	{15, -30,  530, 130, P_ENTER13},
	{15, -30,  530, 125, P_ENTER13},
	{15, -30,  530, 120, P_ENTER13},
	{15, -30,  530, 115, P_ENTER13},
	{15, -30,  530, 110, P_ENTER13},
	{15, -30,  530, 105, P_ENTER13},
	{15, -30,  530, 100, P_ENTER13},
/*--*/  {16, 430,  530,  45, P_ENTER12},
	{16, 430,  530,  40, P_ENTER12},
	{16, 430,  530,  35, P_ENTER12},
	{16, 430,  530,  30, P_ENTER12},
	{16, 430,  530,  25, P_ENTER12},
	{16, 430,  530,  20, P_ENTER12},
	{16, 430,  530,  15, P_ENTER12},
	{16, 430,  530,  10, P_ENTER12},
	{16, 430,  530,   5, P_ENTER12},
	{16, 430,  530,   0, P_ENTER12},
    },	      			     
    { /* level 12 */                    
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11, -30,  250, 405, P_ENTER10},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},        
        {11, 430,  250, 400, P_ENTER11},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
                                        
        {12,  -1,   -1,  -1, -1},       
        {12,  -1,   -1,  -1, -1},       
        {12, -30,  250, 435, P_ENTER10},
        {12, 430,  250, 430, P_ENTER11},
        {12, -30,  250, 425, P_ENTER10},
        {12, 430,  250, 420, P_ENTER11},
        {12, -30,  250, 415, P_ENTER10},
        {12, 430,  250, 410, P_ENTER11},
        {12,  -1,   -1,  -1, -1},         
        {12,  -1,   -1,  -1, -1},       
                                        
        {13, 200,  -30, 345, P_ENTER2 },
        {13, 200,  -30, 340, P_ENTER1 },
        {13, 200,  -30, 335, P_ENTER2 },
        {13, 200,  -30, 330, P_ENTER1 },
        {13, 200,  -30, 325, P_ENTER2 },
        {13, 200,  -30, 320, P_ENTER1 },
        {13, 200,  -30, 315, P_ENTER2 },
        {13, 200,  -30, 310, P_ENTER1 },
        {13, 200,  -30, 305, P_ENTER2 },
        {13, 200,  -30, 300, P_ENTER1 },
/*--*/  {14, 430,  250, 245, P_ENTER15},
        {14, -30,  250, 240, P_ENTER16},
        {14, 430,  250, 235, P_ENTER15},
        {14, -30,  250, 230, P_ENTER16},
        {14, 430,  250, 225, P_ENTER15},
        {14, -30,  250, 220, P_ENTER16},
        {14, 430,  250, 215, P_ENTER15},
        {14, -30,  250, 210, P_ENTER16},
        {14, 430,  250, 205, P_ENTER15},
        {14, -30,  250, 200, P_ENTER16},
/*--*/  {15, 360,  -30, 100, P_ENTER17},
        {15, 320,  -30, 100, P_ENTER17},
        {15, 280,  -30, 100, P_ENTER17},
        {15, 240,  -30, 100, P_ENTER17},
        {15, 200,  -30, 100, P_ENTER17},
        {15, 160,  -30, 100, P_ENTER17},
        {15, 120,  -30, 100, P_ENTER17},
        {15,  80,  -30, 100, P_ENTER17},
        {15,  40,  -30, 100, P_ENTER17},
        {15,   0,  -30, 100, P_ENTER17},
/*--*/  {16, 360,  -30,   0, P_ENTER17},
        {16, 320,  -30,   0, P_ENTER17},
        {16, 280,  -30,   0, P_ENTER17},
        {16, 240,  -30,   0, P_ENTER17},
        {16, 200,  -30,   0, P_ENTER17},
        {16, 160,  -30,   0, P_ENTER17},
        {16, 120,  -30,   0, P_ENTER17},
        {16,  80,  -30,   0, P_ENTER17},
        {16,  40,  -30,   0, P_ENTER17},
        {16,   0,  -30,   0, P_ENTER17},
    },	                             
    { /* level 13 */                    
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11, -30,  250, 405, P_ENTER10},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},        
        {11, 430,  250, 400, P_ENTER11},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
                                        
        {12,  -1,   -1,  -1, -1},       
        {12,  -1,   -1,  -1, -1},       
        {12, -30,  250, 435, P_ENTER10},
        {12, 430,  250, 430, P_ENTER11},
        {12, -30,  250, 425, P_ENTER10},
        {12, 430,  250, 420, P_ENTER11},
        {12, -30,  250, 415, P_ENTER10},
        {12, 430,  250, 410, P_ENTER11},
        {12,  -1,   -1,  -1, -1},         
        {12,  -1,   -1,  -1, -1},       
                                        
        {13, 200,  -30, 345, P_ENTER2 },
        {13, 200,  -30, 340, P_ENTER1 },
        {13, 200,  -30, 335, P_ENTER2 },
        {13, 200,  -30, 330, P_ENTER1 },
        {13, 200,  -30, 325, P_ENTER2 },
        {13, 200,  -30, 320, P_ENTER1 },
        {13, 200,  -30, 315, P_ENTER2 },
        {13, 200,  -30, 310, P_ENTER1 },
        {13, 200,  -30, 305, P_ENTER2 },
        {13, 200,  -30, 300, P_ENTER1 },
/*--*/  {14, 430,  250, 245, P_ENTER15},
        {14, -30,  250, 240, P_ENTER16},
        {14, 430,  250, 235, P_ENTER15},
        {14, -30,  250, 230, P_ENTER16},
        {14, 430,  250, 225, P_ENTER15},
        {14, -30,  250, 220, P_ENTER16},
        {14, 430,  250, 215, P_ENTER15},
        {14, -30,  250, 210, P_ENTER16},
        {14, 430,  250, 205, P_ENTER15},
        {14, -30,  250, 200, P_ENTER16},
/*--*/  {15, 100,  530, 145, P_ENTER8 },
        {15, 300,  530, 140, P_ENTER9 },
        {15, 100,  530, 135, P_ENTER8 },
        {15, 300,  530, 130, P_ENTER9 },
        {15, 100,  530, 125, P_ENTER8 },
        {15, 300,  530, 120, P_ENTER9 },
        {15, 100,  530, 115, P_ENTER8 },
        {15, 300,  530, 110, P_ENTER9 },
        {15, 100,  530, 105, P_ENTER8 },
        {15, 300,  530, 100, P_ENTER9 },
/*--*/  {16, 100,  530,  40, P_ENTER8 },
        {16, 300,  530,  40, P_ENTER9 },
        {16, 100,  530,  30, P_ENTER8 },
        {16, 300,  530,  30, P_ENTER9 },
        {16, 100,  530,  20, P_ENTER8 },
        {16, 300,  530,  20, P_ENTER9 },
        {16, 100,  530,  10, P_ENTER8 },
        {16, 300,  530,  10, P_ENTER9 },
        {16, 100,  530,   0, P_ENTER8 },
        {16, 300,  530,   0, P_ENTER9 },
    },
    { /* level 14 */                    
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11, -30,  250, 405, P_ENTER10},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},        
        {11, 430,  250, 400, P_ENTER11},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
                                        
        {12,  -1,   -1,  -1, -1},       
        {12,  -1,   -1,  -1, -1},       
        {12, -30,  250, 435, P_ENTER10},
        {12, 430,  250, 430, P_ENTER11},
        {12, -30,  250, 425, P_ENTER10},
        {12, 430,  250, 420, P_ENTER11},
        {12, -30,  250, 415, P_ENTER10},
        {12, 430,  250, 410, P_ENTER11},
        {12,  -1,   -1,  -1, -1},         
        {12,  -1,   -1,  -1, -1},       
                                        
        {13, 430,  250, 345, P_ENTER18},
        {13, 430,  250, 340, P_ENTER18},
        {13, 430,  250, 335, P_ENTER18},
        {13, 430,  250, 330, P_ENTER18},
        {13, 430,  250, 325, P_ENTER18},
        {13, 430,  250, 320, P_ENTER18},
        {13, 430,  250, 315, P_ENTER18},
        {13, 430,  250, 310, P_ENTER18},
        {13, 430,  250, 305, P_ENTER18},
        {13, 430,  250, 300, P_ENTER18},
/*--*/  {14, 430,  250, 245, P_ENTER18},
        {14, 430,  250, 240, P_ENTER18},
        {14, 430,  250, 235, P_ENTER18},
        {14, 430,  250, 230, P_ENTER18},
        {14, 430,  250, 225, P_ENTER18},
        {14, 430,  250, 220, P_ENTER18},
        {14, 430,  250, 215, P_ENTER18},
        {14, 430,  250, 210, P_ENTER18},
        {14, 430,  250, 205, P_ENTER18},
        {14, 430,  250, 200, P_ENTER18},
/*--*/  {15, -30,  -30, 145, P_ENTER20},
        {15, -30,  -30, 140, P_ENTER20},
        {15, -30,  -30, 135, P_ENTER20},
        {15, -30,  -30, 130, P_ENTER20},
        {15, -30,  -30, 125, P_ENTER20},
        {15, -30,  -30, 120, P_ENTER20},
        {15, -30,  -30, 115, P_ENTER20},
        {15, -30,  -30, 110, P_ENTER20},
        {15, -30,  -30, 105, P_ENTER20},
        {15, -30,  -30, 100, P_ENTER20},
/*--*/  {16, 430,  -30,  45, P_ENTER19},
        {16, 430,  -30,  40, P_ENTER19},
        {16, 430,  -30,  35, P_ENTER19},
        {16, 430,  -30,  30, P_ENTER19},
        {16, 430,  -30,  25, P_ENTER19},
        {16, 430,  -30,  20, P_ENTER19},
        {16, 430,  -30,  15, P_ENTER19},
        {16, 430,  -30,  10, P_ENTER19},
        {16, 430,  -30,   5, P_ENTER19},
        {16, 430,  -30,   0, P_ENTER19},
    },	      	        	     
    { /* level 15 */                    
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
        {11, -30,  250, 405, P_ENTER10},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},        
        {11, 430,  250, 400, P_ENTER11},
        {11,  -1,   -1,  -1, -1},         
        {11,  -1,   -1,  -1, -1},       
        {11,  -1,   -1,  -1, -1},       
                                        
        {12,  -1,   -1,  -1, -1},       
        {12,  -1,   -1,  -1, -1},       
        {12, -30,  250, 435, P_ENTER10},
        {12, 430,  250, 430, P_ENTER11},
        {12, -30,  250, 425, P_ENTER10},
        {12, 430,  250, 420, P_ENTER11},
        {12, -30,  250, 415, P_ENTER10},
        {12, 430,  250, 410, P_ENTER11},
        {12,  -1,   -1,  -1, -1},         
        {12,  -1,   -1,  -1, -1},       
                                        
        {13, 200,  -30, 345, P_ENTER2 },
        {13, 200,  -30, 340, P_ENTER1 },
        {13, 200,  -30, 335, P_ENTER2 },
        {13, 200,  -30, 330, P_ENTER1 },
        {13, 200,  -30, 325, P_ENTER2 },
        {13, 200,  -30, 320, P_ENTER1 },
        {13, 200,  -30, 315, P_ENTER2 },
        {13, 200,  -30, 310, P_ENTER1 },
        {13, 200,  -30, 305, P_ENTER2 },
        {13, 200,  -30, 300, P_ENTER1 },
/*--*/  {14, 430,  250, 245, P_ENTER15},
        {14, -30,  250, 240, P_ENTER16},
        {14, 430,  250, 235, P_ENTER15},
        {14, -30,  250, 230, P_ENTER16},
        {14, 430,  250, 225, P_ENTER15},
        {14, -30,  250, 220, P_ENTER16},
        {14, 430,  250, 215, P_ENTER15},
        {14, -30,  250, 210, P_ENTER16},
        {14, 430,  250, 205, P_ENTER15},
        {14, -30,  250, 200, P_ENTER16},
/*--*/  {15, 100,  530, 145, P_ENTER8 },
        {15, 300,  530, 140, P_ENTER9 },
        {15, 100,  530, 135, P_ENTER8 },
        {15, 300,  530, 130, P_ENTER9 },
        {15, 100,  530, 125, P_ENTER8 },
        {15, 300,  530, 120, P_ENTER9 },
        {15, 100,  530, 115, P_ENTER8 },
        {15, 300,  530, 110, P_ENTER9 },
        {15, 100,  530, 105, P_ENTER8 },
        {15, 300,  530, 100, P_ENTER9 },
/*--*/  {16, 100,  530,  40, P_ENTER8 },
        {16, 300,  530,  40, P_ENTER9 },
        {16, 100,  530,  30, P_ENTER8 },
        {16, 300,  530,  30, P_ENTER9 },
        {16, 100,  530,  20, P_ENTER8 },
        {16, 300,  530,  20, P_ENTER9 },
        {16, 100,  530,  10, P_ENTER8 },
        {16, 300,  530,  10, P_ENTER9 },
        {16, 100,  530,   0, P_ENTER8 },
        {16, 300,  530,   0, P_ENTER9 },
    },
};

void path_dir(int path, int pos, int *dir, int *steer)
{
    *dir =   paths[path][pos][0];
    *steer = paths[path][pos][1];
}

void start_path(int path, struct alien *al)
{
    int i;

    for(i=0;(i<MAXPATH) && (paths[path][i][0] >= 0);i++) {
	if(paths[path][i][0] == al->dir)
	    break;
	if(paths[path][i][0] < 0) {
	    al->steer = TURNSPEED;
	    al->path = -1;
	    return;
	}
    }
    if(i >= MAXPATH) {
	al->steer = TURNSPEED;
	al->path = -1;
	return;
    }

    al->path = path;
    al->path_pos = i;
    al->steer = paths[path][i][1];
}

void new_alien(int level, int i, struct alien *al)
{
    int l = (level-1) % NUMLEVELS;

    al->alive = 1;
    al->dying = 0;
    al->x = ep[l][i].x;
    al->y = ep[l][i].y;
    al->entering = 1;
    al->enterdelay = ep[l][i].delay;
    al->path = ep[l][i].path;
    al->path_pos = 0;
    al->dir = paths[ep[l][i].path][0][0];
    al->steer = 2*(paths[ep[l][i].path][0][1]/3);
    al->escorting = -1;
    al->shape = getImage(alien_shape[ep[l][i].shape]);
}
