
/*
 * XKOBO, a video-oriented game
 * Copyright (C) 1995  Akira Higuchi
 *     a-higuti@math.hokudai.ac.jp
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#ifndef _XKOBO_KEY
#define _XKOBO_KEY

extern "C"{
#include <X11/Xlib.h>
#include <X11/keysym.h>
}
#include "config.h"

#if KEY_MAP == 1
#define KEY_DOWN      XK_KP_2
#define KEY_LEFT      XK_KP_4
#define KEY_UP        XK_KP_8
#define KEY_RIGHT     XK_KP_6
#endif
#if KEY_MAP == 2
#define KEY_DOWN      XK_k
#define KEY_LEFT      XK_j
#define KEY_UP        XK_i
#define KEY_RIGHT     XK_l
#endif
#if KEY_MAP == 3
#define KEY_DOWN      XK_Henkan_Mode
#define KEY_LEFT      XK_l
#define KEY_UP        XK_p
#define KEY_RIGHT     XK_colon
#endif
#if KEY_MAP == 4
#define KEY_DOWN      XK_KP_0
#define KEY_LEFT      XK_KP_4
#define KEY_UP        XK_KP_8
#define KEY_RIGHT     XK_KP_6
#endif

#define KEY_START     XK_s
#define KEY_SHOT      XK_Shift_L
#define KEY_EXIT      XK_q
#define KEY_PLUS      XK_m
#define KEY_MINUS     XK_n

class _key{
    static int  space;
    static int  left, up, down, right;
    static int  shot;
    static int  direction;
    static void change();
  public:
    static void init();
    static void clear();
    static void press(KeySym sym);
    static void release(KeySym sym);
    static void mouse_press(int n);
    static void mouse_release(int n);
    static void mouse_position(int h, int v);
    static inline int dir(){ return direction; }
    static inline int get_shot(){ int ret = shot; return ret; }
};

extern _key key;

#endif // _XKOBO_KEY
