#!/bin/sh
#
# handleacct.sh
# Handles /var/adm/acct file and old acct files
# Run this script periodically from root's crontab
#
# Use this script at your own risk. No guarantee pr warranty of
# any kind of is given against this script to destroy all files
# in your system or cause other damage. Read this script
# carefully before using it. Modify it to suite to your local
# environment.
#
# Apply GPL as copyright to this file. 
#
# Author: <Juha.Virtanen@HUT.Fi>
# Last time modified on 9th July 1995.

PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/bin; export PATH

prog=`basename $0`

# Log to syslog what we do.
# To not log, comment logging line out
slog ()
{
	logger -t "$prog" -i -p user.notice $*
}

# Where are old files saved
storefile="/var/log/acct/`date +Acct-%W-%a`"
acctfile="/var/adm/acct"
# Remove old accounting files after N days
rmtime=6

if [ ! -f $acctfile ]; then
	slog "${acctfile}: Not found or not a regular file."
	echo "${prog}: ${acctfile}: Not found or not a regular file." 1>&2
	exit 1
fi

# Move old file to new name and create new file
# before turning off and on accounting to minimalize the time
# we are running without accounting
slog "Handling $acctfile"
mv -f $acctfile ${acctfile}.tmp
touch $acctfile
accton
accton $acctfile
mv -f ${acctfile}.tmp $storefile
# Allow everybody to examine today's accounting
chown root.system $acctfile
chmod 0755 $acctfile

slog "Handling $storefile"
tmpfile=/tmp/${prog}.$$
acctentries $storefile 2>&1 > $tmpfile
cat $tmpfile | slog
rm -f $tmpfile
#rm -f $storefile.gz
#gzip -9 $storefile
sync

# Remove old accounting files after N days
slog "Old accounting files removed after $rmtime days."
storedir=`dirname $storefile`      
for f in `find $storedir -maxdepth 1 -type f -mtime +$rmtime -print`; do
	slog "removing $f"
	rm -f $f
done

slog "Done."
#EOF
