/* $Copyright: $
 * Copyright (c) 1995 by Steve Baker
 * All Rights reserved
 *
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include <utmp.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

static char *version = "$Version: $ rawtmp v1.0 (c) 1995 by Steve Baker $";

#define WTMP  "/etc/wtmp"

char *num();
int fd;

/*
 * rawtmp [-w wtmp] [filter rules]
 */
main(argc,argv)
int argc;
char **argv;
{
  char *file = WTMP;
  int i = 1;

  if (argv[i]) {
    if (!strcmp("-w",argv[i])) {
      file = argv[i+1];
      i = 3;
    }
    for(;i<argc;i++) {
    }
  }

  fd = open(file,O_RDONLY);
  doit();
  close(fd);
}

doit()
{
  static char *ltype[] = {
    "UNKNOWN (0)", "Run Level", "Boot Time", "New Time", "Old Time",
    "INIT Process", "LOGIN Process", "User Process", "Dead Process", NULL
  };
  struct utmp u;
  unsigned char c;
  char l[12];

  printf("  Time        User    ID  Line         Host               PID   Type\n");

  while (read(fd,&u,sizeof(struct utmp)) == sizeof(struct utmp)) {
    c = u.ut_id[0] & 0x7F;
    u.ut_id[0] = (c && (c > '~' || c < ' '))? '?' : c;
    c = u.ut_id[1] & 0x7F;
    u.ut_id[1] = (c && (c > '~' || c < ' '))? '?' : c;
    printf("%-10ld: %-8.8s [%-2.2s] %-12.12s %-16.16s [%5d] %s\n",u.ut_time,u.ut_user,u.ut_id,u.ut_line,u.ut_host,u.ut_pid & 0xFFFF,(u.ut_type>0 && u.ut_type<9?ltype[u.ut_type]:num(u.ut_type)));
  }
}

char *num(n)
unsigned short n;
{
  static char nbuf[30];

  sprintf(nbuf,"UNKNOWN (%d)",n);
  return nbuf;
}
