//
//  Fixperms - set and get permissions on lists of files
//  Copyright (C) 1993-1994  Anthony Edward Hall (aehall@seattleu.edu)
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: file.H,v 1.9 1994/01/29 15:07:41 aehall Exp $

#ifndef _FILE_H_
  #define _FILE_H_

  #include <unistd.h>    // for readlink
  #include <sys/stat.h>  // for file mode defines
  #include <dirent.h>    // for NAME_MAX and PATH_MAX
  #include <stdio.h>     // for perror

  #define FNAMELEN 60
  #define FORMVARS fptr->ftype,fptr->fname,fptr->fstats.st_uid,\
                   fptr->fstats.st_gid,fptr->fstats.st_mode
  #define r_FORMAT "%c %s %3d %3d %4.4lo\n",FORMVARS  // regular file
  #define o_FORMAT "%c %s %3d %3d %4.4lo\n",FORMVARS  // other files
  #define l_FORMAT "%c %s %3d %3d %4.4lo %s\n",FORMVARS,fptr->linkname  // link file
  #define cb_FORMAT "%c %s %3d %3d %4.4lo %3d %3d\n",FORMVARS,fptr->major,fptr->minor  // char/block files

  class file
    {
    public:
      char *fname, *linkname;
      struct stat fstats;
      char ftype;
      int major, minor;

      file();
      ~file();
      int get_file(char *name, int options);
      void output(FILE *stream, file *fptr, int options);
      void input(FILE *stream, file *fptr);
    };

#endif // end $Id: file.H,v 1.9 1994/01/29 15:07:41 aehall Exp $
