//
//  Fixperms - set and get permissions on lists of files
//  Copyright (C) 1993-1994  Anthony Edward Hall (aehall@seattleu.edu)
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: fixperms.H,v 1.11 1994/01/29 16:03:47 aehall Exp $

#ifndef _FIXPERMS_H_
  #define _FIXPERMS_H_

  #ifndef PERMS_DIR
    #define PERMS_DIR "/var/adm/packages"
  #endif
  #define PERMS_SUFFIX "perm"
  #define ABNORMAL_EXIT 2
  #define TRUE 1
  #define FALSE 0
  // options
  #define O_NONE 0
  #define O_VERBOSE 1
  #define O_RECURSIVE 2
  #define O_CHECK_ONLY 4
  #define O_QUIET 8
  #define O_FORCE 16
  #define O_ABSOLUTE 32
  #define O_IS_NONE(o)        (((o) & O_NONE) == O_NONE)
  #define O_IS_VERBOSE(o)     (((o) & O_VERBOSE) == O_VERBOSE)
  #define O_IS_RECURSIVE(o)   (((o) & O_RECURSIVE) == O_RECURSIVE)
  #define O_IS_CHECK_ONLY(o)  (((o) & O_CHECK_ONLY) == O_CHECK_ONLY)
  #define O_IS_QUIET(o)       (((o) & O_QUIET) == O_QUIET)
  #define O_IS_FORCE(o)       (((o) & O_FORCE) == O_FORCE)
  #define O_IS_ABSOLUTE(o)    (((o) & O_ABSOLUTE) == O_ABSOLUTE)
  //max length of pathname + filename
  #define MAX_NAME_LEN sizeof(char)*NAME_MAX+sizeof(char)*PATH_MAX+1

#endif // end $Id: fixperms.H,v 1.11 1994/01/29 16:03:47 aehall Exp $
