#include <assert.h>
#include <dirent.h>
#include <pwd.h>
#include <sys/stat.h>
#include <unistd.h>
#include "common.h"

/* init_daemon() taken from "Advanced Programming in the UNIX Environment" */

int init_daemon() {
  pid_t pid;
  if ((pid = fork()) < 0) return -1;
  else if (pid != 0) exit(0);
  setsid();
  chdir("/");
  umask(0);
  return 0;
}

void proc_list(int *n_procs, uid_t *ps_uid, pid_t *ps_pid) {
  struct stat _stat;
  char tpath[32];
  FILE *f;
  uid_t uid;
  pid_t pid;
  DIR *dir = opendir("/proc");
  struct dirent *_dirent;
  if (dir == NULL) {
    printf("opendir() failed: /proc\n");
    exit(1);
  }
  *n_procs = 0;
  while ((_dirent = readdir(dir)) != NULL) {
    if (isdigit(_dirent->d_name[0])) {
      pid = atoi(_dirent->d_name);
      sprintf(tpath, "/proc/%d", (int) pid);
      if (stat(tpath, &_stat)) printf("stat() failed\n");
      uid = _stat.st_uid;
      ps_uid[*n_procs] = uid;
      ps_pid[*n_procs] = pid;
      (*n_procs)++;
    }
  }
  closedir(dir);
}

void fcopy(char *spath, char *dpath) {
  int c, n;
  char buf[4096];
  FILE *s, *d;
  s = fopen(spath, "rb"); d = fopen(dpath, "wb");
  assert(s != NULL); assert(d != NULL);
  setvbuf(s, NULL, _IOFBF, 4096); setvbuf(d, NULL, _IOFBF, 4096);
  while ((n = fread(buf, 1, 4096, s)) > 0)
    fwrite(buf, 1, n, d);
  fclose(s); fclose(d);
}

uid_t uid_from_login(char *login) {
  uid_t res = -1;
  struct passwd *passwdp;
  if ((passwdp = getpwnam(login)) != NULL)
    res = passwdp->pw_uid;
  return res;
}

char *login_from_uid(uid_t uid, char *login) {
  char *res = NULL;
  struct passwd *passwdp;
  if ((passwdp = getpwuid(uid)) != NULL) {
    strcpy(login, passwdp->pw_name);
    res = login;
  }
  return res;
}
