#include <assert.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

void main(int argc, char **argv) {
  int found = 0;
  uid_t uid;
  struct user_rec ur;
  FILE *user_file;
  char str[256];
  if (argc != 2) {
    printf("usage: user_data <login>\n");
    exit(0);
  }
  uid = uid_from_login(argv[1]);
  if (uid == (uid_t) -1) {
    printf("user %s does not exist.\n", argv[1]);
    exit(1);
  }
  user_file = fopen(USER_FILE, "rb"); assert(user_file != NULL);
  while (!user_rec_read(&ur, user_file)) {
    if (ur.uid == uid) {
      found = 1;
      printf("login:\t\t%s\n", argv[1]);
      printf("daily limit:\t%d\n", ur.tlimit);
      printf("minutes left:\t%d\n", ur.tleft);
      printf("last online:\t-%.2f day(s)\n", (float) (time(NULL) - ur.last) / (24 * 60 * 60));
      if (EXPIRE(ur.flags) == EXPIRE_DELETE) strcpy(str, "DELETE");
      else strcpy(str, "UNSUBSCRIBE");
      printf("expiry date:\t");
      if (ur.expire) {
        printf("+%.2f day(s)\n", (float) (ur.expire - time(NULL)) / (24 * 60 * 60));
      } else printf("N/A\n");
      printf("expiry action:\t");
      if (ur.expire) {
        printf("%s\n", str);
      } else printf("N/A\n");
      break;
    }
  } 
  fclose(user_file);
  if (!found) {
    printf("user %s not found.\n", argv[1]);
    exit(1);
  }
}
