#include <assert.h>
#include <unistd.h>
#include <pwd.h>
#include "common.h"
#include "bbs-util.h"

void main(int argc, char **argv) {
  FILE *passwd_file, *tmp_passwd, *user_file, *tmp_user;
  int found = 0;
  uid_t uid;
  struct user_rec ur;
  char cmd[256], tpasswd[16], tuser[16];
  struct passwd *pwd;
  if (argc != 2) {
    printf("usage: user_del <login>\n");
    exit(0);
  }
  uid = uid_from_login(argv[1]);
  strcpy(tpasswd, "/tmp/XXXXXX"); mktemp(tpasswd);
  tmp_passwd = fopen(tpasswd, "w"); assert(tmp_passwd != NULL);
  while ((pwd = getpwent()) != NULL)
    if (pwd->pw_uid == uid) found = 1;
    else putpwent(pwd, tmp_passwd);
  endpwent();
  fclose(tmp_passwd);
  strcpy(tuser, "/tmp/XXXXXX"); mktemp(tuser);
  user_file = fopen(USER_FILE, "rb"); assert(user_file != NULL);
  tmp_user = fopen(tuser, "wb"); assert(tmp_user != NULL);
  while (!user_rec_read(&ur, user_file))
    if (ur.uid == uid) found = 1;
    else user_rec_write(&ur, tmp_user);
  fclose(user_file); fclose(tmp_user);
  if (found) {
    fcopy(tpasswd, "/etc/passwd"); unlink(tpasswd);
    fcopy(tuser, USER_FILE); unlink(tuser);
    sprintf(cmd, "rm -r /home/%s", argv[1]);
    system(cmd);
    sprintf(cmd, "/var/spool/mail/%s", argv[1]);
    unlink(cmd);
    printf("user %s deleted.\n", argv[1]);
  } else {
    unlink(tpasswd); unlink(tuser);
    printf("user %s not found.\n", argv[1]);
    exit(1);
  }
}
