#include <assert.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

void main(int argc, char **argv) {
  FILE *user_file;
  int found = 0;
  uid_t uid;
  struct user_rec ur;
  char tuser[16];
  struct passwd *pwd;
  if (argc != 4) {
    printf("usage: user_subscribe <login> <days> <minutes>\n");
    exit(0);
  }
  uid = uid_from_login(argv[1]);
  if (uid == (uid_t) -1) {
    printf("user %s does not exist.\n", argv[1]);
    exit(1);
  }
  strcpy(tuser, "/tmp/XXXXXX"); mktemp(tuser);
  user_file = fopen(USER_FILE, "r+b"); assert(user_file != NULL);
  while (!user_rec_read(&ur, user_file)) {
    if (ur.uid == uid) {
      found = 1;
      if (EXPIRE(ur.flags) == EXPIRE_UNSUBSCRIBE) {
        printf("user %s already has a subscription.\n", argv[1]);
        fclose(user_file);
        exit(1);
      }
      ur.sub_expire = ur.expire;
      ur.sub_tlimit = ur.tlimit;
      ur.expire = time(NULL) + atol(argv[2]) * (24 * 60 * 60);
      ur.tlimit = atoi(argv[3]);
      ur.tleft = ur.tlimit;
      ur.flags |= EXPIRE_UNSUBSCRIBE;
      fseek(user_file, -sizeof(struct user_rec), SEEK_CUR);
      user_rec_write(&ur, user_file);
      printf("user %s subscribed.\n", argv[1]);
      break;
    }
  }
  fclose(user_file);
  if (!found) {
    printf("user %s not found.\n", argv[1]);
    exit(1);
  }
}
