#include <assert.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

void main(int argc, char **argv) {
  int found = 0;
  uid_t uid;
  FILE *user_file;
  shword tlimit;
  time_t expire;
  struct user_rec ur;
  if (argc != 4) {
    printf("usage: user_time <login> <days> <mins>\n");
    exit(0);
  }
  uid = uid_from_login(argv[1]);
  if (uid == (uid_t) -1) {
    printf("user %s does not exist.\n", argv[1]);
    exit(1);
  }
  expire = atoi(argv[2]);
  if (expire) expire = time(NULL) + expire * (24 * 60 * 60);
  tlimit = atoi(argv[3]);
  user_file = fopen(USER_FILE, "r+b"); assert(user_file != NULL);
  while (!user_rec_read(&ur, user_file)) {
    if (ur.uid == uid) {
      found = 1;
      if (EXPIRE(ur.flags) == EXPIRE_UNSUBSCRIBE && !expire) {
        printf("<days> = 0 illegal (user %s has a subscription).\n");
        break;
      }
      ur.expire = expire;
      ur.tlimit = tlimit;
      ur.tleft = ur.tlimit;
      fseek(user_file, -sizeof(struct user_rec), SEEK_CUR);
      user_rec_write(&ur, user_file);
      printf("user %s modified.\n", argv[1]);
      break;
    }
  } 
  fclose(user_file);
  if (!found) {
    printf("user %s not found.\n", argv[1]);
    exit(1);
  }
}
