#include <assert.h>
#include <unistd.h>
#include "common.h"
#include "bbs-util.h"

void main(int argc, char **argv) {
  int found = 0;
  uid_t uid;
  FILE *user_file;
  struct user_rec ur;
  if (argc != 2) {
    printf("usage: user_touch <login>\n");
    exit(0);
  }
  uid = uid_from_login(argv[1]);
  if (uid == (uid_t) -1) {
    printf("user %s does not exist.\n", argv[1]);
    exit(1);
  }
  user_file = fopen(USER_FILE, "r+b"); assert(user_file != NULL);
  while (!user_rec_read(&ur, user_file)) {
    if (ur.uid == uid) {
      found = 1;
      ur.last = time(NULL);
      fseek(user_file, -sizeof(struct user_rec), SEEK_CUR);
      user_rec_write(&ur, user_file);
      printf("user %s touched.\n", argv[1]);
      break;
    }
  } 
  fclose(user_file);
  if (!found) {
    printf("user %s not found.\n", argv[1]);
    exit(1);
  }
}
