/*
version: $Id: hsh_disp.c,v 5.120 1995/01/04 12:25:19 hitman Exp $
purpose: All display functions for program.
updates: Handled by RCS
*/

#include <stdio.h>

#ifndef __MSDOS__
#	include "hsh_glob.h"
#	include "hsh_sub.h"
#	include "hshgen_s.h"
#	include "hshgen_h.h"
#	include "../version.h"
#else /* not_MSDOS */
#	include "..\src\bbs_fn-s\hsh_glob.h"
#	include "..\src\bbs_fn-s\hsh_sub.h"
#	include "..\src\bbs_fn-s\hshgen_s.h"
#	include "..\src\bbs_fn-s\hshgen_h.h"
#	include "version.h"
#endif /* MSDOS */

/********************************************************************/
/* Table of functions and procedures.								*/
int shell_display(_character *Character);

/********************************************************************/
/* Shell Display Title                                              */
int shell_display(_character *Character)
{
#ifdef DEBUG
	fprintf(stderr, "** %s: Character->nextstate = %d **\n", __FILE__, Character->nextstate);
#endif /* DEBUG */
	printf("\n");
/** the bilangual parts of this program are set up with compiler */
/*	statements.  The code is large but the program is small. **/
#ifdef ENGLISH
	printf("Program: %s, v%s\n", PROGRAM, VER);
	printf("Copyright: %s, %s\n", COPYRIGHT, __DATE__);
	printf("Compiled: %s, %s, %s\n", OSVER, CCVER, COMPBY);
#elif SPANISH /* ENGLISH */
	printf("Programa: %s, v%s\n", PROGRAM, VER);
	printf("Derecho de Propiedad: %s, %s\n", COPYRIGHT, __DATE__);
	printf("Compilador: %s, %s, %s\n", OSVER, CCVER, COMPBY);
#endif /* SPANISH */
	printf("\n");

	switch (Character->Activity) {
		case SHELL_DISPLAY:
			return (RET_ERROR1);
		break; /* case_shell_display */
	} /* switch_special_case */
	return(RET_NORMAL);
} /* shell_display */
/********************************************************************/
