/*
 * netmailer for network release 2.0
 * see copyright.doc for copyright information
 *
 * Not responsible for porting problems!!!
 * (although this one should be significantly easier than 1.1)
 *
 * This program allows Citadel/UX users to send network mail.
 * It is invoked by citadel with these arguments:
 * argv[1] = string pointer containing the temp file name of a binary message.
 * argv[2] = pointer to an integer containing the mailtype (see header file)
 * argv[3] = if this is the string "strip" then we chop off the @sysname
 *
 * The program is a back end mailer which is called by Citadel.
 *
 * Place this program in your citadel directory.
 */

#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include "citadel.h"

struct config config;

char temp[20];
long lseek();
long atol();

int haschar(st,ch)
char st[];
int ch; {
	int a,b;
	b=0;
	for (a=0; a<strlen(st); ++a) if (st[a]==ch) ++b;
	return(b);
	}

main(argc,argv)
int argc;
char *argv[];
{
	int a,mailtype;
	FILE *fp,*rmail;
	char sbuf[200],rbuf[200],cstr[100],fstr[128],nbuf[64],pbuf[128];
	int strip = 0;

	get_config();	
	sprintf(temp,"/tmp/NetMail.%d",getpid());	/* temp file name */
	mailtype=(*argv[2]);

	if ( (argc==4) && (!strcmp(argv[3],"strip")) ) strip = 1;

switch(mailtype) {

   case M_UUCP: /* send message using uucp mail facility */
	fp=fopen(temp,"w");
	msgform(argv[1],fp,sbuf,rbuf,nbuf,pbuf);
				/* convert to ASCII & get info */
	fclose(fp);

	sprintf(cstr,"rmail %s",rbuf);
	rmail=(FILE *)popen(cstr,"w");

	strcpy(fstr,sbuf);
	for (a=0; a<strlen(sbuf); ++a) if (sbuf[a]==32) sbuf[a]='_';
	for (a=0; a<strlen(rbuf); ++a) if (rbuf[a]==32) rbuf[a]='_';
	if (strip)
		for (a=0; a<strlen(rbuf); ++a) if (rbuf[a]=='@') rbuf[a]=0;

	/*
	 * This logic attempts to compose From and From: lines that are
	 * as RFC822-compliant as possible.  It assumes that you're using
	 * Citadel's rmail/lmail patch to allow BBS users to receive mail
	 * over UUCP or TCP/IP networks.
	 */
	fprintf(rmail,"From ");
	if (strucmp(nbuf,NODENAME)) fprintf(rmail,"%s!",nbuf);

	if ( (strlen(pbuf)!=0) && (haschar(pbuf,'!')==0) ) {
		fprintf(rmail,"%s\n",pbuf);
		fprintf(rmail,"From: %s@%s (%s)\n",pbuf,FQDN,fstr);
		}
	else {
		fprintf(rmail,"%s\n",sbuf);
		if (!strucmp(nbuf,NODENAME)) strcpy(nbuf,FQDN);
		fprintf(rmail,"From: %s@%s (%s)\n",sbuf,nbuf,fstr);
		}

	/*
	 * Everything else is pretty straightforward.
	 */
	fprintf(rmail,"To: %s\nDate: ",rbuf);
	fp=(FILE *)popen("date","r");
	if (fp!=NULL) {
		do {
			a=getc(fp);
			if (a>=0) putc(a,rmail);
			} while(a>=0);
		fclose(fp);
		}
	fprintf(rmail,"\n");
	fp=fopen(temp,"r");
	if (fp!=NULL) {
		do {
			a=getc(fp);
			if (a>=0) putc(a,rmail);
			} while(a>=0);
		fclose(fp);
		}
	fprintf(rmail,"\n");
	pclose(rmail);
	break;
  
   case M_BINARY: /* send mail using Citadel network facility */
	citnetmail(argv[1]);
	break;

   }

unlink(temp);		/* get rid of the ASCII file */
unlink(argv[1]);	/* netmailer is responsible for removal of this */
exit(0);		/* go back to the main program */
}

/* This is NOT the same msgform() found in the main program. It has been
 * modified to format 80 columns into a temporary file, and extract the
 * sender and recipient names for use within the main() loop.
 */
msgform(msgfile,mfout,sbuf,rbuf,nbuf,pbuf)
char *msgfile;
FILE *mfout;
char *sbuf;
char *rbuf;
char *nbuf;
char *pbuf;
	{
	struct tm *tm;
	int a,b,c,d,e,real,old,mtype,aflag;
	char aaa[128],bbb[128],ttm[3];
	FILE *fp;
	long now;
	int width;
	long spos;

	strcpy(pbuf,"");	
	strcpy(nbuf,NODENAME);	
	width=80;
	spos=0L;
	fp=fopen(msgfile,"rb");
	if (fp==NULL) {
			fprintf(stderr,"netmailer: can't open message file\n");
			return(1); }
	strcpy(aaa,""); old=255;
	c=1; /* c is the current pos */
	fseek(fp,spos,0);
	e=getc(fp);
	if (e!=255) {
		fprintf(stderr,"Can't find message! Start Byte=%ld\n",spos);
		goto END; }
	mtype=getc(fp); aflag=getc(fp);
	goto BONFGM;
A:	if (aflag==1) goto AFLAG;
	old=real; a=getc(fp); real=a;
	if (a==0) goto END;
	if (a<0) goto END;
	
	if ( ((a==13)||(a==10)) && (old!=13) && (old!=10) ) a=32;
	if ( ((old==13)||(old==10)) && ((real==32)||(real==13)||(real==10))) {
						fprintf(mfout,"\n"); c=1; }

	if (a!=32) {
	if ( ((strlen(aaa)+c)>(width-5)) && (strlen(aaa)>(width-5)) )
		{ fprintf(mfout,"\n%s",aaa); c=strlen(aaa); aaa[0]=0; }
	 b=strlen(aaa); aaa[b]=a; aaa[b+1]=0; }
	if (a==32) { 	if ((strlen(aaa)+c)>(width-5)) { 
							fprintf(mfout,"\n");
							c=1;
							}
			fprintf(mfout,"%s ",aaa); ++c; c=c+strlen(aaa);
			strcpy(aaa,""); goto A; }
	if ((a==13)||(a==10)) {
				fprintf(mfout,"%s\n",aaa); c=1;
				strcpy(aaa,""); goto A; }
	goto A;

AFLAG:	a=getc(fp); if (a==0) goto END;
	if (a!=13) putc(a,mfout); if (a==13) putc(10,mfout);
	goto AFLAG;

END:	fclose(fp);
	return(0);

BONFGM:	b=getc(fp); if (b<0) goto END;
	if (b=='M') goto A;
	fpgetfield(fp,bbb);
	if (b=='A') strcpy(sbuf,bbb);
	if (b=='R') strcpy(rbuf,bbb);
	if (b=='N') strcpy(nbuf,bbb);
	if (b=='P') strcpy(pbuf,bbb);
	goto BONFGM;
}

fpgetfield(fp,string)
FILE *fp;
char string[];
{
int a,b,c;
strcpy(string,"");
a=0;
do {
	b=getc(fp);
	if (b<1) { string[a]=0; return(0); }
	string[a]=b;
	++a;
	} while (b!=0);
}

citnetmail(flnm)	/* process and send binary mail */
char flnm[];	{	/* filename of temp file containing message */
	int file,a,b,c;
	long pos;
	FILE *fp;
	char name[100];
	char netcmd[256],netraw[256];

	file=open(flnm,O_RDWR); if (file<0) return(-1); b=c=(-1);
	do { 
		c=b; b=0; a=read(file,&b,1);
		if (a==0) {
			close(file); return(-1);
			}
		} while((b!='R')&&(c!=0));
	do {
		b=0; a=read(file,&b,1);
		if (a==0) {
			close(file); return(-1);
			}
		} while(b!='@');
	lseek(file,(-2L),1);
	write(file,"\000D",2);
	name[0]=0;
	do {
		b=0; a=read(file,&b,1);
		c=strlen(name);
		name[c]=b; name[c+1]=0;
		} while(b!=0);
	close(file);
	sysinfo(name);
	sprintf(netcmd,"network/systems/%s",name);
	fp=fopen(netcmd,"r"); if (fp==NULL) return(-1);
	fgets(netraw,256,fp);
	fclose(fp);
	sprintf(netcmd,netraw,flnm);
	system(netcmd);
	return(0);
	}

sysinfo(name)	/* determine routing from sysinfo file */
char name[]; {
	int file,a;
	char aaa[100];
	file=open("network/mail.sysinfo",O_RDONLY);
GETSN:	do {
		a=getstring(file,aaa);
		} while ((a>=0)&&(strucmp(aaa,name)));
	a=getstring(file,aaa);
	if (!strncmp(aaa,"use ",4)) {
		strcpy(name,&aaa[4]);
		lseek(file,0L,0);
		goto GETSN;
		}
	close(file);
	if (!strncmp(aaa,"bin",3)) {
		return(0);
		}
	printf("Error in network/mail.sysinfo file\n");
	return(-1);
	}

getstring(file,string)		/* get a line of text from a file */
int file; char string[]; {	/* ignores lines beginning with # */
int a,b,c;
do {
	strcpy(string,"");
	a=0;
	do {
		c=0; b=read(file,&c,1);
		if (b<1) { string[a]=0; return(-1); }
		string[a]=c;
		++a;
		} while(c!=10);
		string[a-1]=0;
	} while(string[0]=='#');
return(strlen(string));
}


int struncmp(lstr,rstr,len)
char lstr[],rstr[];
int len; {
	int pos = 0;
	char lc,rc;
	while (pos<len) {
		lc=tolower(lstr[pos]);
		rc=tolower(rstr[pos]);
		if ((lc==0)&&(rc==0)) return(0);
		if (lc<rc) return(-1);
		if (lc>rc) return(1);
		pos=pos+1;
		}
	return(0);
	}
