
/* osdeps.h must be included before packet.h */

typedef struct _BINDATA {
  SHORT size;
  void *data;
} BINDATA;

typedef struct _PACKET {
  LONG magic;
  SHORT opcode;
  SHORT flags;
  SHORT cshort;
  SHORT clong;
  SHORT cstr;
  SHORT cbin;
  LONG size;
  SHORT *shorts;
  LONG *longs;
  char **strs;
  BINDATA *bins;
} PACKET;

#define PACKET_MAGIC    0x45424253     /* "EBBS" */
#define PACKET_HDR_SIZE 20             /* size of first 8 fields */

#define PACKET_ERROR_MEMORY (-1)
#define PACKET_ERROR_SANITY (-2)
#define PACKET_ERROR_CLOSED (-3)

#define PACKET_FLG_MAIL 0x01

void init_packet __P((PACKET *p));
int stuff_short __P((PACKET *p, SHORT s));
int stuff_long __P((PACKET *p, LONG l));
int stuff_str __P((PACKET *p, char *str));
int stuff_bin __P((PACKET *p, void *data, SHORT size));
void free_packet __P((PACKET *p));
int read_packet __P((PACKET *p, int sd));
int write_packet __P((PACKET *p, int sd));


