#include "bbs.h"

void lowercases(char *str)
{
  while (*str != '\0') {
    *str = tolower(*str);
    str++;
  }
}


void strprepend(char *str, const char *ps)
{
  char *sp1, *sp2;
  const char *csp;
  
  sp1 = str + strlen(str)*sizeof(char);
  sp2 = sp1 + strlen(ps)*sizeof(char);
  *sp2 = '\0';
  while (sp1 > str) {
    *(--sp2) = *(--sp1);
  }
  csp = ps;
  while (*csp != '\0') {
    *(sp1++) = *(csp++);
  }
}


char *strmaxcpy(char *to, const char *from, SIZE_T count)
{
  SIZE_T k;
  char *dp;
  const char *sp;
  
  for (dp=to,sp=from,k=0; *sp!='\0' && k<count; k++)  *dp++=*sp++;
  *dp = '\0';
  return(to);
}


char *strmaxcat(char *to, const char *append, SIZE_T mlen)
{
  SIZE_T n, k;
  char *dp;
  const char *ap;

  n = strlen(to);
  for (dp=&(to[n]),ap=append,k=n; *ap!='\0' && k<mlen; k++)  *dp++=*ap++;
  *dp = '\0';
  return(to);
}


char *basename(char *path)
{
  char *sp;
  
  sp = path;
  while (*sp!='\0') sp++;
  while ((*sp!='/') && sp>path) sp--;
  return sp;
}


void pathnamedir(const char *path, char dir[])
{
  int k;
  
  strcpy(dir,path);
  k = strlen(dir) - 1;
  while ((dir[k]!='/') && (k>0)) {
    k--;
  }
  if (k > 0) {
    dir[k] = '\0';
  }
  else {
    strcpy(dir,"/");
  }
}


char *buildhelppath(char *helppath, const char *fname, const char *suffix,
		    confrecordtyp *confrecord)
{
  if (strlen(fname)+strlen(confrecord->helpdir)+strlen(suffix)+2 < PATH_MAX) {
    sprintf(helppath,"%s/%s.%s",confrecord->helpdir,fname,suffix);
    return(helppath);
  }
  return(NULL);
}


int splitparams(char *args[], char *params)
{
  int k;
  char *p;
  
  p = params;
  k = 0;
  while (*p!='\0' && k<MAXARGS-1) {
    while (*p==' ' && *p!='\0') p++;
    args[k++] = p;
    while (*p!=' ' && *p!='\0') p++;
    if (*p==' ') {
      *p = '\0';
      p++;
    }
  }
  args[k] = (char *)NULL;
  return k;
} 


void str2cmdparams(const char str[], char cmd[], char params[])
{
  int k;

  while (*str==' ' && *str!='\0')  str++;
  for (k=0; *str!=' ' && *str!='\0'; k++, str++)
    cmd[k] = *str;
  cmd[k] = '\0';
  if (*str != '\0')  str++;
  strcpy(params, str);
}


void split2key_arg(char *line, char **key, char **arg)
{
  char *sp3;

  *key = line;
  *arg = line;
  while (**arg!='\0' && **arg!='#')  (*arg)++;
  **arg = '\0';
  while ((**key==' ' || **key=='\t') && **key!='\0')  (*key)++;
  *arg = *key;
  while (**arg!=' ' && **arg!='\t' && **arg!='\0')  (*arg)++;
  if (**arg != '\0') {
    **arg = '\0';
    (*arg)++;
    while ((**arg==' ' || **arg=='\t') && **arg!='\0')  (*arg)++;
    sp3 = *arg;
    while (*sp3!=' ' && *sp3!='\t' && *sp3!='\n' && *sp3!='\0')  sp3++;
    if (*sp3 != '\0') {
      *sp3 = '\0';
    }
    lowercases(*key);
  }
}


void stringsort(char *strary[], const int anz)
{
  void string_sort(char *[], const int, const int);
  
  string_sort(strary, 0, anz-1);
  return;
}


void string_sort(char *strary[], const int k1, const int k2)
{
  int i, j;
  char *x, *y;
  
  i = k1; j = k2;
  x = strary[(k1+k2)/2];
  do {
    while (strcmp(strary[i],x) < 0 && i < k2) i++;
    while (strcmp(strary[j],x) > 0 && j > k1) j--;
    if (i <= j) {
      y = strary[i];
      strary[i] = strary[j];
      strary[j] = y;
      i++; j--;
    }
  } while (i <= j);
  if (k1 < j)  string_sort(strary,k1,j);
  if (i < k2)  string_sort(strary,i,k2);
  return;
}
