#include "bbs.h"

int windowtext(const char *text, const char *header, const int waittime,
               confrecordtyp *confrecord)
{
  int zeilen, spalten, k, oldx, oldy;
  char str[STRLEN+1], *sp, *bgbp;
  char *conttxt;
  WINDOW *twin;

  conttxt = msg("windowtext",0,confrecord->userrecord.lang);
  strmaxcpy(str,text,STRLEN);
  k = strlen(str) - 1;
  if (str[k++] != '\n') {
    str[k++] = '\n';
    str[k] = '\0';
  }
  zeilen = 4;
  spalten = 5;
  k = 5;
  for (sp=str; *sp!='\0'; sp++) {
    if (*sp == '\n') {
      zeilen++;
      if (k > spalten) spalten = k;
      k = 5;
    }
    else {
      k++;
    }
  }
  k = strlen(conttxt) + 4;
  if (spalten < k) spalten = k;
  if (zeilen > LINES) zeilen = LINES;
  if (spalten > COLS) spalten = COLS;
  
  getyx(stdscr,oldy,oldx);
  if ((twin=newwin(zeilen,spalten,(LINES-zeilen)/2,(COLS-spalten)/2)) == NULL) {
    fprintf(stderr,"\ncannot open window\n");
    getch();
    return(-1);
  }
  bgbp = savebackground(twin);
  werase(twin);
  box(twin,'|','-');
  if (*header != '\0') {
    wmove(twin,0,(spalten-strlen(header))/2);
    waddstr(twin,header);
    k = 2;
    wmove(twin,k++,2);
    for (sp=str; *sp!='\0'; sp++) {
      if (*sp == '\n') {
        wmove(twin,k++,2);
      }
      else {
        waddch(twin,*sp);
      }
    }
  }
  if (waittime > 0) {
    wrefresh(twin);
    sleep(waittime);
  }
  else {
    wmove(twin,zeilen-1,(spalten-strlen(conttxt))/2);
    waddstr(twin,conttxt);
    wrefresh(twin);
    waitonkeypress(TRUE);
  }
  restorebackground(twin,bgbp);
  delwin(twin);
  move(oldy,oldx);
  refresh();
  return 0;
}


char *savebackground(WINDOW *win)
{
  int x, y;
  char *buf;
  
  if ((buf=(char *)malloc((win->_maxx*win->_maxy)*sizeof(char)))==NULL) {
    return(NULL);
  }
  for (x=0; x<win->_maxx; x++) {
    for (y=0; y<win->_maxy; y++) {
      move(win->_begy+y,win->_begx+x);
      buf[x+y*win->_maxx] = inch();
    }
  }
  return(buf);
}


int restorebackground(WINDOW *win, char *buf)
{
  int x, y;
  char c;
  
  if (buf == NULL)  return(-1);
  for (x=0; x<win->_maxx; x++) {
    for (y=0; y<win->_maxy; y++) {
      c = buf[x+y*win->_maxx];
      wmove(win,y,x);
      if (c != winch(win)) {
        waddch(win,c);
      }
    }
  }
  wrefresh(win);
  free(buf);
  return(0);
}


int window_on(confrecordtyp *confrecord)
{
  char *sp;

  if (! confrecord->curses_on) {
#ifdef __hpux
    if (initscr() == NULL) {
#else
    if (initscr() == ERR) {
#endif
      sp = getenv("TERM");
      if (sp == NULL)  sp = "unknown";
      errormsg(E_LOGFILE|E_USER,confrecord,"bbs","window_on",
               "cannot start curses, TERM=%s",sp);
      return(-1);
    }
    cbreak();
    noecho();
    confrecord->curses_on = TRUE;
  }
  return 0;
}


int window_off(confrecordtyp *confrecord)
{
  if (confrecord->curses_on) {
    mvcur(0,COLS -1,LINES -1,0);
    clrtoeol();
    nocbreak();
    echo();
    refresh();
    endwin();
    confrecord->curses_on = FALSE;
  }
  return 0;
}


boolean termexists(const char *termname)
{
  char tgetentbuf[TGETENTBUF];

  return tgetent(tgetentbuf,termname);
}
