/* ix/MBox (baudrate.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #BA baudrate()        find out the communication speed of a terminal
   #PF perf()            graphical performance display

   Contact <volkers@unnet.wupper.de> for help! */

#include <stdio.h>
#include <time.h>
#include <sys/times.h>
#include <signal.h>

#include "mbox.h"


#ifdef _SYS7	/* UNIX System 7  (MINIX, COHERENT, ...) */

#include  <sgtty.h>
static struct sgttyb told;

#else		/* UNIX System V  (UNIX, XENIX, ESIX, ...) */

#ifdef _LINUX
#include  <termio.h>
#else
#include  <sys/termio.h> 
#endif
static struct termio told;

#endif


#if defined(_SUNOS) && !defined(CLOCKS_PER_SEC)
#define CLOCKS_PER_SEC 100 	/* Just lousy, but will do ... */
#endif 


#define BYTE	0377	/* Don't ask me, ask Andy !! */


/* #BA - Find out which baudrate is used. Start with 'try' BPS. */

int baudrate( try )
int try;
{
  int guess = -1;


  if(BAUDRATE != 0) return BAUDRATE;

#ifdef _SYS7
  
  ioctl( 0, TIOCGETP, &told );
  guess = (int) (100 * (told.sg_ospeed & BYTE));

#else

  ioctl( 0, TCGETA, &told );

  if(told.c_cflag &=    B300) guess = (int)   300;
  if(told.c_cflag &=   B1200) guess = (int)  1200;
  if(told.c_cflag &=   B2400) guess = (int)  2400;
  if(told.c_cflag &=   B4800) guess = (int)  4800;
  if(told.c_cflag &=   B9600) guess = (int)  9600;
  /*
  if(told.c_cflag &=  B14400) guess = (int) 14400;
  */
  if(told.c_cflag &=  B19200) guess = (int) 19200;
  if(told.c_cflag &=  B38400) guess = (int) 38400;

#endif

#ifdef _BAUDRATE  	/* HST with 'fixed baudrate 19.2k' */
	
  guess = 300;

  if(try >   300) guess =  1200;
  if(try >  1200) guess =  2400;
  if(try >  2400) guess =  9600;
  if(try >  9600) guess = 14400;
  if(try > 14400) guess = 16800;
  if(try > 16800) guess = 19200;  

#endif

  return guess;

}



/* #PF - Display the system and line performance to a user. */

perf()
{
  struct tms tmsbuf, tmnbuf;
  struct tms whsbuf, whnbuf;
  int i, j;
  int a, b;
  int bps;

  int fpid;
  int pos = strlen(BAU01_MSG) + 1;

  int pause = 0;

  long ts, tn;


  if(USER.terminal == 4){
	printf(" <- %s\n", BAU04_MSG );
	return;
  }


  switch( (fpid = fork()) ){
	case -1 :
		break;
	case  0 : 
#ifndef _ESTDIO		
		nice( 10 );
#endif
		headline( BAU02_MSG );

		ansi2( "cm", 1, 5 );
		ansi2( "us", 0, 0 );
		printf("---+-----+--------------------------+------------------+------------------+----");
		ansi2( "cm", 1, 7 );
		printf("---+-----+--------------------------+------------------+------------------+----");
		ansi2( "cm", 1, 8 );
		printf("  300   2400                       9600              14400              19200  ");

		ansi2( "cm", 1, 12 );
		printf("-----------+-----------+-----------+-----------+-----------+-----------+-------");
		ansi2( "cm", 1, 14 );
		printf("-----------+-----------+-----------+-----------+-----------+-----------+-------");
		ansi2( "cm", 1, 15 );
		printf("          1.5k        3.0k        3.5k        4.0k        4.5k        5.0k     ");
		ansi2( "cm", 1, 16 );
		printf("           15k         30k         35k         40k         45k         50k     ");

		ansi2( "cm", 1, 19 );
		printf("----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----");
		ansi2( "cm", 1, 21 );
		printf("----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----");
		ansi2( "cm", 1, 22 );
		printf("1%%                                    50%%                                  100%%");

		ansi2( "me", 0, 0 );
		ansi2( "md", 0, 0 );
		ansi2( "mb", 0, 0 );
		ansi2( "cm", 1, 6 );
		printf("%s", BAU03_MSG );

		ansi2( "me", 0, 0 );
		ansi2( "cm", 1, 24 );
		ansi2( "mr", 0, 0 );
		printf("%s", BAU01_MSG );

		while(1){	

			times(&whsbuf);

			/* BAUDRATE */
	
			ansi2( "cm", pos, 24 );

			i = 0;
			time(&ts);
			ts += 10;
			do{
				printf(" %c", 8);
				time(&tn);
				i++;
			}while(tn < ts);

			i /= 5;

			bps = (i * 11);

			ansi2( "cm", 1, 6 );
			ansi2( "mr", 0, 0 );

			j = bps / (260 - (60000/bps));	

			if(j > 79) j = 79;

			for(i = 1; i <= j; i++) 
			printf(" ");
	
			ansi2( "me", 0, 0 );

			for(i = 79; i > j; i--)
				printf(" ");

			ansi2( "cm", 1, 4 );
			ansi2( "md", 0, 0 );
			printf("BAUDRATE: %d BPS, %d CPS (effektiv)              ", bps, (bps / 11));
			ansi2( "cm", pos, 24 );

			/* BAUDRATE */

			sleep( pause );

			/* FLOPS */

			times(&tmsbuf);
			tmsbuf.tms_stime += (CLOCKS_PER_SEC / 3);
			j = 0;
			do{
				a = fix( (100 / 95) );
				b = flt( (100 / 95) );		
				j++;
				times(&tmnbuf);
			}while(tmnbuf.tms_stime < tmsbuf.tms_stime);

			ansi2( "cm", 1, 13 );
			ansi2( "mr", 0,  0 );
	
			j *= 3;
			a = (j * 100) / 10000;
			a = (a * 80)  / 100;
			/*
			if(a > 79) a = 79;
			*/
			if(a > 79) a /= 100;

			for(i = 1; i <= a; i++) 
				printf(" ");

			ansi2( "me", 0, 0 );
		
			for(i = 79; i > a; i--)
				printf(" ");


			ansi2( "cm", 1, 11 );
			ansi2( "md", 0,  0 );
			printf("FLOPS: %d                 ", j);
			ansi2( "cm", pos, 24 );

			/* FLOPS */
				
			sleep( pause );

			/* USAGE */

			times(&whnbuf);

			a = whnbuf.tms_stime - whsbuf.tms_stime;
			b = whnbuf.tms_utime - whsbuf.tms_utime;

			ansi2( "cm", 1, 18 );
			ansi2( "md", 0,  0 );
			printf("USAGE: ");
			ansi2( "me", 0, 0 );
			printf("%d SYS", a);
			ansi2( "md", 0, 0 );
		        printf(", %d USR                 ", b);

			j = (a * 100) / (a + b);
			j = (j * 80)  / 100;

			ansi2( "cm", 1, 20 );
			ansi2( "me", 0,  0 );

			if(j > 79) j = 79;	

			for(i = 1; i <= j; i++) 
				printf("=");
	
			ansi2( "md", 0, 0 );
	
			for(i = 79; i > j; i--)
				printf("=");

			ansi2( "me", 0, 0 );

			/* USGAGE */
			
			ansi2( "cm", pos, 24 );

			pause = 2;

			sleep( pause );
		}
  }
  i = getch();
  kill( fpid, SIGKILL );
  (void) wait( &fpid );		
  
  ansi2( "cm", 1, 23 );
  printf("%c", CR);

}
