/* ix/MBox (befehl.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #BE bef()              handles user commands 
   #XT xtension()	  another way of extending bbs commands

   Contact <volkers@unnet.wupper.de> for help! */


 


#include <stdio.h>

#include "mbox.h"


void xtension();


/* #BE - Handles users commands depending on the following parameters:

         [befehl] may be any command which has to be recognized, or     
                  '?' to order a list of reachable commands.

	 [arg] contains a '*' to order a list of all commands, without
               dependence on user levels.

         
   The functions returns '-1' to tell that the user level isn't high
   enought to execute the command. A '-9' means, the command is not
   known. 

   Any other positive return value is the number of a regular BBS command.
   Have a look at "loop.c", function "loop()" to understand this! */

int bef(befehl, arg)
UNSIGNED char befehl[];
UNSIGNED char arg[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char o[STRING];
  UNSIGNED char tmp[STRING];
 
  int b = 0, i = 0, l;
  int p;
  int toggle = 1;

  FILE *fp;

  l = USER.level;

  if (befehl[0] == '?') {

	sprintf(tmp, "%s/surf.%d", TMP, getpid());

	if (arg[0] == '*'){
		l = 9999;
		unlink(tmp);
	}
	
	fp = fopen( tmp, "r" );
	if(fp != NULL){
		fclose(fp);
		show( tmp, 9999, USER.more );	
		return;
	}

	fp = fopen( tmp, "w" );
	if(fp == NULL){
		nerror("befehl.c", 56, "bef", "Can't write to", tmp);
	}
	
	p = 0;
	strcpy(o, "08/15");

	while (BEF[b].id != -1) {
		if ((BEF[b].prototyp == 1) && (BEF[b].in <= l)) {
		
			strcpy(s, (UNSIGNED char *) strcopy(o, 0, p));

			if(strcomp(s, BEF[b].befehl) == 0){
				do{
					p++;
					strcpy(s, (UNSIGNED char *) strcopy(o, 0, p));
				}while((strcomp(s, BEF[b].befehl) == 0) && 
					(p <= strlen(BEF[b].befehl) - 1) &&
					(p <= strlen(o) - 1));
			}
			else{
				if(o[0] == BEF[b].befehl[0]){
					p = 0;
					while(o[p] == BEF[b].befehl[p]) p++;
				}
				else{
					p = 0;
				}
			} 

			strcpy(o, (UNSIGNED char *) BEF[b].befehl);

			if(USER.terminal != 4){
				if(USER.terminal != ISO6429){
					strcpy(s, (UNSIGNED char *) termansi( "md" ));
					fputs(s, fp);
					fprintf(fp, "%s", strcopy(BEF[b].befehl, 0, p));
					strcpy(s, (UNSIGNED char *) termansi( "me" ));
					fputs(s, fp);
				}
				else{
					if(toggle == 1)
						strcpy(s, (UNSIGNED char *) termansi( "XA" ));
					else
						strcpy(s, (UNSIGNED char *) termansi( "XB" ));
					fputs(s, fp);

					fprintf(fp, "%s", strcopy(BEF[b].befehl, 0, p));
					if(toggle == 1)
						strcpy(s, (UNSIGNED char *) termansi( "XC" ));
					else
						strcpy(s, (UNSIGNED char *) termansi( "XD" ));
					fputs(s, fp);
				}
			}
			else{
				fprintf(fp, "%s", upcased( (UNSIGNED char *) strcopy(BEF[b].befehl, 0, p) ));	
			}

			fprintf(fp, "%-*.*s", (14-p), (14-p), (UNSIGNED char *) strcopy(BEF[b].befehl, (p+1), 80));

			i++;
			if (i == 5) {
				fputs("\n", fp);
				i = 0;
				if(toggle == 1)
					toggle = 0;
				else
					toggle = 1;
			}
			else fputs(" ", fp);
		}
		b++;
	}

	if(i != 0){
		strcpy(s, "                                                                                ");
		s[(79 - (16 * i))] = '\0';
		fprintf(fp, "%s\n", s);
	}
	else fputs("\n", fp);

	fclose(fp);
	show( tmp, 9999, USER.more );

	if (arg[0] == '*'){
		unlink(tmp);
	}

	return 0;
  }
  else {
	while (BEF[b].id != -1) {
		if (strcomp(befehl, BEF[b].befehl) == 0) {
			if (BEF[b].in <= USER.level){
				if(BEF[b].id == 1000){
					
					if(is_premium( (UNSIGNED char *) BEF[b].befehl, 0 ) == -1){
						return 1;
					}
					if(strcomp("XTENSION", BEF[b].pfad) == 0){
						xtension( BEF[b].befehl, arg );
					}
					else{
						printf("\n\n");
						if(arg[0] == '\0')
							sprintf(s, "exec %s %s %d %d", RSH, BEF[b].pfad, OLDUID, OLDGID);
						else
							sprintf(s, "exec %s %s \"%s\" %d %d", RSH, BEF[b].pfad, arg, OLDUID, OLDGID);			
						system(s);
					}
					return 1;
				}
				return BEF[b].id;
			}
			else{
				return -1;
			}
		}
		b++;
	}
	return -9;
  }
}



#define SYNTAXERR( _LINE_ )		printf("\n\nXT: Syntax error in line %d.\n", _LINE_)
#define SIGNERR( _SIGN_, _LINE_ )	printf("\n\nXT: Too much '%c' signs in line %d.\n", _SIGN_, _LINE_)



/* #XT - Handle scripts written by sysops to be execute as "user defined
   commands" (see also [./etc/list.udc]) */

void xtension( command, arg )
UNSIGNED char command[], arg[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char u[STRING];
  UNSIGNED char sellab[STRING][20];
  UNSIGNED char selcom[STRING][20];
  UNSIGNED char varn[STRING][20];
  UNSIGNED char vari[STRING][20];
  int varp;

  FILE *fp;

  int line = 0;
  int i, j;
  int w, v;
  int a[20], ap; /* " */
  int b[20], bp; /* ( */
  int c[20], cp; /* ) */
  int d[20], dp; /* , */
  int e = 0; 
  int cmd = 0;
  int selp = 0;
  int selecting = 0;
  

  varp = 0;

  for(i = 0; i < 20; i++) vari[i][0] = '\0';

  sprintf(t, "./etc/xtensions/%s", (UNSIGNED char *) lowcased( command ));
  fp = fopen( t, "r" );
  if(fp == NULL){
	nerror("befehl.c", 210, "xtension", "Can't read", t);
  }

  while(fgets(s, STRING, fp) != 0){
	line++; ap = 0; bp = 0; cp = 0; dp = 0; i = 0; e = 0; cmd = 0;
 
        strcpy(t, (UNSIGNED char *) stripped(s));

	RERUN:

 	while(t[i] != '\0'){
		if(t[i] == '"'){
			a[ap] = i; ap++;
			if(ap >= 20) SIGNERR( '"', line );
		}
		if(t[i] == '('){
			b[bp] = i; bp++;
			if(bp >= 20) SIGNERR( '(', line );
		}
		if(t[i] == ')'){
			c[cp] = i; cp++;
			if(cp >= 20) SIGNERR( ')', line );
		}
		if(t[i] == ','){
			d[dp] = i; dp++;
			if(dp >= 20) SIGNERR( ',', line );
		}
		if(t[i] == '$'){
			strcpy(s, (UNSIGNED char *) strcopy(t, i+1, strlen(t)));
			if(strcomp("ARG", s) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(t, 0, i-1));
				strcpy(u, (UNSIGNED char *) strcopy(t, i+4, strlen(t)));
				sprintf(t, "%s%s%s", s, arg, u );
			}
			if(strcomp("USERNAME", s) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(t, 0, i-1));
				strcpy(u, (UNSIGNED char *) strcopy(t, i+9, strlen(t)));
				sprintf(t, "%s%s%s", s, USER.name, u );
			}
			if(strcomp("TIME", s) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(t, 0, i-1));
				strcpy(u, (UNSIGNED char *) strcopy(t, i+5, strlen(t)));
				sprintf(t, "%s%s%s", s, (UNSIGNED char *) mytime(0), u );
			}
			if(strcomp("DATE", s) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(t, 0, i-1));
				strcpy(u, (UNSIGNED char *) strcopy(t, i+5, strlen(t)));
				sprintf(t, "%s%s%s", s, (UNSIGNED char *) mydate(0), u );
			}
			if(strcomp("MBOXHOME", s) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(t, 0, i-1));
				strcpy(u, (UNSIGNED char *) strcopy(t, i+9, strlen(t)));
				sprintf(t, "%s%s%s", s, HOME, u );
			}
			if(strcomp("TERMINAL", s) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(t, 0, i-1));
				strcpy(u, (UNSIGNED char *) strcopy(t, i+9, strlen(t)));
				sprintf(t, "%s%s%s", s, TERMINAL, u );
			}
		}
		if(t[i] == '='){
			if(e == 0) e = i;
		}
		i++;
	}	

	if((strcomp("REM", t) == 0) ||
           (strcomp("LABEL", t) == 0)){
		cmd++;
		continue;
	}
	if(strcomp("HEADLINE", t) == 0){
		if(ap == 2){
			strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[1]-1));
			headline( s );
		}
		else SYNTAXERR( line );
		cmd++;
	}
	if(strcomp("HEADBLOCK", t) == 0){
		if(ap == 4){
			strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[1]-1));
			strcpy(u, (UNSIGNED char *) strcopy(t, a[2]+1, a[3]-1));
			headblock( s, u );
		}
		else SYNTAXERR( line );
		cmd++;
	}	
	if(strcomp("ANSI", t) == 0){
		if(ap == 2){
			strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[1]-1));
			if(dp == 0){
				ansi( s );
			}
			else{
				if(dp == 2){
					strcpy(u, (UNSIGNED char *) strcopy(t, d[0]+1, d[1]-1));
					strcpy(u, (UNSIGNED char *) stripped( u ));
					i = atoi( u );
					strcpy(u, (UNSIGNED char *) strcopy(t, d[1]+1, strlen(t)));
					strcpy(u, (UNSIGNED char *) stripped( u ));
 					j = atoi( u );
					ansi2( s, i, j );
				}				
				else SYNTAXERR( line );
			}
		}
		else SYNTAXERR( line );
		cmd++;
	}
	if(strcomp("SAY", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		printf("%s", s);
		if((t[strlen(t)-1] != ';') && (t[3] != '-')) printf("\n");
		cmd++;
	}
	if(strcomp("SYSTEM", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		system( s );
		cmd++;
	}
	if(strcomp("SLEEP", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, (b[0]+1), strlen(t)));
		sleep( atoi(s) );
		cmd++;
	}
	if(strcomp("WAITKEY", t) == 0){
		(void) getch();
		cmd++;
	}
	if(strcomp("BEEP", t) == 0){
		printf("%c", 7);
		cmd++;
	}
	if(strcomp("GOTO", t) == 0){
		sprintf(s, "LABEL %s", (UNSIGNED char *) strcopy(t, 5, strlen(t)));
		rewind( fp );
		while((fgets(t, STRING, fp) != 0) && (strcomp(s, (UNSIGNED char *) stripped(t)) != 0));
		cmd++;
	}
	if(strcomp("SELECT", t) == 0){
		selecting = 1;
		selp = 0;
		cmd++;
	}
	if(strcomp("COMMAND", t) == 0){
		selecting = 2;
		selp = 0;
		cmd++;
	}
	if(strcomp("ENDSELECT", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		printf("%s", s);
		selecting = 0;

		do{
			w = getch() - 48;
		}while((w < 1) || (w > selp));
		printf("%c\n", (w+48));
		sprintf(t, "GOTO %s", sellab[(w-1)]);
		goto RERUN;
	}
	if(strcomp("ENDCOMMAND", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		printf("\n");
		if(USER.terminal != ISO6429)
			ansi2("md", 0, 0);
		else
			ansi2("X4", 0, 0);
		printf("[%s] %s >", s, LOP06_MSG);
		ansi2("me", 0, 0);
		printf(" ");
		if (USER.bell == 1) printf("%c", BELL);

		selecting = 0;
		strcpy(s, (UNSIGNED char *) getline( 70, 1, ' ', ""));
		w = -1;
		for(v = 0; v < selp; v++){
			if(strcomp(selcom[v], s) == 0) w = v;
		}
		if(w != -1){
			sprintf(t, "GOTO %s", sellab[w]);
			goto RERUN;
		}
		else{
			printf(" <- Command not found.\n");
		}
		cmd++;
	}
	if(strcomp("YESNO", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		printf("%s", s);
		w = getch(); if(w >= 97) w -= 32;
		if((w == 'Y') || (w == GBL06_MSG)){
			strcpy(s, (UNSIGNED char *) strcopy(t, d[0]+1, d[1]-1));
		}
		else{
			strcpy(s, (UNSIGNED char *) strcopy(t, d[1]+1, c[0]-1));
		}
		sprintf(t, "GOTO %s", (UNSIGNED char *) stripped(s));
		goto RERUN;
	}
	if(strcomp("FILE", t) == 0){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		show(s, 9999, USER.more);
		cmd++;
	}

	if((cmd == 0) && (selecting != 0) && (dp > 0)){
		strcpy(s, (UNSIGNED char *) strcopy(t, a[0]+1, a[ap-1]-1));
		strcpy(selcom[selp], (UNSIGNED char *) stripped(s));
		if(selecting == 1) printf(" %d - %s\n", selp+1, s);
		strcpy(sellab[selp], (UNSIGNED char *) stripped(strcopy(t, 0, d[0]-1)));	
		selp++;
	}
  }
  fclose(fp);

  printf("\n");
}
