/* ix/MBox (getch.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #GE getch()            read a char, return anyway

   Contact <volkers@unnet.wupper.de> for help! 


   !!! See below to find out who wrote this one!!! */




/*
 *	%Z% %M%	%I% %D% %Q%
 *
 *	Copyright (C) 1990 by Christian Schlichtherle
 *			      (chriss@attron.ruhr.sub.org)
 *
 *	%M% - C module for getch(S).
 *
 *	"getch" is a DOS and curses(S) like function which reads
 *	a UNSIGNED character and returns immediately without waiting for
 *	newline.
 *
 * 	getch() - Gets a UNSIGNED character.
 * 	This function gets one UNSIGNED character and immediately returns
 * 	without waiting for newline. The UNSIGNED character is not echoed.
 * 	This function can be used best when you want to input only one
 * 	UNSIGNED character within canonical input or if you need this function
 * 	only very rarely.
 * 	EOF is returned on errors or if an ignored signal occured.
 *	
 *	Modificated by andreas@xenox.w.open.de 06/20/92 Xenox
 */

#include "defs.h"
#include <sys/types.h>
#include <stdio.h>    
#include <errno.h>

#ifndef _SYS7
#include <sys/ioctl.h>

#ifdef _LINUX
#include <termio.h>
#else
#include <sys/termio.h>
#endif

#else
#include <sgtty.h>
#endif 

#ifndef _SYS7
static struct termio	told, tnew;

#define	get_oldmode()	ioctl(0,TCGETA, &told)
#define	set_oldmode()	ioctl(0,TCSETA, &told)
#define	set_newmode()	(tnew.c_cc[VMIN] = 1,tnew.c_cc[VTIME] = 0,\
			 tnew.c_lflag &= ~(ICANON | ECHO),\
			 ioctl(0, TCSETA, &tnew))

#else
static struct sgttyb	told, tnew;

#define	get_oldmode()	ioctl(0,TIOCGETP, &told)
#define	set_oldmode()	ioctl(0,TIOCSETP, &told)
#define	set_newmode()	(tnew.sg_flags |= RAW,tnew.sg_flags &= ~ECHO,\
			 ioctl(0, TIOCSETP, &tnew))

#endif

static int	set = 0;

int	getch()
{
	int	c;

#ifdef _PROFILE
  profile( "getch()" );
#endif

	if (!set) {
			/* Get old terminal mode. */
		if (get_oldmode() == -1)
			return (EOF);

		tnew = told;
			/* Don't execute this part anymore. */
		set = 1;
	}

		/* Set new terminal mode. */
	if (set_newmode() == -1)
		return (EOF);

		/* 
		 * Read one character. The orginal function used 
		 * read(0, &c, 1) but getchar is a macro 
		 * and faster. Xenox Fri Jun 19 20:44:46 DST 1992
		 */
	c = getchar();

        set_oldmode();

	return ((int)c);
}



