// Filename:   lang.h
// Contents:   the object definition for the Language object
// Author: Gregory Shaw
// Created:    11/5/94

#ifndef _LANG_H_
#define _LANG_H_
/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include "bbshdr.h"

// size definitions
// 307 unique IDs
#define HASH_TABLE_SIZE        307
// max length of language filename
#define MAX_LANGUAGE_FILENAME  30
// big space for language strings
#define LANGUAGE_TEMP_BUF  4096 // 4k temporary buffer
#define MAX_IDENT      100      // largest identity
#define MAX_LANGUAGES      10   // 10 languages supported, max

// Structure:  lang_hash
// Purpose:    the structure used to hold the strings used by the BBS
// Author:     Gregory Shaw
// Created:    12/1/94

struct lhash
{
	char   *l_ident;            // identifier
	char    *l_text;            // text of string
	struct lhash *h_next;       // next item
};


typedef struct lhash lang_hash;


// Object: language
// Purpose:    serve as a language independant string lookup facility
// Attributes: current_language - the current language in use
// Methods:    send_ident - lookup a string by identifier and write to user.
//     yesno - get a yes or no character from user
// Author: Gregory Shaw
// Created:    11/5/94

class language: public color
{
	int    add_node(char *ident, char *string);
	// generate hash
	unsigned long  hashpjw(const char* x);
	char   *lookup(char *ident);// lookup string
	public:
		language();             // constructor
		~language();            // destructor
		// current language
		char   *current_lang(void);
		// return default language
	char   *default_language(void);
	void   dump(void);          // dump object contents
	void   efficiency(void);    // dump efficiency of hash
	char   *gstrl(char *ident); // return character string from ident
	int    l_close(void);       // cleanup object
	// configure for language
	int    l_open(char *lang_name);
	int    sstrcrl(char *ident);// send ident with CR
	int    sstrl(char *ident);  // send ident w/o CR
	// select language
	void   select_lang(char *lang);
	int    yesno(void);         // get yes or no from user
};


#endif                          // _LANG_H_






