// Filename:   montest.C
// Contents:   a simple program to test sysop monitor functionality
// Author: Greg Shaw
// Created:    7/23/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _MONTEST_C_
#define _MONTEST_C_

#include "bbshdr.h"

// Function:   char_avail
// Purpose:    return true of a character is available on stdin
// Input:  none
// Output: true/false
// Author: Greg Shaw
// Created:    6/10/94

int char_avail(void)
{
	struct fd_set fds[2];
	struct timeval waittime;

	waittime.tv_sec = 0;
	waittime.tv_usec = 100;


	FD_SET(fileno(stdin), fds);
	if (select(getdtablesize(),fds,NULL,NULL,&waittime))
		return(1);
	return(0);
}


main()
{
	bbsipc iobj;                // interface (server) object
	char   msg[255];
	char   outmsg[10];

	if (iobj.open_sock(NULL,MONITOR_PORT) != 0)
	{
		printf("Unable to open server socket.\r\n");
		return(0);
	}
	iobj.do_connect(1);
	fflush(stdout);
	iobj.send(MONITOR_ON);      // turn on monitoring
	while (1)
	{
		if (iobj.msg_avail(1) < 0)
		{
			iobj.do_connect(1);
			// turn on monitoring
			iobj.send(MONITOR_ON);
		}
		else
		{
			if (iobj.receive(msg) < 0)
			{
				iobj.do_connect(1);
				// turn on monitoring
				iobj.send(MONITOR_ON);
			}
			else
			{
				printf("%s",msg);
				fflush(stdout);
			}
			if (char_avail())   // has SysOp typed something?
			{
				// get string
				scanf("%s",outmsg);
				iobj.send(outmsg);
			}
		}
	}
}


#endif






