/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../config.h"                          /* sysop configable stuff   */

/* paths to various data files.                                             */
/* you can change anything below, but keeping the same will make it easier  */
/* to debug (some errors have the names hardcoded, and it will be easier    */
/* for me to help you over email if I know what your talking about          */
#define F_BASES "dat/bases.dat"                 /* base information file    */
#define F_USERS "dat/users.dat"                 /* user information file    */
#define F_PLANDIR "plan/"                       /* prefix for plan files    */
#define F_MDATAEXT ".msg"                       /* extension for mdata fls  */
#define F_MIDXEXT ".idx"                        /* extension for m idx fls  */
#define F_MSGDIR "msg/"                         /* dir for message data     */
#define F_GFILDIR "gfil/"                       /* dir for gfiles data      */
#define F_TXTDIR "txt/"                         /* dir for text data        */
#define F_SLASTU "txt/lastuser.txt"             /* path to lastuser file    */
#define F_ACCESSCONT "yabbsaccess"              /* path to access control f */

/* strings                                                                  */
#define S_NULLBASE "null base"                  /* name for un-used bases   */
#define S_SYSOPBASE "sysop"                     /* name for all email base  */

/* macros                                                                   */
#define nullbase(baseid) (strcmp(base[baseid].title, S_NULLBASE) == 0)
#define sysopbase(baseid) (strcmp(base[baseid].title, S_SYSOPBASE) == 0)
