/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * baseed.c - part of the yabbs bulletin board package by alex wetmore
 *            see bbs.c for information on the system and copying.
 */

#include <stdio.h>
#include "bbs_struct.h"
#include "bbs_files.h"
#include "util_common.h"

#define M_BASEED "+)next    -)prev    d)atafile t)itle   m)ax msgs
j)ump     f)ind     s)ub all  v)save   q)uit\n"

brec *base;

/*
 * search for a message base when given a substring
 */

int be_findbase(void) {
    int     i;
    char    title[33];

    sputs("title? ");
    sgets(title, 32);
    for (i = 0; i < MBASES; i++)
        if (strstr(base[i].title, title) != NULL) return i;
    sputs("base not found");
    return 0;
}

/*
 * Put all of the vital information for base <b> on the screen.
 */

void be_drawbase(int b) {
    char st[255];

    sprintf(st, "\nbase: [%i]  title: [%s]  datafile: [%s]  max: [%i]\n",
        b, base[b].title, base[b].dfile, base[b].max);
    sputs(st);
}

/*
 * the main menu (only menu) for the base editor
 */

void editbases(void) {
    int     b, done, i;
    char    cmd[255];

    done = FALSE;
    b = 0;

    while (!done) {
        be_drawbase(b);
        sputs(M_BASEED);
        sprintf(cmd, "[%c-%s][%d/%d]> ", (b + BASEOF), base[b].title, b, MBASES - 1);
        sputs(cmd);
        cmd[0] = readc();
        writec(cmd[0]); sputs("\n");
        switch (cmd[0]) {
            case '+' :  if (b < MBASES - 1) b++; break;
            case 'n' :  if (b < MBASES - 1) b++; break;
            case '-' :  if (b > 0) b--; break;
            case 'p' :  if (b > 0) b--; break;
            case 't' :  sputs("new title? ");
                        sgets(base[b].title, 32);
                        break;
            case 'd' :  sputs("new data file? ");
                        sgets(cmd, 12);
                        strcpy(base[b].dfile, cmd);
                        if (b == 0) {
                            char buf[255];

                            sprintf(buf, "%s%s", F_MSGDIR, base[b].dfile);
                            mkdir(buf, 0755);
                        }
                        break;
            case 'm' :  sputs("maximum messages? ");
                        sgets(cmd, 5);
                        base[b].max = atoi(cmd);
                        break;
            case 'j' :  sputs("which base? ");
                        sgets(cmd, 2);
                        b = upper(cmd[0]) - BASEOF;
                        if (b < 0) b = 0;
                        if (b >= MBASES) b = MBASES - 1;
                        break;
            case 'f' :  b = be_findbase(); break;
            case 'v' :  writebases(base); writeusers(); break;
            case 'r' :  for (i = 0; i < usernum; i++) {
                            user[i].access = (user[i].access & ~power(2, b));
                            user[i].sub = (user[i].sub & ~power(2, b));
                        }
                        break; 
            case 's' :  for (i = 0; i < usernum; i++) {
                            user[i].access = (user[i].access | power(2, b));
                            user[i].sub = (user[i].sub | power(2, b));
                        }
                        break;
            case 'q' :  cmd[0] = ynprompt("save? ", TRUE); 
                        if (cmd[0]) { writebases(base); writeusers(); }
                        done = TRUE;
                        break;
            default  :  sputs("what?\n");
            sputs("\n");
        }
    }
}

void main(int argc, char **argv) {
    brec **basep;

    base = (brec *) malloc(sizeof(brec) * MBASES);
    basep = &base;

    noecho();
    chdir(F_PATH);
    sputs("yabbs base editor - alex wetmore");
    sputs("\n\nreading user file: "); sputs(F_USERS); 
    readusers(); 
    sputs("\nreading base file: "); sputs(F_BASES); sputs("\n");
    readbases(basep);
    editbases();
    echo();
}
